/*
 * This file is part of osso-dsp-headers-su-18
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Markku Vorne <markku.vorne@nokia.com>
 *
 * This software, including documentation, is protected by copyright controlled by Nokia Corporation. All rights are reserved.
 * Copying, including reproducing, storing, adapting or translating, any or all of this material requires the prior written  
 * consent of Nokia Corporation. This material also contains confidential information which may not be disclosed to others 
 * without the prior written consent of Nokia.
 */

#ifndef __INTERFACE_COMMON_H__
#define __INTERFACE_COMMON_H__

#define BRIDGE_BUFFER_SIZE        512
#define DSPCTL_WRITEREQ           0x81 // Request data write command.

#define DSP_CMD_NONE              0x00 // No command.
#define DSP_CMD_INIT              0x01 // Identifies initialisation data.
#define DSP_CMD_SET_PARAMS        0x02 // Set DSP audio task parameters.
#define DSP_CMD_DATA_WRITE        0x03 // Identifies general stream data.
#define DSP_CMD_PLAY              0x04 // Set DSP task into play state.
#define DSP_CMD_PAUSE             0x05 // Set DSP task into pause state.
#define DSP_CMD_STOP              0x06 // Set DSP task into stop state.
#define DSP_CMD_SET_VOLUME        0x07 // Set volume.
#define DSP_CMD_STATE             0x08 // Set DSP audio state.
#define DSP_CMD_SET_TIME          0x09 // Set presentation time.
#define DSP_CMD_GET_TIME          0x0A // Get presentation time.
#define DSP_CMD_SET_POSTPROC      0x0B // Set post-processing data.
#define DSP_CMD_VIDEO_INFO        0x0C // Set DSP video task state info.
#define DSP_CMD_SET_PANNING       0x0D // Set panning data.
#define DSP_CMD_DISCONT           0x0E // Inform DSP task about a discontinuity
                                       // in the stream.
#define DSP_CMD_MUTE              0x0F // Mute audio stream.
#define DSP_CMD_UNMUTE            0x10 // Unmutes audio stream.
#define DSP_CMD_REG_VDSTRM        0x11 // Tells the DSP to register a new video 
                                       // stream in the a/v sync task.
#define DSP_CMD_ENDSTREAM         0x12 // Deletes a registered stream entry in the
                                       // Sync clock task.
#define DSP_CMD_STRM_RESET        0x13 // Resets the time value for the 
                                       // corresponding stream.
#define DSP_CMD_CLOSE             0x14 // Closes the DSP task
#define DSP_CMD_SET_POSTPROC_INIT_PARAMS      0x15 
#define DSP_CMD_SET_POSTPROC_EQ_PARAMS	      0x16 
#define DSP_CMD_SET_POSTPROC_MUSICDRC_PARAMS  0x17 
#define DSP_CMD_CHANGE_MUSICDRC_HPFILT_COEFFS 0x18 
#define DSP_CMD_GET_POSTPROC_PARAMS	      0x19 
#define DSP_CMD_BYPASS_POSTPROCCESSING	      0x20
#define DSP_CMD_SET_MODE          0x21 // Used in AMR Decoder.
#define DSP_CMD_EOF               0x22 // Implies end-of-file.
#define DSP_CMD_DMA_CONTROL       0x23 // Enable/disable DSP DMA. Should be used 
                                       // by DSP tasks in DSP kernel.
#define DSP_CMD_SKIP              0x24 // Implies frame drop from ARM side.
#define DSP_CMD_DATA_READ         0x25 // DSP->ARM data transfer.
#define DSP_CMD_SET_SPEECH_PARAMS 0x26 // Set speech task parameters.

/* DSP error values. */
#define DSP_OK                    0x01 // Operation successful.
#define DSP_ERROR_CMD             0x02 // Unrecognised command identifier.
#define DSP_ERROR_FMT             0x03 // Unrecognised stream format.
#define DSP_ERROR_RATE            0x04 // Unrecognised sampling rate.
#define DSP_ERROR_CHANNELS        0x05 // Unrecognised number of channels.
#define DSP_ERROR_DS_ID           0x06 // Src/destination stream ID out of range.
#define DSP_ERROR_MEMORY          0x07 // Insufficient memory for the operation.
#define DSP_ERROR_GENERAL         0x08 // General DSP error.
#define DSP_ERROR_STREAM          0x09 // Error in stream.
#define DSP_ERROR_STATE           0x0A // Wrong task state for command.
#define DSP_ERROR_SYNC            0x0B // Error finding sync marker in MP3 stream.

#define STATE_INITIALISED         0x00 // DSP task has been initialised.
#define STATE_PLAYING             0x01 // DSP task is playing.
#define STATE_STOPPED             0x02 // DSP task is stopped.
#define STATE_PAUSED              0x03 // DSP task is paused.
#define STATE_UNINITIALISED       0x04 // DSP task uninitialised.
#define STATE_RESET               0x05 // DSP task in in reset state.

typedef struct dsp_cmd_status {
    unsigned short int dsp_cmd;
    unsigned short int status;
} DSP_CMD_STATUS;

typedef struct write_status {
    unsigned short int dsp_cmd;
    unsigned short int status;
    unsigned short int buffer_bytes_free;
} WRITE_STATUS;

/* Data structure for GET_TIME. */
typedef struct time_data {
    unsigned short int dsp_cmd;
    unsigned short int status;
    unsigned short int stream_ID;
    long int time_ms;
} TIME_DATA;

/* General stream command data structure */
typedef struct stream_cmd_data {
    unsigned short int dsp_cmd;
    unsigned short int stream_ID;
} STREAM_CMD_DATA;

typedef struct {
    unsigned short int dsp_cmd;
    unsigned short int status;
    unsigned short int frame_size;
    unsigned int       stream_time_ms;
} READ_STATUS;

#endif // #ifndef __INTERFACE_COMMON_H__
