/**
 * @file libgalago/galago-context-base.h Galago Context Base Support
 * @ingroup Presence
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_CONTEXT_BASE_H_
#define _GALAGO_CONTEXT_BASE_H_

typedef struct _GalagoContext        GalagoContext;
typedef struct _GalagoContextClass   GalagoContextClass;
typedef struct _GalagoContextPrivate GalagoContextPrivate;

#include <libgalago/galago-object.h>

/**
 * The current context.
 *
 * The context contains the state of the current Galago connection.
 */
struct _GalagoContext
{
	GalagoObject parent_object;

	GalagoContextPrivate *priv;

#ifndef _DOXYGEN_
	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
#endif
};

/**
 * GalagoContext's class.
 */
struct _GalagoContextClass
{
	GalagoObjectClass parent_class;

#ifndef _DOXYGEN_
	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
#endif
};

#define GALAGO_TYPE_CONTEXT (galago_context_get_type())

/** Cast @c obj to a GalagoContext. */
#define GALAGO_CONTEXT(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_TYPE_CONTEXT, \
									GalagoContext))

/** Cast @c klass to a GalagoContextClass. */
#define GALAGO_CONTEXT_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_TYPE_CONTEXT, \
								 GalagoContextClass))

/** Check if @c obj is a GalagoContext. */
#define GALAGO_IS_CONTEXT(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_TYPE_CONTEXT))

/** Check if @c klass is a GalagoContextClass. */
#define GALAGO_IS_CONTEXT_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_TYPE_CONTEXT))

/** Get the class for the GalagoContext @c obj. */
#define GALAGO_CONTEXT_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS((obj), GALAGO_TYPE_CONTEXT, \
								   GalagoContextClass))

#endif /* _GALAGO_CONTEXT_BASE_H_ */
