/*
 * This file is part of maemopad
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <ui/interface.h>
#include <appdata.h>

#include <gtk/gtkmain.h>

#include <hildon-widgets/hildon-app.h>

#include <libintl.h>
#include <locale.h>
#include <libosso.h>
#include <libmb/mbutil.h>

#define _(String) gettext(String)

#define APP_NAME "maemopad"
#define APP_VER "1.1"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
 * create our application specific data
 * This consists of allocating some space
 * for the AppData structure, and also
 * creating the list store that will act
 * as a model for the contact list.
 * The other elements of the AppData structure
 * are implicitly set by the call to g_new0
 * which zeroes the memory of the AppData, thereby
 * setting create_new to FALSE, and iter to NULL.
 *
 */
static AppData *create_data ()
{
    AppData *result = g_new0( AppData, 1 );

    result->osso = osso_initialize ( APP_NAME, APP_VER, TRUE, NULL );
    g_assert ( result->osso );
    return result;
}



/* Here we clean up all the data that we allocated */
static void destroy_data ( AppData *data )
{
    g_free ( data );
}



int main( int argc, char* argv[] )
{
    AppData* data; 
    HildonApp* app; 
    MainView* main_view;

    /* Initialise the locale stuff */
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);

    /* Init the gtk - must be called before any hildon stuff */
    gtk_init( &argc, &argv );

    /* Create the hildon application and setup the title */
    app = HILDON_APP ( hildon_app_new () );
    hildon_app_set_title ( app, _("MaemoPad") );
    hildon_app_set_two_part_title ( app, TRUE );

    /* Create the data and views for our application */
    data = create_data ();
    data->app = app;
    main_view = interface_main_view_new ( data );
    hildon_app_set_appview( data->app, data->main_view );
        
    /* Begin the main app */
    gtk_widget_show ( GTK_WIDGET ( app ) );
    gtk_main();

    /* Clean up */
    interface_main_view_destroy ( main_view );
    destroy_data ( data );

    return 0;
}
