/*
 * This file is part of DSP Gateway version 3.3.1
 *
 * Copyright (C) 2003-2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Toshihiro Kobayashi <toshihiro.kobayashi@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __DLD_MEMMGR_H
#define __DLD_MEMMGR_H

#include "list.h"
#include "dsp_dld.h"

extern struct memmgr *memmgr_new(char *name, u32 base, u32 size);
extern int memmgr_validate(struct memmgr *mem);
extern void memmgr_freelist(struct list_head *list);
extern void memmgr_add(struct list_head *list, struct memmgr *mem);
extern int memmgr_register_global(struct list_head *list);
#ifndef DSP_EMULATION
extern int memmgr_exmap(struct list_head *list);
#endif
extern struct memmgr *memmgr_range_user(struct list_head *list,
					u32 base, u32 size);
extern struct memmgr *memmgr_find_by_addr(struct list_head *list,
					  u32 addr, u32 size);
extern struct memmgr *memmgr_find_by_name(struct list_head *list, char *name);
extern int space_find_by_addr(u32 addr, u32 size);
extern void memmgr_occupy_kernel(struct list_head *scnlist);
extern int memmgr_placetask(struct taskent *te, struct coffobj *cobj,
			    struct lkcmd *gbl_lkcmd);
extern void memmgr_cleartask(struct taskent *te);
extern void memmgr_sendstat(struct list_head *list, int fd);

/*
 * debug stuff
 */
extern void memmgr_printstat(struct list_head *list);

#endif /* __DLD_MEMMGR_H */
