/*
 * This file is part of DSP Gateway version 3.3.1
 *
 * Copyright (C) 2003-2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Toshihiro Kobayashi <toshihiro.kobayashi@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __DLD_COFF_H
#define __DLD_COFF_H

#include "coff-c55x.h"
#include "dsp_dld.h"

extern char *scnname(struct coff *coff, char *name);
extern char *symname(struct coff *coff, COFF_SYMENT *sym);
extern struct coffobj *coff_new(char *fn);
extern void coff_free(struct coffobj *cobj);
extern void coff_init(struct coffobj *cobj);
extern void coff_clear(struct coffobj *cobj);
#define coff_read_kernel(cobj)	coff_read(cobj,COFFTYP_KERNEL)
#define coff_read_task(cobj)	coff_read(cobj,COFFTYP_TASK)
extern int coff_read(struct coffobj *cobj, int type);

#endif /* __DLD_COFF_H */
