/*
 *  tslib/plugins/pressure.c
 *
 *  Copyright (C) 2005 Nokia Corporation
 *  Author: Lauri Leukkunen <lauri.leukkunen@nokia.com>
 *
 * This file is placed under the LGPL.  Please see the file
 * COPYING for more details.
 *
 * Filter events based on pressure value variations
 * */

#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <stdio.h>

#include "tslib.h"
#include "tslib-filter.h"

struct tslib_pressure {
	struct tslib_module_info module;
	int tail_off_step;
	int pressure_values[10];
	int pseudo_penup;
	int prev_pressure;
};

static int
pressure_read(struct tslib_module_info *info, struct ts_sample *samp, int nr)
{
	struct tslib_pressure *p = (struct tslib_pressure *)info;
	int ret;

	ret = info->next->ops->read(info->next, samp, nr);
	if (ret >= 0) {
		int n;
		for (n = 0; n < ret; n++, samp++) {
#ifdef DEBUG
                    fprintf(stderr,"BEFORE PRESSURE--------------------> %d %d %d\n",samp->x, samp->y, samp->pressure);
#endif
                    /* we occasionally get stray thumb presses with pressure 3, f.e. */
                    if (samp->pressure > 250) {
                        samp->pressure = 255;
                    }
                    if (samp->pressure > 0) {
                        samp->pressure = 255 - samp->pressure;
                    }
                    else {
                        samp->pressure = 0;
                    }
		}
	}
	return ret;
}

static int pressure_fini(struct tslib_module_info *info)
{
	free(info);
}

static const struct tslib_ops pressure_ops =
{
	read:		pressure_read,
	fini:		pressure_fini,
};

static int pressure_tail_off_step(struct tslib_module_info *inf, char *str, void *data)
{
	struct tslib_pressure *pre = (struct tslib_pressure *)inf;

	pre->tail_off_step = (int)data;
	return 0;
}



static const struct tslib_vars pressure_vars[] =
{
	{ "tail_off_step",	(void *)0, pressure_tail_off_step }
};

#define NR_VARS (sizeof(linear_vars) / sizeof(linear_vars[0]))

struct tslib_module_info *mod_init(struct tsdev *dev, const char *params)
{

	struct tslib_pressure *pre;

	pre = malloc(sizeof(struct tslib_pressure));
	
	if (!pre)
		return NULL;

	memset(pre, '\0', sizeof(pre));
	pre->module.ops = &pressure_ops;
	pre->prev_pressure = -1;
	fprintf(stderr, "initializing pressure filter...\n");
	return &pre->module;
}
