/*
 * Maemo Games Startup
 * Copyright (c) 2006 INdT.
 * @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <libosso.h>
#include "startup_plugin.h"

struct _StartupPluginPrivate {
  GModule *handle;
};

StartupPlugin *
startup_plugin_load (const gchar *path)
{
  StartupPlugin *plugin;
  GModule *handle;
  gboolean (*startup_init_plugin) ();

  g_return_val_if_fail (path != NULL, NULL);

  handle = g_module_open (path, 0);
  g_assert (handle);

  if (!g_module_symbol (handle,
        "startup_init_plugin",
        (gpointer) &startup_init_plugin)) {
    g_module_close (handle);
    return NULL;
  }
  
  plugin = g_new0 (StartupPlugin, 1);
  g_assert (plugin);

  plugin->priv = g_new0 (StartupPluginPrivate, 1);
  g_assert (plugin->priv);
  plugin->priv->handle = handle;

  if (startup_init_plugin (plugin)) 
    return plugin;

  g_module_close (plugin->priv->handle);
  g_free (plugin->priv);
  g_free (plugin);
    
  return NULL;
}

gboolean
startup_plugin_unload (StartupPlugin *plugin)
{
  g_return_val_if_fail (plugin != NULL, FALSE);

  if (plugin->priv->handle != NULL) {
    g_module_close (plugin->priv->handle);
    plugin->priv->handle = NULL;
  }

  g_free (plugin->priv);
  plugin->priv = NULL;

  g_free (plugin);

  return TRUE;
}

