/*
 * Copyright (c) 2003 Nokia
 * Author: tsavola@movial.fi
 *
 * This program is licensed under GPL (see COPYING for details)
 */

#ifndef BUFFER_H
#define BUFFER_H

#include "types.h"

/** Default capacity for buffer_t. */
#define BUFFER_SIZE 4096

/** Dynamic buffer for I/O data. */
typedef struct {
	size_t start;
	size_t end;
	bool_t eof;
	size_t mem_size;
	uint8_t *mem;
} buffer_t;

extern bool_t buf_init(buffer_t *buf);
extern void buf_free(buffer_t *buf);
extern void buf_set_eof(buffer_t *buf);
extern size_t buf_size(buffer_t *buf);
extern bool_t buf_is_empty(buffer_t *buf);
extern ssize_t buf_read_in(buffer_t *buf, int fd, size_t len);
extern ssize_t buf_write_out(buffer_t *buf, int *fd);

#endif
