/**
  @file async.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2004 Nokia. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _ASYNC_H_
#define _ASYNC_H_

#include <glib.h>
#include "obc-main.h"

void open_help(ObcContext *ctx, const char *name);
void close_help(ObcContext *ctx, const char *name);
void abort_help(ObcContext *ctx, const char *name);
void read_help(ObcContext *ctx, const char *name);

gboolean cmd_open(ObcContext *ctx, gint argc, gchar *argv[], gint *err);
gboolean cmd_close(ObcContext *ctx, gint argc, gchar *argv[], gint *err);
gboolean cmd_abort(ObcContext *ctx, gint argc, gchar *argv[], gint *err);
gboolean cmd_read(ObcContext *ctx, gint argc, gchar *argv[], gint *err);

#endif /* _GET_H_ */
