/**
  * Browser Interface.
  * @file osso-browser-interface.h:
  * Defines the DBUS service interface of the browser application.
  * @version $Rev: 1344 $
  * @date $LastChangedDate: 2005-11-03 18:08:17 +0200 (Thu, 03 Nov 2005) $
  *
  * Copyright (C) 2005 Nokia Corporation.
  *
  * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */

#ifndef __OSSO_BROWSER_INTERFACE_H__
#define __OSSO_BROWSER_INTERFACE_H__

/*!
  DBUS service provided by the browser
*/
#define OSSO_BROWSER_SERVICE           "com.nokia.osso_browser"

/*!
  DBUS Interface for requesting the service. 
*/
#define OSSO_BROWSER_REQ_INTERFACE    "com.nokia.osso_browser.request"

/**
 * DBUS object path for requesting the service. 
 */ 
#define OSSO_BROWSER_REQ_PATH         "/com/nokia/osso_browser/request"

/* URL loading service */

/**
 * Open new browser window. \n
 * \b url: The URL to load in new browser window\n
 * \b Example: Open new window with home page
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_OPEN_NEW_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_STRING, "new_window", DBUS_TYPE_INVALID);
 * \endcode
 * \b Example: Open new window with url 
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_OPEN_NEW_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_STRING, url, DBUS_TYPE_INVALID);
 * \endcode
 *
 */ 
#define OSSO_BROWSER_OPEN_NEW_WINDOW_REQ    "open_new_window"


/**
 * Load URL in current browser window.\n
 * \b url: The URL to load\n
 * \b Example: Load Home page in currently open browser window 
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_LOAD_URL_REQ, NULL, 
 *                         DBUS_TYPE_STRING, "new_window", DBUS_TYPE_INVALID);
 * \endcode
 * \b Example: Load URL in the currently open browser window. 
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_LOAD_URL_REQ, NULL, 
 *                         DBUS_TYPE_STRING, url, DBUS_TYPE_INVALID);
 * \endcode
 *
 */ 
#define OSSO_BROWSER_LOAD_URL_REQ    "load_url"


/* Window Plugging service */ 

/**
 * Open embedded browser window.\n
 * \b url: The URL to load in embedded browser window\n
 * \b cssfile: The style sheet (must be saved under opera_dir/styles)\n
 * \b jsenable: TRUE,  ECMAScript enabled for embedded browser window.
 *    FALSE otherwise.\n
 * \b in_new_window: TRUE, open links in new window.
 *    FALSE Open clicked/selected links are in the same window\n
 * \b Example: 
 * \code
 *  ret =osso_rpc_run_with_defaults(osso, "osso_browser",
 * 			OSSO_BROWSER_PLUG_NEW_WINDOW_REQ, NULL,
 *       		DBUS_TYPE_UINT32, window_id,
 * 	         	DBUS_TYPE_STRING, url,
 * 		        DBUS_TYPE_STRING, cssfile, 
 * 			DBUS_TYPE_BOOLEAN, jsenable, 
 * 		        DBUS_TYPE_BOOLEAN, in_new_window,
 * 	         	DBUS_TYPE_STRING, service_name,
 * 		        DBUS_TYPE_INVALID);
 *\endcode
 * \b Example:  The following example demonstrates how interface
 *              should be used with all parameters.
 * \code
 *  ret =osso_rpc_run_with_defaults(osso, "osso_browser",
 * 			OSSO_BROWSER_PLUG_NEW_WINDOW_REQ, NULL,
 *       		DBUS_TYPE_UINT32, window_id,
 * 	         	DBUS_TYPE_STRING, url,
 * 		        DBUS_TYPE_STRING, NULL, 
 * 			DBUS_TYPE_BOOLEAN, TRUE, 
 * 		        DBUS_TYPE_BOOLEAN, TRUE,
 * 	         	DBUS_TYPE_STRING, "com.nokia.osso_email",
 * 		        DBUS_TYPE_INVALID);
 * \endcode
 */ 
#define OSSO_BROWSER_PLUG_NEW_WINDOW_REQ    "plug_new_window"

/**
 * Load URL in embedded browser window.\n
 * \b url: The URL to load in embedded browser window\n
 * \b Example: 
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_LOAD_URL_PLUGGED_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_UINT32, window_id,
 *                         DBUS_TYPE_STRING, url, DBUS_TYPE_INVALID);
 * \endcode
 */ 
#define OSSO_BROWSER_LOAD_URL_PLUGGED_WINDOW_REQ    "load_url_plugged_window"

/**
 * Zoom request for embedded browser window.\n
 * \b zoomlevel: Selected zoom level
 * \b Example:
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_ZOOM_PLUGGED_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_UINT32, window_id,
 *                         DBUS_TYPE_UINT32, (gint)zoomlevel,DBUS_TYPE_INVALID);
 * \endcode
 * \b Note: zoomlevel is in percentage (80%, 120% etc) 
 */ 
#define OSSO_BROWSER_ZOOM_PLUGGED_WINDOW_REQ    "zoom_plugged_window"

/**
 * Key event for embedded browser window.\n
 * \b keycode: Key code
 * \b Example:
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_KEY_EVENT_PLUGGED_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_UINT32, window_id,
 *                         DBUS_TYPE_UINT32, (gint)keycode, DBUS_TYPE_INVALID);
 * \endcode
 * \b Note: Just arrows and enter HW key codes are supported.
 */ 
#define OSSO_BROWSER_KEY_EVENT_PLUGGED_WINDOW_REQ    "key_event_plugged_window"

/**
 * Stop the loading of URL in embedded browser window.\n
 * \b Example: Stop the loading of URL in embedded browser window  
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_STOPLOAD_PLUGGED_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_UINT32, window_id, DBUS_TYPE_INVALID);
 * \endcode
 */ 
#define OSSO_BROWSER_STOPLOAD_PLUGGED_WINDOW_REQ    "stop_load_plugged_window"

/**
 * Select all text of embedded browser window.\n
 * \b Example: Select all text of embedded browser window
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_SELECTALL_PLUGGED_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_UINT32, window_id, DBUS_TYPE_INVALID);
 * \endcode
 */ 
#define OSSO_BROWSER_SELECTALL_PLUGGED_WINDOW_REQ    "select_all_plugged_window"

/**
 * Can select text of embedded browser window.\n
 * \b Example:
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_CAN_SELECT_PLUGGED_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_UINT32, window_id, DBUS_TYPE_INVALID);
 * \endcode
 */ 
#define OSSO_BROWSER_CAN_SELECT_PLUGGED_WINDOW_REQ   "can_select_plugged_window"

/**
 * Find text in embedded browser window.\n
 * \b Example: Finding text in embedded browser window  
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_FIND_PLUGGED_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_UINT32, window_id, 
 *                         DBUS_TYPE_STRING, find_text,
 *                         DBUS_TYPE_BOOLEAN, from_start
 *                         DBUS_TYPE_INVALID);
 * \endcode
 * \b Note: If from_start is TRUE, search from the beginning of the window.
 *          If FALSE, continue search from previous match.
 */ 
#define OSSO_BROWSER_FIND_PLUGGED_WINDOW_REQ    "find_plugged_window"

/**
 * Copy text from embedded browser window to clipboard.\n
 * \b Example: Copy selected text from embedded browser window to clipboard 
 * \code
 * ret = osso_rpc_run_with_defaults(app_ctx, "osso_browser",
 *                         OSSO_BROWSER_COPYTEXT_PLUGGED_WINDOW_REQ, NULL, 
 *                         DBUS_TYPE_UINT32, window_id, 
 *                         DBUS_TYPE_INVALID);
 * \endcode
 */ 
#define OSSO_BROWSER_COPYTEXT_PLUGGED_WINDOW_REQ    "copy_plugged_window"

/**
 * Send the load finished message to external appalication 
 * when the load finiched callback is executed.
 */ 
#define OSSO_BROWSER_LOAD_URL_PLUGGED_WINDOW_REQ_FINISHED    "load_finished"

/**
 * Send this to try close browser if it not used.
 */ 
#define OSSO_BROWSER_PLUGGED_EXIT    "exit_plugged_browser"

/**
 * Send this to close browser.
 */ 
#define OSSO_BROWSER_EXIT    "exit_browser"

/* HW keys #define values */
#define EMBEDDED_WINDOW_ESC_SHORT_KEY_EVENT "Esc short"
#define EMBEDDED_WINDOW_ESC_LONG_KEY_EVENT "Esc long"
#define EMBEDDED_WINDOW_HOME_SHORT_KEY_EVENT "Home short"
#define EMBEDDED_WINDOW_HOME_LONG_KEY_EVENT "Home long"
#define EMBEDDED_WINDOW_OPTIMIZED_VIEW_KEY_EVENT "Otimized view"
#define EMBEDDED_WINDOW_ZOOM_IN_KEY_EVENT "Zoom in"
#define EMBEDDED_WINDOW_ZOOM_OUT_KEY_EVENT "Zoom out"
#define EMBEDDED_WINDOW_MENU_KEY_EVENT "Menu"

#endif /* __OSSO_BROWSER_INTERFACE_H__ */
