#!/bin/sh

if [ -z "$SUDO_COMMAND" ]; then
	sudo /etc/osso-backup/restore.d/always/bluez-restore.sh $@
	exit 0
fi

PATH="/sbin:/usr/sbin:/bin:/usr/bin"

if [ "$1" ]; then
	if [ -z "`grep /var/lib/bluetooth $1`" ]; then
		exit 0;
	fi
fi

MY_BDA=`hciconfig hci0|grep Address|awk '{ print $3 }'`

[ -z "$MY_BDA" ] && exit 1

CORRECT_DIR="/var/lib/bluetooth/$MY_BDA"

OLD_DIR=`ls -d /var/lib/bluetooth/*|grep -v $MY_BDA|head -n 1`

if [ "$OLD_DIR" ]; then
	rm -rf $CORRECT_DIR
	mv $OLD_DIR $CORRECT_DIR
fi

[ ! -f $CORRECT_DIR/config ] && exit 0

MODE=`egrep ^mode $CORRECT_DIR/config|awk '{ print $2 }'`

dbus-send --system --dest=org.bluez /org/bluez/hci0 org.bluez.Adapter.SetMode string:$MODE
