/**
 * @file libgalago/galago-key-value.c Galago Key/Value Data Structure
 *
 * @Copyright (C) 2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libgalago/galago-key-value.h>

GalagoKeyValue *
galago_key_value_new(const char *key, GValue *value)
{
	GalagoKeyValue *key_value;

	g_return_val_if_fail(key != NULL && *key != '\0', NULL);

	key_value = g_new0(GalagoKeyValue, 1);
	key_value->key = g_strdup(key);
	key_value->value = value;

	return key_value;
}

void
galago_key_value_destroy(GalagoKeyValue *key_value)
{
	g_return_if_fail(key_value != NULL);

	g_free(key_value->key);
	g_value_unset(key_value->value);
	g_free(key_value->value);
	g_free(key_value);
}

void
galago_key_value_set_key(GalagoKeyValue *key_value, const char *key)
{
	g_return_if_fail(key_value != NULL);
	g_return_if_fail(key != NULL && *key != '\0');

	if (key_value->key == key)
		return;

	if (key_value->key != NULL)
		g_free(key_value->key);

	key_value->key = g_strdup(key);
}

const char *
galago_key_value_get_key(const GalagoKeyValue *key_value)
{
	g_return_val_if_fail(key_value != NULL, NULL);

	return key_value->key;
}

void
galago_key_value_set_value(GalagoKeyValue *key_value, GValue *value)
{
	g_return_if_fail(key_value != NULL);

	if (key_value->value == value)
		return;

	if (key_value->value != NULL)
	{
		g_value_unset(key_value->value);
		g_free(key_value->value);
	}

	key_value->value = value;
}

const GValue *
galago_key_value_get_value(const GalagoKeyValue *key_value)
{
	g_return_val_if_fail(key_value != NULL, NULL);

	return key_value->value;
}
