/*
 * linux/arch/arm/mach-omap/dsp/proclist.h
 *
 * Linux task list handler
 *
 * Copyright (C) 2004,2005 Nokia Corporation
 *
 * Written by Toshihiro Kobayashi <toshihiro.kobayashi@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * 2004/11/22:  DSP Gateway version 3.3
 */

struct proc_list {
	struct list_head list_head;
	pid_t pid;
	struct file *file;
};

static __inline__ void proc_list_add(struct list_head *list,
				     struct task_struct *tsk,
				     struct file *file)
{
	struct proc_list *new;

	new = kmalloc(sizeof(struct proc_list), GFP_KERNEL);
	new->pid = tsk->pid;
	new->file = file;
	list_add_tail(&new->list_head, list);
}

static __inline__ void proc_list_del(struct list_head *list,
				     struct task_struct *tsk,
				     struct file *file)
{
	struct proc_list *pl;

	list_for_each_entry(pl, list, list_head) {
		if (pl->file == file) {
			list_del(&pl->list_head);
			kfree(pl);
			return;
		}
	}

	/* correspinding file struct isn't found in the list ???  */
	printk(KERN_ERR "proc_list_del(): proc_list is inconsistent!\n"
			"struct file (%p) not found\n", file);
	printk(KERN_ERR "listing proc_list...\n");
	list_for_each_entry(pl, list, list_head)
		printk(KERN_ERR "  pid:%d file:%p\n", pl->pid, pl->file);
}

static __inline__ void proc_list_flush(struct list_head *list)
{
	struct proc_list *pl;

	while (!list_empty(list)) {
		pl = list_entry(list->next, struct proc_list, list_head);
		list_del(&pl->list_head);
		kfree(pl);
	}
}
