/**
   @file: hildon-im-main.c

*/
/*
 * This file is part of hildon-input-method
 * 
 * Copyright (C) 2005-2007 Nokia Corporation. 
 *
 * Contact: Mohammad Anwari <Mohammad.Anwari@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#include <gtk/gtk.h>
#include <glib/gthread.h>
#include "hildon-im-ui.h"
#include "internal.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "osso-log.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <locale.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <signal.h>

GtkWidget *keyboard = NULL;

static void
handle_sigterm(gint t)
{
  gtk_main_quit();
}

static void
handle_sighup (gint t)
{
  reload_plugins (HILDON_IM_UI(keyboard));
}

int
main(int argc, char *argv[])
{
  struct sigaction sv;

  if (!g_thread_supported ()) g_thread_init (NULL);
  gtk_init(&argc, &argv);

  gconf_init(argc, argv, NULL);

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);

  keyboard = hildon_im_ui_new();

  gtk_window_set_accept_focus(GTK_WINDOW(keyboard), FALSE);

  g_signal_connect(keyboard, "destroy", gtk_main_quit, NULL);

  /* gtk_main_quit at SIGTERM */
  sigemptyset(&sv.sa_mask);
  sv.sa_flags = 0;
  sv.sa_handler = handle_sigterm;
  sigaction(SIGTERM, &sv, NULL);

  /* reload IM plugins at SIGHUP */
  sigemptyset(&sv.sa_mask);
  sv.sa_flags = 0;
  sv.sa_handler = handle_sighup;
  sigaction(SIGHUP, &sv, NULL);

  gtk_main();

  return 0;
}
