/*
 * This file is part of maemo-af-desktop
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Author:  Moises Martinez <moises.martinez@nokia.com>
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __TASKNAVIGATOR_ITEM_WRAPPER_H__
#define __TASKNAVIGATOR_ITEM_WRAPPER_H__

#include <libhildondesktop/tasknavigator-item.h>

G_BEGIN_DECLS

#define TASKNAVIGATOR_TYPE_ITEM_WRAPPER ( tasknavigator_item_wrapper_get_type() )
#define TASKNAVIGATOR_ITEM_WRAPPER(obj) (GTK_CHECK_CAST (obj, TASKNAVIGATOR_TYPE_ITEM_WRAPPER, TaskNavigatorItemWrapper))
#define TASKNAVIGATOR_ITEM_WRAPPER_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), TASKNAVIGATOR_TYPE_ITEM_WRAPPER, TaskNavigatorItemWrapperClass))
#define TASKNAVIGATOR_IS_ITEM_WRAPPER(obj) (GTK_CHECK_TYPE (obj, TASKNAVIGATOR_TYPE_ITEM_WRAPPER))
#define TASKNAVIGATOR_IS_ITEM_WRAPPER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TASKNAVIGATOR_TYPE_ITEM_WRAPPER))
#define TASKNAVIGATOR_ITEM_WRAPPER_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_CLASS ((inst), TASKNAVIGATOR_TYPE_ITEM_WRAPPER, TaskNavigatorItemWrapperClass))
#define TASKNAVIGATOR_ITEM_WRAPPER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TASKNAVIGATOR_TYPE_ITEM_WRAPPER, TaskNavigatorItemWrapperPrivate));


typedef struct _TaskNavigatorItemWrapper TaskNavigatorItemWrapper; 
typedef struct _TaskNavigatorItemWrapperClass TaskNavigatorItemWrapperClass;
typedef struct _TaskNavigatorItemWrapperAPI TaskNavigatorItemWrapperAPI;

/* Type definitions for the plugin API */
typedef void *(*PluginCreateFn)(void);
typedef void (*PluginDestroyFn)(void *data);
typedef GtkWidget *(*PluginGetButtonFn)(void *data);
typedef void (*PluginInitializeMenuFn)(void *data);

struct _TaskNavigatorItemWrapper
{
  TaskNavigatorItem parent;
};

struct _TaskNavigatorItemWrapperClass
{
  TaskNavigatorItemClass parent_class;

  GtkWidget *(*get_widget) (TaskNavigatorItemWrapper *item);

};

struct _TaskNavigatorItemWrapperAPI
{
    PluginCreateFn		create;
    PluginDestroyFn		destroy;
    PluginGetButtonFn		get_button;
    PluginInitializeMenuFn	initialize;
};

GType tasknavigator_item_wrapper_get_type (void);

TaskNavigatorItemWrapper *
tasknavigator_item_wrapper_new (const gchar *name, const gchar *library);

GtkWidget *tasknavigator_item_wrapper_get_widget (TaskNavigatorItemWrapper *item);

G_END_DECLS

#endif /* TASKNAVIGATOR_ITEM_WRAPPER_H */
