/*
 * This file is part of maemo-af-desktop
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Author:  Moises Martinez <moises.martinez@nokia.com>
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tasknavigator-item-wrapper.h"

#include <gtk/gtkbutton.h>

#include <dlfcn.h> 

/*
#include <libintl.h>
#include <locale.h>
*/

#define HN_SYMBOL_CREATE     "hildon_navigator_lib_create"
#define HN_SYMBOL_INITIALIZE "hildon_navigator_lib_initialize_menu"
#define HN_SYMBOL_DESTROY    "hildon_navigator_lib_destroy"
#define HN_SYMBOL_BUTTON     "hildon_navigator_lib_get_button_widget"

enum
{
  TN_ITEM_W_PROP_0,
  TN_ITEM_W_LIB_PROP
};

enum
{
  NAV_ITEM_SIGNAL_LOG_CREATE,
  NAV_ITEM_SIGNAL_LOG_INIT,
  NAV_ITEM_SIGNAL_LOG_BUTTON,
  NAV_ITEM_SIGNAL_LOG_DESTROY,
  NAV_ITEM_SIGNAL_LOG_LOAD,
  NAV_ITEM_SIGNAL_LOG_END,
  NAV_ITEM_SIGNAL_GET_WIDGET,
  NAV_ITEM_SIGNALS
};

/*static guint
navigator_signals [NAV_ITEM_SIGNALS];*/

typedef struct
{
  gchar                  *library;
  void                   *dlhandler;
  TaskNavigatorItemWrapperAPI *api;
  void		         *data;
  /* ... */
} TaskNavigatorItemWrapperPrivate;

static TaskNavigatorItemClass *parent_class = NULL;

/* static declarations */

static GObject *tasknavigator_item_wrapper_constructor (GType gtype, 
				    			guint n_params, 
				    			GObjectConstructParam *params);

static void tasknavigator_item_wrapper_finalize (GObject *object);

static void tasknavigator_item_wrapper_class_init (TaskNavigatorItemWrapperClass *item_class);

static void tasknavigator_item_wrapper_init (TaskNavigatorItemWrapper *item);

static void tasknavigator_item_wrapper_set_property (GObject *object,
                                                guint prop_id,
                                                const GValue *value,
                                                GParamSpec *pspec);

static void tasknavigator_item_wrapper_get_property (GObject *object,
                                                guint prop_id,
                                                GValue *value,
                                                GParamSpec *pspec);

/* end static declarations */

static void 
tasknavigator_item_wrapper_init (TaskNavigatorItemWrapper *item)
{
  TaskNavigatorItemWrapperPrivate  *priv;

  priv = TASKNAVIGATOR_ITEM_WRAPPER_GET_PRIVATE (item);

  priv->library   = NULL;
  priv->data      = NULL;
  priv->api       = NULL;
  priv->dlhandler = NULL;

}

static void 
tasknavigator_item_wrapper_finalize (GObject *object)
{
  TaskNavigatorItemWrapperPrivate *priv;

  g_return_if_fail (object);

  priv = TASKNAVIGATOR_ITEM_WRAPPER_GET_PRIVATE (object); 
    
  if (priv->api && priv->api->destroy )
    priv->api->destroy (priv->data);
/*
  g_signal_emit (object, 
	  	 navigator_signals[NAV_ITEM_SIGNAL_LOG_DESTROY], 
		 g_quark_from_string ("destroy"), "destroy");  
*/
  if (priv->dlhandler)
    dlclose (priv->dlhandler);

  g_free (priv->library);
  g_free (priv->api);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void 
tasknavigator_item_wrapper_set_property (GObject *object,
                                    guint prop_id,
                                    const GValue *value,
                                    GParamSpec *pspec)
{
  TaskNavigatorItemWrapperPrivate *priv;

  g_assert (object && TASKNAVIGATOR_IS_ITEM_WRAPPER (object));

  priv = 
    TASKNAVIGATOR_ITEM_WRAPPER_GET_PRIVATE (TASKNAVIGATOR_ITEM_WRAPPER (object));

  switch (prop_id)
  {
    case TN_ITEM_W_LIB_PROP:
      g_free (priv->library);
      priv->library = g_strdup (g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  } 
}

static void 
tasknavigator_item_wrapper_get_property (GObject *object,
                                    guint prop_id,
                                    GValue *value,
                                    GParamSpec *pspec)
{
  TaskNavigatorItemWrapperPrivate *priv;

  g_assert (object && TASKNAVIGATOR_IS_ITEM_WRAPPER (object));

  priv =
    TASKNAVIGATOR_ITEM_WRAPPER_GET_PRIVATE (TASKNAVIGATOR_ITEM_WRAPPER (object));

  switch (prop_id)
  {
    case TN_ITEM_W_LIB_PROP:
      g_value_set_string (value,priv->library);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;						
  }
}

static void 
tasknavigator_item_wrapper_class_init (TaskNavigatorItemWrapperClass *item_class)
{
  GObjectClass      *object_class = G_OBJECT_CLASS   (item_class);

  g_type_class_add_private(item_class, sizeof (TaskNavigatorItemWrapperPrivate));

  parent_class = g_type_class_peek_parent (item_class );

  object_class->constructor	  = tasknavigator_item_wrapper_constructor;
  object_class->finalize          = tasknavigator_item_wrapper_finalize;
  object_class->set_property      = tasknavigator_item_wrapper_set_property;
  object_class->get_property      = tasknavigator_item_wrapper_get_property;
  
  item_class->get_widget	  = tasknavigator_item_wrapper_get_widget;
/* 
  navigator_signals[NAV_ITEM_SIGNAL_LOG_CREATE] = 
	g_signal_new("hn_item_create",
		     G_OBJECT_CLASS_TYPE(object_class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_DETAILED,
		     0,NULL, NULL,
		     g_cclosure_marshal_VOID__STRING, 
		     G_TYPE_NONE, 1, G_TYPE_STRING);

  navigator_signals[NAV_ITEM_SIGNAL_LOG_INIT] = 
	g_signal_new("hn_item_init",
		     G_OBJECT_CLASS_TYPE(object_class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_DETAILED,
		     0,NULL, NULL,
		     g_cclosure_marshal_VOID__STRING, 
		     G_TYPE_NONE, 1, G_TYPE_STRING);

  navigator_signals[NAV_ITEM_SIGNAL_LOG_BUTTON] = 
	g_signal_new("hn_item_button",
		     G_OBJECT_CLASS_TYPE(object_class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_DETAILED,
		     0,NULL, NULL,
		     g_cclosure_marshal_VOID__STRING, 
		     G_TYPE_NONE, 1, G_TYPE_STRING);

  navigator_signals[NAV_ITEM_SIGNAL_LOG_DESTROY] = 
	g_signal_new("hn_item_destroy",
		     G_OBJECT_CLASS_TYPE(object_class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_DETAILED,
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__STRING, 
		     G_TYPE_NONE, 1, G_TYPE_STRING);

 
  navigator_signals[NAV_ITEM_SIGNAL_LOG_END] = 
	g_signal_new("hn_item_end",
		     G_OBJECT_CLASS_TYPE(object_class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_DETAILED,
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__STRING, 
		     G_TYPE_NONE, 1, G_TYPE_STRING); 
*/

  g_object_class_install_property (object_class,
                                   TN_ITEM_W_LIB_PROP,
                                   g_param_spec_string ("library",
                                                        "library",
	                                                "library to open",
	                                                NULL,
	                                                G_PARAM_CONSTRUCT_ONLY | G_PARAM_READWRITE)); 
}

static GObject *
tasknavigator_item_wrapper_constructor (GType gtype, 
		    			guint n_params, 
		    			GObjectConstructParam *params)
{
  GObject *self;
  TaskNavigatorItemWrapper *wrapper;
  TaskNavigatorItemWrapperPrivate *priv;
  GtkWidget *button;

  self    = G_OBJECT_CLASS (parent_class)->constructor (gtype, n_params, params);
  wrapper = TASKNAVIGATOR_ITEM_WRAPPER (self);
  priv    = TASKNAVIGATOR_ITEM_WRAPPER_GET_PRIVATE (wrapper);

  priv->dlhandler  = dlopen (priv->library, RTLD_NOW);

  if (!priv->dlhandler)
  {
    g_debug ("TNW: I can't open %s", priv->library);
    gtk_object_sink (GTK_OBJECT (self)); /* FIXME: This or unref? */
    return self; /* FIXME: NULL or self? */
  }

  priv->api = g_new0 (TaskNavigatorItemWrapperAPI,1);

  GTK_WIDGET_SET_FLAGS (GTK_WIDGET (self), GTK_NO_WINDOW);

  g_return_val_if_fail (priv,FALSE);
  g_return_val_if_fail (priv->dlhandler,FALSE);

  priv->api->create     = NULL;
  priv->api->destroy    = NULL;
  priv->api->get_button = NULL;
  priv->api->initialize = NULL;

  priv->api->create     = dlsym(priv->dlhandler,HN_SYMBOL_CREATE); 
  priv->api->initialize = dlsym(priv->dlhandler,HN_SYMBOL_INITIALIZE);
  priv->api->get_button = dlsym(priv->dlhandler,HN_SYMBOL_BUTTON);
  priv->api->destroy    = dlsym(priv->dlhandler,HN_SYMBOL_DESTROY);

  if (!priv->api->create     || 
      !priv->api->initialize || 
      !priv->api->get_button ||
      !priv->api->destroy)
  {
    g_debug ("TNW: I can't open %s", priv->library);
    gtk_object_sink (GTK_OBJECT (self)); /* FIXME: This or unref? */
    return self; /* FIXME: NULL or self? */
  }

  priv->data = priv->api->create();
/*
  g_signal_emit (G_OBJECT (item), 
	  	 navigator_signals[NAV_ITEM_SIGNAL_LOG_CREATE], 
		 g_quark_from_string (HN_LOG_KEY_CREATE),
		 HN_LOG_KEY_CREATE);
*/
  priv->api->initialize (priv->data);
/*
  g_signal_emit (G_OBJECT (item), 
	  	 navigator_signals[NAV_ITEM_SIGNAL_LOG_INIT], 
		 g_quark_from_string (HN_LOG_KEY_INIT),
		 HN_LOG_KEY_INIT); 
*/
  button = priv->api->get_button(priv->data);
/*
  g_signal_emit (G_OBJECT (item), 
	  	 navigator_signals[NAV_ITEM_SIGNAL_LOG_BUTTON], 
		 g_quark_from_string (HN_LOG_KEY_BUTTON),
		 HN_LOG_KEY_BUTTON);
*/
  if (button && GTK_IS_WIDGET (button))
  { 
    gtk_container_add (GTK_CONTAINER (self), button);
  }
  /* else????? */
/*
  g_signal_emit (G_OBJECT (item), 
	  	 navigator_signals[NAV_ITEM_SIGNAL_LOG_END], 
		 g_quark_from_string (HN_LOG_KEY_END),
		 HN_LOG_KEY_END);
*/

  return self;
}

GType tasknavigator_item_wrapper_get_type (void)
{
    static GType tnw_item_type = 0;

    if (!tnw_item_type)
    {
        static const GTypeInfo tnw_item_info =
        {
            sizeof (TaskNavigatorItemWrapperClass),
            NULL, /* base_init */
            NULL, /* base_finalize */
            (GClassInitFunc) tasknavigator_item_wrapper_class_init,
            NULL, /* class_finalize */
            NULL, /* class_data */
            sizeof (TaskNavigatorItemWrapper),
            0,    /* n_preallocs */
            (GInstanceInitFunc) tasknavigator_item_wrapper_init,
        };
        tnw_item_type = g_type_register_static (TASKNAVIGATOR_TYPE_ITEM,
                                            "TaskNavigatorItemWrapper",
                                            &tnw_item_info,
                                            0);
    }
    
    return tnw_item_type;
}

TaskNavigatorItemWrapper *
tasknavigator_item_wrapper_new (const gchar *name, const gchar *library)
{
   
  g_return_val_if_fail (name && library,NULL);

  return g_object_new (TASKNAVIGATOR_TYPE_ITEM_WRAPPER,
		       "name",name,
		       "library",library,
		       NULL);
}

GtkWidget *
tasknavigator_item_wrapper_get_widget (TaskNavigatorItemWrapper *item)
{
  g_return_val_if_fail (item, NULL);
  g_return_val_if_fail (TASKNAVIGATOR_IS_ITEM_WRAPPER (item),NULL);

  return GTK_BIN (item)->child;
}
