/*
 * This file is part of maemo-af-desktop
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Author:  Moises Martinez <moises.martinez@nokia.com>
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __LIBDESKTOP_H__
#define __LIBDESKTOP_H__

#include <libhildondesktop/desktop-panel-window.h>
#include <libhildondesktop/desktop-panel.h>
#include <libhildondesktop/desktop-multiscreen.h>
#include <libhildondesktop/hildon-desktop-item.h>
#include <libhildondesktop/hildon-desktop-panel-item.h>
#include <libhildondesktop/statusbar-item-wrapper.h> 
#include <libhildondesktop/statusbar-item.h>
#include <libhildondesktop/statusbar-item-socket.h>
#include <libhildondesktop/tasknavigator-item-wrapper.h>
#include <libhildondesktop/tasknavigator-item.h>
#include <libhildondesktop/libhildonmenu.h>
#include <libhildondesktop/hildon-thumb-menu-item.h>
#include <libhildondesktop/hildon-home-applet.h>
#include <libhildondesktop/hildon-home-area.h>

#define HD_DEFINE_PLUGIN(TN, t_n, T_P)

#define HD_DEFINE_TYPE(TN, t_n, T_P) HD_DEFINE_TYPE_MODULE_EXTENDED (TN, t_n, T_P, 0, {})

#define HD_DEFINE_TYPE_MODULE_EXTENDED(TypeName, type_name, TYPE_PARENT, flags, CODE) \
\
static GType    type_name##_type_id = 0; \
static void     type_name##_init              (TypeName        *self); \
static void     type_name##_class_init        (TypeName##Class *klass); \
static gpointer type_name##_parent_class = NULL; \
static void     type_name##_class_intern_init (gpointer klass) \
{ \
  type_name##_parent_class = g_type_class_peek_parent (klass); \
  type_name##_class_init ((TypeName##Class*) klass); \
} \
\
GType \
type_name##_get_type (GTypeModule *module) \
{ \
  if (G_UNLIKELY (type_name##_type_id == 0)) \
  { \
    static const GTypeInfo g_define_type_info = \
    { \
      sizeof (TypeName##Class), \
      (GBaseInitFunc) NULL, \
      (GBaseFinalizeFunc) NULL, \
      (GClassInitFunc) type_name##_class_intern_init, \
      (GClassFinalizeFunc) NULL, \
      NULL,   /* class_data */ \
      sizeof (TypeName), \
      0,      /* n_preallocs */ \
      (GInstanceInitFunc) type_name##_init, \
      NULL    /* value_table */ \
    }; \
      g_define_type_id = \
	g_type_module_register_type (module, TYPE_PARENT, g_intern_static_string (#TypeName), &g_define_type_info, (GTypeFlags) flags); \
      { CODE ; } \
  } \
  return g_define_type_id; \
}

#endif/*__LIBDESKTOP_H__*/

