/*
 * This file is part of maemo-af-desktop
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Author:  Moises Martinez <moises.martinez@nokia.com>
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __DESKTOP_PANEL_H__
#define __DESKTOP_PANEL_H__

#include <gtk/gtkbox.h>
/*#include "hn-wm.h"*/

G_BEGIN_DECLS

typedef struct _DesktopPanel DesktopPanel;
typedef struct _DesktopPanelClass DesktopPanelClass;

#define DESKTOP_TYPE_PANEL            (desktop_panel_get_type())
#define DESKTOP_PANEL(obj)            (GTK_CHECK_CAST (obj, DESKTOP_TYPE_PANEL, DesktopPanel))
#define DESKTOP_PANEL_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), DESKTOP_TYPE_PANEL, DesktopPanelClass))
#define DESKTOP_IS_PANEL(obj)         (GTK_CHECK_TYPE (obj, DESKTOP_TYPE_PANEL))
#define DESKTOP_IS_PANEL_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), DESKTOP_TYPE_PANEL))

struct _DesktopPanel
{
  GtkBox         parent;

  GtkOrientation orient;

  gint		 item_width;
  gint		 item_height;
};

struct _DesktopPanelClass
{
  GtkBoxClass parent_class;

  void (*add_button)                (DesktopPanel *panel, 
				     GtkWidget *widget);

  void (*set_orientation)           (DesktopPanel *panel, 
		    		     GtkOrientation orientation);

  GtkOrientation (*get_orientation) (DesktopPanel *panel);

  void (*flip_panel)                (DesktopPanel *panel);

  void (*panel_flipped)		    (DesktopPanel *panel);
};

GType           desktop_panel_get_type         (void);

void            desktop_panel_add_button       (DesktopPanel   *panel, 
                                                GtkWidget      *widget);

void            desktop_panel_set_orientation  (DesktopPanel   *panel, 
                                                GtkOrientation  orientation);

GtkOrientation  desktop_panel_get_orientation  (DesktopPanel *panel);

void            desktop_panel_flip_panel       (DesktopPanel *panel);

G_END_DECLS

#endif
