/*
 * This file is part of maemo-af-desktop
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Author:  Moises Martinez <moises.martinez@nokia.com>
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef DESKTOP_PANEL_WINDOW_H
#define DESKTOP_PANEL_WINDOW_H

#include <gtk/gtkwindow.h>

#include <libhildondesktop/desktop-multiscreen.h>
#include <libhildondesktop/hildon-desktop-window.h>
#include <libhildondesktop/desktop-panel.h>

G_BEGIN_DECLS

typedef struct _DesktopPanelWindow DesktopPanelWindow;
typedef struct _DesktopPanelWindowClass DesktopPanelWindowClass;
typedef struct _DesktopPanelWindowPrivate DesktopPanelWindowPrivate;

#define DESKTOP_TYPE_PANEL_WINDOW            (desktop_panel_window_get_type())
#define DESKTOP_PANEL_WINDOW(obj)            (GTK_CHECK_CAST (obj, DESKTOP_TYPE_PANEL_WINDOW, DesktopPanelWindow))
#define DESKTOP_PANEL_WINDOW_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), DESKTOP_TYPE_PANEL_WINDOW, DesktopPanelWindowClass))
#define DESKTOP_IS_PANEL_WINDOW(obj)         (GTK_CHECK_TYPE (obj, DESKTOP_TYPE_PANEL_WINDOW))
#define DESKTOP_IS_PANEL_WINDOW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), DESKTOP_TYPE_PANEL_WINDOW))

typedef enum
{
  DPANEL_ORIENTATION_TOP    = 1 << 0,
  DPANEL_ORIENTATION_LEFT   = 1 << 1,
  DPANEL_ORIENTATION_RIGHT  = 1 << 2,
  DPANEL_ORIENTATION_BOTTOM = 1 << 3
} DPanelWinOrientation;

typedef enum
{
  DESKTOP_PANEL_GRAB_NONE = 0,
  DESKTOP_PANEL_GRAB_MOVE
} DPanelWinOpStates;

#define DPANEL_ORIENTATION_HORIZONTAL \
	(DPANEL_ORIENTATION_TOP | DPANEL_ORIENTATION_BOTTOM)

#define DPANEL_ORIENTATION_VERTICAL \
	(DPANEL_ORIENTATION_LEFT | DPANEL_ORIENTATION_RIGHT)

struct _DesktopPanelWindow
{
    HildonDesktopWindow	        parent;

    GtkWidget		       *panel;

    DesktopPanelWindowPrivate  *priv;
};

struct _DesktopPanelWindowClass
{
    HildonDesktopWindowClass parent_class;

    void (*set_sensitive) (DesktopPanelWindow *window,
			   gboolean sensitive);
    
    void (*set_focus)     (DesktopPanelWindow *window,
			   gboolean focus);
};

GType                desktop_panel_window_get_type       (void);

DesktopPanelWindow*  desktop_panel_window_new            (void);

void                 set_multiscreen_handler             (DesktopPanelWindow *window, 
							  DesktopMultiscreen *ms);

void                 desktop_panel_window_set_sensitive  (DesktopPanelWindow *window, 
							  gboolean            sensitive);

void                 desktop_panel_window_set_focus      (DesktopPanelWindow *window, 
							  gboolean            focus);

G_END_DECLS

#endif
