/*
 * This file is part of maemo-af-desktop
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Author:  Moises Martinez <moises.martinez@nokia.com>
 * Contact: Karoliina Salminen <karoliina.t.salminen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __DESKTOP_MULTISCREEN_H__
#define __DESKTOP_MULTISCREEN_H__

#include <glib-object.h>
#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

typedef struct _DesktopMultiscreen DesktopMultiscreen; 
typedef struct _DesktopMultiscreenClass DesktopMultiscreenClass;

#define DESKTOP_TYPE_MULTISCREEN            (desktop_ms_get_type())
#define DESKTOP_MULTISCREEN(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, DESKTOP_TYPE_MULTISCREEN, DesktopMultiscreen))
#define DESKTOP_MULTISCREEN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_TYPE_MULTISCREEN, DesktopMultiscreenClass))
#define DESKTOP_IS_MULTISCREEN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, DESKTOP_TYPE_MULTISCREEN))
#define DESKTOP_IS_MULTISCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_TYPE_MULTISCREEN))

struct _DesktopMultiscreen
{
  GObject parent;

  gint screens;
  gint *monitors;	     /*NOTE: monitors[screen] */
  GdkRectangle **geometries; /*NOTE: geometries[screen][monitor]; */
  gboolean initialized;
};

struct _DesktopMultiscreenClass
{
  GObjectClass parent_class;

  gint (*get_screens)           (DesktopMultiscreen *ms);
  gint (*get_monitors)          (DesktopMultiscreen *ms, 
				 GdkScreen *screen);

  gint (*get_x)                 (DesktopMultiscreen *ms,
				 GdkScreen *screen,
				 gint monitor);

  gint (*get_y)                 (DesktopMultiscreen *ms,
				 GdkScreen *screen,
				 gint monitor);

  gint (*get_width)             (DesktopMultiscreen *ms,
				 GdkScreen *screen,
				 gint monitor);

  gint (*get_height)            (DesktopMultiscreen *ms,
				 GdkScreen *screen,
				 gint monitor);

  gint (*locate_widget_monitor) (DesktopMultiscreen *ms,
				 GtkWidget *widget);

  void (*is_at_visible_extreme) (DesktopMultiscreen *ms,
				 GdkScreen *screen,
				 gint monitor,
                                 gboolean  *leftmost,
                                 gboolean  *rightmost,
                                 gboolean  *topmost,
                                 gboolean  *bottommost);
  
};

GType    desktop_ms_get_type               (void);

void     desktop_ms_reinit                 (DesktopMultiscreen *ms);

gint     desktop_ms_get_screens            (DesktopMultiscreen *ms);

gint     desktop_ms_get_monitors           (DesktopMultiscreen *ms,
            		 	            GdkScreen          *screen);

gint     desktop_ms_get_x                  (DesktopMultiscreen *ms,
            			            GdkScreen          *screen,
            			            gint monitor);

gint     desktop_ms_get_y                  (DesktopMultiscreen *ms,
            			            GdkScreen          *screen,
            			            gint                monitor);

gint     desktop_ms_get_width              (DesktopMultiscreen *ms,
            			            GdkScreen          *screen,
            			            gint                monitor);

gint     desktop_ms_get_height             (DesktopMultiscreen *ms,
            			            GdkScreen          *screen,
            			            gint                monitor);

gint     desktop_ms_locate_widget_monitor  (DesktopMultiscreen *ms,
            			            GtkWidget          *widget);

void     desktop_ms_is_at_visible_extreme  (DesktopMultiscreen *ms,
            			            GdkScreen          *screen,
                                            gint                monitor,
                                            gboolean           *leftmost,
                                            gboolean           *rightmost,
                                            gboolean           *topmost,
                                            gboolean           *bottommost);

gchar** desktop_ms_make_environment_for_screen (DesktopMultiscreen *ms,
						GdkScreen          *screen,
						gchar              **envp);

G_END_DECLS

#endif 
