/*
 * This file is part of lessertunjo
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Contact: Kuisma Salonen <kuisma.salonen@nokia.com>
 * Author: Kuisma Salonen <kuisma.salonen@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


/**
 * @file sapp_ssetcb.c
 * shadow application library, game side library,
 * callback settinng part
 * <p>
 *
 * @author Kuisma Salonen <Kuisma.Salonen@nokia.com>
 */

/**********************************************************/

#include <sys/un.h>
#include <stdio.h>

#include "shadowapp.h"

int sapp_set_msg_cb_exit(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_exit = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_quit(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_quit = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_top(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_top = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_continue(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_continue = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_restart(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_restart = cb_func;

  return SAPP_ERROR_NONE;
}

int sapp_set_msg_cb_flush(sapp_data *context, int (*cb_func)(int))
{
  if(context == NULL)
    return SAPP_ERROR_INVALIDPARAMS;
  context->msg_cb_flush = cb_func;

  return SAPP_ERROR_NONE;
}
