/* Copyright (C) <2006> Nokia Corporation.
 *
 * Contact: Zeeshan Ali <zeenix@gstreamer.net>
 *
 * gstrtpjitterbuffer.h: Implementation of codec-independent playout buffer
 *                       Much of the code has been moved from basertpdepay
 *                       in the gstreamer cvs.
 *
 * Copyright (C) <2005> Philippe Khalaf <burger@speedy.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_RTP_JITTER_BUFFER_H__
#define __GST_RTP_JITTER_BUFFER_H__

#include <gst/gst.h>
#include <gst/rtp/gstrtpbuffer.h>
#include "gstrtpclock.h"

G_BEGIN_DECLS
/* #define's don't like whitespacey bits */
#define GST_TYPE_RTP_JITTER_BUFFER (gst_rtp_jitter_buffer_get_type())
#define GST_RTP_JITTER_BUFFER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_RTP_JITTER_BUFFER,GstRTPJitterBuffer))
#define GST_RTP_JITTER_BUFFER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_RTP_JITTER_BUFFER,GstRTPJitterBuffer))
#define GST_RTP_JITTER_BUFFER_GET_CLASS(obj) \
        (G_TYPE_INSTANCE_GET_CLASS ((obj),GST_TYPE_RTP_JITTER_BUFFER,GstRTPJitterBufferClass))
#define GST_IS_RTP_JITTER_BUFFER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_RTP_JITTER_BUFFER))
#define GST_IS_RTP_JITTER_BUFFER_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_RTP_JITTER_BUFFER))
#define GST_RTP_JITTER_BUFFER_SINKPAD(depayload) (GST_RTP_JITTER_BUFFER (depayload)->sinkpad)
#define GST_RTP_JITTER_BUFFER_SRCPAD(depayload)  (GST_RTP_JITTER_BUFFER (depayload)->srcpad)
/* in milliseconds */
#define RTP_QUEUE_DELAY 100;
#define QUEUE_LOCK_INIT(base)   (base->queuelock = g_mutex_new ())
#define QUEUE_LOCK_FREE(base)   (g_mutex_free (base->queuelock))
#define QUEUE_LOCK(base)        (g_mutex_lock (base->queuelock))
#define QUEUE_UNLOCK(base)      (g_mutex_unlock (base->queuelock))
typedef struct _GstRTPJitterBuffer GstRTPJitterBuffer;
typedef struct _GstRTPJitterBufferClass GstRTPJitterBufferClass;

struct _GstRTPJitterBuffer
{
  GstElement parent;

  GstPad *sinkpad, *srcpad;

  gboolean thread_running;
  /* the releaser thread */
  GThread *thread;

  guint32 min_ts;     /**< oldest timestamp in jbuffer */

  guint clock_rate;
  guint queue_delay;

  /* we will queue up to RTP_QUEUEDELAY ms of packets,
   * reordering them if necessary
   * dropping any packets that are more than
   * RTP_QUEUEDELAY ms late 
   */
  GQueue *queue;

  /* lock to protect the queue, and cond(ition) for availability of data */
  GMutex *queuelock;
  GCond *availability;

  GstClockTime first_time_received;
  GstClockTime sleep_time;

  /* This is needed for the calculation of sleep_time the 
   * value of which is a running average */
  guint64 num_packets;

  GstClock *system_clock;
  GstClock *rtp_clock;

  GstSegment segment;
  gboolean need_newsegment;

  GstActivateMode mode;
  guint64 offset;

  /*< private > */
  gpointer _gst_reserved[GST_PADDING];
};

struct _GstRTPJitterBufferClass
{
  GstElementClass parent_class;

  /*< private > */
  gpointer _gst_reserved[GST_PADDING];
};

GType gst_rtp_jitter_buffer_get_type (void);

G_END_DECLS
#endif /* __GST_RTP_JITTER_BUFFER_H__ */
