/* Copyright (C) 1996, 1997, 1998, 1999, 2002, 2005
   Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Pat Beirne <patb@corelcomputer.com>

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* clone() is even more special than fork() as it mucks with stacks
   and invokes a function in the right context after its all over.  */

#include <sysdep.h>
#define _ERRNO_H	1
#include <bits/errno.h>

#define CLONE_VM      0x00000100
#define CLONE_THREAD  0x00010000

/* int clone(int (*fn)(void *arg), void *child_stack, int flags, void *arg,
	     pid_t *ptid, struct user_desc *tls, pid_t *ctid); */

        .text
ENTRY(__clone)
	@ sanity check args
	cmp	r0, #0
	cmpne	r1, #0
	moveq	r0, #-EINVAL
	beq	PLTJMP(syscall_error)

	@ insert the args onto the new stack
	str	r3, [r1, #-4]!
	str	r0, [r1, #-4]!

	@ do the system call
	@ get flags
	mov	r0, r2
#ifdef RESET_PID
	mov	ip, r2
#endif
	@ new sp is already in r1
	str	r4, [sp, #-4]!
	ldr	r2, [sp, #4]
	ldr	r3, [sp, #8]
	ldr	r4, [sp, #12]
	swi	SYS_ify(clone)
	cmp	r0, #0
	beq	1f
	ldr	r4, [sp], #4
	blt	PLTJMP(C_SYMBOL_NAME(__syscall_error))
	RETINSTR(ne, lr)

1:
#ifdef RESET_PID
	tst	ip, #CLONE_THREAD
	bne	3f
	mov	r0, #0xffff0fff
	mov	lr, pc
	sub	pc, r0, #31
	mov	r1, r0
	tst	ip, #CLONE_VM
	movne	r0, #-1
	swieq	SYS_ify(getpid)
	str	r0, [r1, #PID_OFFSET]
	str	r0, [r1, #TID_OFFSET]
3:
#endif
	@ pick the function arg and call address off the stack and execute
	ldr	r0, [sp, #4]
	mov	lr, pc
	ldr 	pc, [sp], #8

	@ and we are done, passing the return value through r0
	b	PLTJMP(_exit)

PSEUDO_END (__clone)

weak_alias (__clone, clone)
