/* xaw-message.c: Pop up an Xaw message window.
   Written by stefanulrich@users.sourceforge.net. Public Domain.
   
   Compile with:
   gcc -o texdoctk-warn -O2 -W -Wall -ansi -pedantic -L/usr/X11R6/lib -lXaw -lXt -lX11 texdoctk-warn.c
*/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Paned.h>

static void
quit_callback(Widget w, XtPointer client_data, XtPointer call_data)
{
    (void)w;
    (void)client_data;
    (void)call_data;

    exit(0);
}

static char *
normalize_newline(char *str)
{
    int i, k;
    for (i = 0, k = 0; str[i] != '\0'; i++, k++) {
	if (str[i] == '\\' && str[i + 1] == 'n') {
	    /* escaped `\n': change `\\n' to `\n' */
	    if (i > 1 && str[i - 1] == '\\') {
		str[k] = str[i + 1];
	    }
	    else {
		str[k] = '\n';
	    }
	    i++;
	}
	else {
	    str[k] = str[i];
	}
    }
    str[k] = '\0';
    return str;
}

int main(int argc, char *argv[])
{
    XtAppContext app_context;
    Widget toplevel, paned, text, box, button;
    int offset = 6;
    XtAccelerators accels;
    char *msg = NULL;

    if (argc < 2) {
	fprintf(stderr, "Usage: %s message\n", argv[0]);
	exit(1);
    }
    if ((msg = malloc(strlen(argv[1]) + 1)) == NULL) {
	fprintf(stderr, "Couldn't allocate space for `%s'!\n", argv[1]);
	exit(1);
    }

    strcpy(msg, argv[1]);

    /* replace "\n" in msg (2 chars) by `\n' (one char) */
    msg = normalize_newline(msg);

    toplevel = XtAppInitialize(&app_context, "Info",
			       NULL, 0,
			       &argc, argv,
			       NULL, NULL, 0);

    accels = XtParseAcceleratorTable("#override\n"
				     "<Key>Return: set()notify()unset()\n"
				     "<Key>q: set()notify()unset()\n"
				     "<Key>Escape: set()notify()unset()");

    paned = XtVaCreateManagedWidget("paned", panedWidgetClass, toplevel,
				    XtNinternalBorderWidth, 0, /* no separator line */
				    NULL);
    text = XtVaCreateManagedWidget("text", labelWidgetClass, paned,
				   XtNlabel, msg,
				   XtNinternalWidth, offset,
				   XtNinternalHeight, offset,
				   NULL);
    box = XtVaCreateManagedWidget("box", formWidgetClass, paned,
				  XtNshowGrip, False,
  				  XtNdefaultDistance, offset,
				  XtNskipAdjust, True,
				  NULL);
    button = XtVaCreateManagedWidget("OK",
				     commandWidgetClass, box,
				     /* easiest to flush button left ... */
				     XtNleft, XtChainLeft,
				     XtNright, XtChainLeft,
				     XtNaccelerators, accels,
				     NULL);

    XtAddCallback(button, XtNcallback, quit_callback, (XtPointer)NULL);

    /* redirect all input to button */
    XtInstallAllAccelerators(paned, paned);
    XtInstallAllAccelerators(button, paned);

    XtRealizeWidget(toplevel);

    XtAppMainLoop(app_context);
    return 0;
}
