/**
    @file appdata.h

    Application specific data needed all around the application.

    Copyright (c) 2004-2006 Nokia Corporation. All rights reserved.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifndef _APPDATA_H
#define _APPDATA_H

/*Hildon */
#include <hildon/hildon-program.h>
#include <hildon/hildon-window.h>
#include <hildon/hildon-find-toolbar.h>
#include <hildon/hildon-file-system-model.h>

 /*OSSO*/
#include <libosso.h>
#include <hildon-uri.h>
     /*GTK*/
#include <gtk/gtk.h>
    /*GConf */
#include <gconf/gconf-client.h>
#include "feed_types.h"
#include "common.h"
#include "cache.h"

#define HILDON_COMMON_STRINGS_L10N_PACKAGE "hildon-common-strings"
#define HILDON_FM_L10N_PACKAGE "hildon-fm"
#define HILDON_LIBS_L10N_PACKAGE "hildon-libs"
#define RSS_NEWS_READER_HELP_ADD_FEED "Applications_RssReader_addafeeddialog"
#define RSS_NEWS_READER_HELP_REFRESH "Applications_RssReader_refreshdialog"
#define RSS_NEWS_READER_HELP_MANAGE "Applications_RssReader_managefoldersdialog"
#define RSS_NEWS_READER_HELP_DETAILS "Applications_RssReader_feeddetailsdialog"
#define RSS_NEWS_READER_HELP_SETTINGS "Applications_RssReader_settingsdialog"
#define RSS_NEWS_READER_HELP_DIRECTORY "Applications_RssReader_feeddirectorydialog"
#define RSS_NEWS_READER_HELP_SORT "applications_RssReader_sortdialog"
#define RSS_NEWS_READER_HELP_SAVE "applications_RssReader_saveobjectdialog"
#define RSS_NEWS_READER_HELP_OPEN "applications_RssReader_selectobjectdialog"
#define RSS_NEWS_READER_HELP_CHFOLDER "Applications_RssReader_changefolderdialog"
#define RSS_NEWS_READER_HELP_NEWFOLDER "Applications_RssReader_newfolderdialog"
#define RSS_NEWS_READER_HELP_RENAMEFOLDER "Applications_RssReader_renamefolderdialog"
    /*tvh: TODO: */
    //#define RSS_NEWS_READER_HELP_IMPORT_OPML_FILE "Applications_RssReader_importopmlfiledialog"
#define RSS_NEWS_READER_HELP_IMPORT_OPML_FILE "Applications_RssReader_importOPMLdialog"
#define OSSO_IAP_NO_ACTION 1
#define OSSO_IAP_POPUP_REFRESH_DIALOG 2 /* used to be OSSO_IAP_NORMAL */
#define OSSO_IAP_REFRESH_FEED_DIRECTORY 3
#define OSSO_IAP_REFRESH_NO_DIALOG 4
#define OSSO_IAP_REFRESH_ALL_NO_DIALOG 5
#define OSSO_IAP_REFRESH_FEED 6
#define OSSO_IAP_NEW_SUBSCRIPTION 7
#define OSSO_IAP_LAUNCH_WEB_BROWSER 8
#define OSSO_IAP_DOWNLOAD_IMAGES_FOR_DISPLAY 9
#define OSSO_IAP_REFRESH_LIST 10
#define CONTEXT_MENU_ITEM_HEIGHT 70
    enum {
    SFM_NORMAL,
    SFM_INTERRUPTED,
    SFM_SEARCH,
    SFM_REFRESH,
    SFM_DOWNLOAD_IMAGES,        /*tvh: added this */
    SFM_CONNECTING
};

typedef enum {
    PROGRESSBAR_NORMAL_MODE,
    PROGRESSBAR_SEARCH_MODE,
    PROGRESSBAR_CONNECT_MODE,
    PROGRESSBAR_REFRESH_MODE,
    PROGRESSBAR_IMAGE_MODE,
    PROGRESSBAR_RECEIVING_MODE
} progress_bar_mode;

/*
 * Application UI data
 */
typedef struct _AppUIData AppUIData;
struct _AppUIData {
    /* Used to control whether or not the statistics should be shown */
    gboolean manage_folders_displayed;
    gboolean feed_displayed;
    gboolean start_on_background;
    gboolean start_alarmdel_on_background;
    gboolean errors_in_refreshing;
    gboolean feed_directory_cancelled;
    guint feed_directory_count;
    gboolean auto_refresh_is_ongoing;
    //    gboolean network_disconnected;
    gchar *network_iap;
    int iap_disconnect;
    gboolean connected;
    gboolean application_topped;
    gboolean display_off;	
    gboolean download_cancelled;
    gboolean update_feed_list_needed;
    gboolean call_ui_mainwindow_finish_needed;
    gboolean update_progress_needed;	

    gboolean fullscreen;

    /* LOW MEMORY state */
    gboolean low_mem;

    /* When a first level dialog is closed by pressing esc, the key-release-event must not be handled,
     * otherwise the application will return to normal state if being in full screen state while the
     * dialog was open. This is where this flag is needed */
    gboolean dialog_closed;

    /* When the toolbar is hidden it should be temporarily opened when user
     * starts text input with the hardware keyboard. This flag indicates
     * that the toolbar were already shown.*/
    gboolean toolbar_temp_shown;

    /* Automatic updates */
    guint automatic_update_source;

    /* Source for handling download results */
    guint download_dequeue_source;

    /* Find on page */
    gchar *find_string;

    /* IAP related stuff */
    int iap_action;
    feedPtr new_subscription;
    gint new_subscription_flags;
    gchar *source;
    const gchar *filter;

    int vertical_scroll_window_position;

    /* File chooser model */
    HildonFileSystemModel *model;

    /* Drag and drop */
    nodePtr draggednode;

    /* Feed directory */
    gboolean feed_directory_loading;

    /* Scrolled window of feedlist */
    GtkWidget *scrolledwindow;
    gdouble scrollbarposition;

    /* View items */
    HildonProgram *app;
    HildonWindow *main_view;

    GtkMenu *main_menu_bar;
    GtkWidget *html_scrollpane;
    GtkWidget *rss_news;
    GtkWidget *search_label;
    guint rss_search_found;     /* Number of search items found */
    GtkWidget *dialog;
    GtkWidget *mfdialog;
    GtkWidget *nfdialog;
    GtkWidget *cfdialog;
    GtkWidget *fsdialog;
    GtkWidget *propdialog;
    GtkWidget *feed_directory_dialog;
    GtkWidget *refresh_dialog;
    GtkWidget *sort_dialog;	
    GtkWidget *clear_cache_dialog;	

    /* Add feed dialog */
    GtkWidget *add_feed_dialog;
    /*tvh:12.Jan.06 */

    struct fp_prop_ui_data *ui_data;
    GtkWidget *newfeedbtn;
    GtkWidget *changefolderbtn;
    GtkWidget *browsebtn;
    GtkWidget *cancelbtn;

    /* Progress / Search field */
    GtkWidget *var_field;
    GtkWidget *search_field;
    GtkWidget *progress_bar;
    int search_string_count;
    int search_mode;
    gboolean nospace;
    progress_bar_mode progressbar_mode;

    /* Number of requests pending in all three queues */
    guint pending_requests_nr;
    /* Number of requests downloaded but not yet processed,
     * and pending in the results Async Queue */
    guint downloaded_requests_nr;

    /*gtkhtml specific for loading images */
    gboolean downloading_images;
    GtkWidget *htmlwidget;      /* TODO: needed? */
    GSList *img_req_list;
    //struct request * img_req;
    /* Toolbar */
    GtkWidget *main_toolbar;
    GtkToolButton *refresh_button;
    GtkToolButton *search_button;
    GtkToolButton *unsubscribe_button;
    GtkToolButton *feed_properties_button;
    GtkToolButton *new_feed_button;
    GtkToolButton *manage_folders_button;
    GtkWidget *button_image_stop;
    GtkWidget *button_image_search;
    GtkWidget *button_image_refresh;
    GtkWidget *dlg_btn_unsubscribe;
    GtkToggleToolButton *folders_list_toggle_button;

    /* Find toolbar */
    HildonFindToolbar *find_toolbar;

    /* Access to menu items */
    GtkWidget *menuitem_feed_directory;
    GtkWidget *menuitem_manage_folders;

    /* context menu */
    GtkMenu *context_menu;
    GtkMenuItem *context_sp;
//    GtkMenuItem *context_menuitem_open;
    GtkMenuItem *context_menuitem_refresh;
    GtkMenuItem *context_menuitem_new_folder;
    GtkMenuItem *context_menuitem_sort;
//    GtkMenuItem *context_menuitem_edit_details;
    GtkMenuItem *context_menuitem_rename;
//    GtkMenuItem *context_menuitem_unsubscribe;
    GtkMenuItem *context_menuitem_delete;
    GtkMenuItem *context_menuitem_copy_link;
#ifdef DEL_SEND_VIA
    GtkMenuItem *context_menuitem_send;
    GtkMenuItem *context_menuitem_send_post;
    GtkMenuItem *context_menuitem_send_bt;
#endif
    GtkMenuItem *context_menuitem_load_image;
    GtkMenuItem *context_menuitem_save_image;
    GSList *actions;

    /* url shared for context menu */
    gchar *context_url;
    gchar *image_url;
    gpointer image_object;
    gchar *load_url;
    gchar *bt_file;
    /* last selected node from the feedlist */
    nodePtr feedlist_lastnode;

    double zoom_level;

    /* image cache */
    FileCache *img_cache;

    /* Interaction with applet 
     * Scroll to this item after load is successful */
    nodePtr scroll_to_feed;
    guint32 scroll_to_item;

    GtkWidget *unsubscribe_dialog;

    /* source of the progress bar idle update */
    guint32 pidle;

    guint cursor_changed_on_idle;

    GSList *list_for_update;
    gboolean connect_at_the_end;
    gint flags_for_list;
    gboolean toolbar_keypress_handler_blocked;
};

typedef struct _AppData AppData;
struct _AppData {
    AppUIData *app_ui_data;
    osso_context_t *osso;
    GConfClient *gconf_client;
};

#endif
