/**
    @file applet.h

    Copyright (c) 2004-2005 Nokia. All rights reserved.
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/


#ifndef _APPLET_H
#define _APPLET_H

#include <time.h>
#include <gtk/gtk.h>
#include <glib.h>

/* GConf */
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

/* D-BUS */
#include <dbus/dbus-glib-lowlevel.h>

#include <libosso.h>

#include <hildon/hildon-defines.h>

#include <libhildondesktop/libhildondesktop.h>


#define BUTTON_WIDTH 80
#define BUTTON_HEIGHT (60-HILDON_MARGIN_DOUBLE/2)
#ifdef UISPEC_CHANGES
#define RSS_APPLET_WIDTH 300
#define RSS_APPLET_HEIGHT 300
#endif 
#define RSS_APPLET_WIDTH 316
#define RSS_APPLET_HEIGHT 372
#define RSS_APPLET_MIN_WIDTH 300
#define RSS_APPLET_MIN_HEIGHT 160
#define RSS_APPLET_SCROLLED_WINDOW_HEIGHT (RSS_APPLET_HEIGHT - BUTTON_HEIGHT - 2.5*HILDON_MARGIN_DOUBLE)
#define MAX_HEADLINES 20
#define SCROLLBAR_WIDTH 6
#define FAVICON_WIDTH 32
#define HEADLINE_HEIGHT 72
#define ICON_SIZE 48
#define HEADLINE_MIN_WIDTH (RSS_APPLET_WIDTH - FAVICON_WIDTH - SCROLLBAR_WIDTH - 2*HILDON_MARGIN_DOUBLE-2*HILDON_MARGIN_DEFAULT)
#define TOOLBAR_ICON_SPACING (RSS_APPLET_WIDTH-(ICON_SIZE*3))/4

#define ANIMATION_TO_DOWN 2
#define ANIMATION_TO_DOWN_TIMEOUT 70
#define ANIMATION_TO_DOWN_WAIT 3000
#define ANIMATION_TO_DOWN_WAIT_ON_END 5000
#define ANIMATION_TO_DOWN_WAIT_ON_USER_ACTION 6000

#define LONG_BUTTON_PRESS_TIMEOUT_INTERVAL 500
#define CONT_SCROLL_TIMEOUT_INTERVAL 200

#define APPLET_DBUS_SIGNAL_LISTENER_FMT "type='signal',sender='%s'," \
    "interface='%s'"

#define RSS_ICON_ITEM "general_rss"

#define MIN_INTERVAL 1

gint _setup_alarmd(gpointer data);

/**
 Set hardware event handler

 @param state Signals that are of interest
 @param cb Callback function.
 @param data Application specific data.
 */

gboolean set_hw_event_handler(osso_hw_state_t * state,
                              osso_hw_cb_f * cb, gpointer data);


typedef struct {
    GdkWindow *parent_window;
    void *state_data;
    gboolean startrss;
    int state_size;
    /* Global counters */
    time_t updated;
    gulong unread;
    /* UI widgets */
    GtkWidget *applet_frame;
    GtkWidget *news;
    GtkWidget *rss_news;        /* TreeView */
    GtkWidget *scrollbar;       /* Scrollbar to display position in headline
                                   list */
    GtkWidget *scrolledwindow;  /* The TreeView's scrolled window */
    GtkWidget *button_hbox;
    GtkWidget *rss_refresh_button;
    GtkWidget *up_button;
    GtkWidget *down_button;
    GtkWidget *rss_image;       /* The refresh image */
    GtkWidget *rss_image_stop;  /* The stop image */
    GtkWidget *up_image;
    GtkWidget *down_image;
    GtkWidget *rss_unread;
    GtkWidget *empty_label;
    GtkWidget *news_hbox;
    GtkWidget *applet_vbox;
    GtkWidget *refresh_banner;
    GtkCellRendererText *textRenderer;
    GtkTreeViewColumn *textColumn;
    GtkTreeViewColumn *iconColumn;
    GtkTreeStore *headlines;


    guint scroll_down_tw_timeout;
    guint scroll_down_tw_starter_timeout;

    /* Timeouts for contionous scrolling when pressing the up/down buttons for
     * long; continous starts after long_buttonpress_timeout expires, and one
     * headline is scrolled after every cont_scroll_timeout */
    guint long_buttonpress_timeout;
    guint cont_scroll_timeout;

    /* Update tracking */
    gboolean online;
    guint timeout;
    /* GConf */
    gboolean update;
    guint interval;
    gboolean animation;
    guint open_feeds_to;
    GConfClient *client;
    int width;
    DBusConnection *connection;
    gboolean refreshing;
    gboolean refresh_banner_displayed;
    osso_context_t *osso;
    gboolean backgrounded;
    gchar *title_backup;
    gchar *title_backup2;
    guint gconf_notify_automatic_updates;
    guint gconf_notify_updates_interval;
    guint gconf_notify_automatic_scrolling;
    guint gconf_notify_open_feeds_to;

    gint avg_char_width;
    gint chars_per_line;
    gint line_height;
    gint displayed_lines;
    gint displayed_headlines;   /* number of headlines can be displayed on
                                 * one "page" of scrolledwindow */
    gint num_of_headlines;      /* number of loaded headlines */
    gint tree_height;
    gint space_between_rows;

    gint prev_width;
    gint prev_height;
} AppletInfo;

enum {
    ICON_COLUMN,
    URL_COLUMN,
    RENDER_COLUMN,
    TITLE_COLUMN,
    FEED_COLUMN,
    ITEMNR_COLUMN,
    N_COLUMNS,
};

/* TODO: this should be in osso-rss-feed-reader-lib */
enum {
    OPEN_TO_RSS,
    OPEN_TO_WEB
};

G_BEGIN_DECLS

#define RSS_TYPE_HOME_APPLET            (rss_home_applet_get_type ())
#define RSS_HOME_APPLET(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RSS_TYPE_HOME_APPLET, HomeRssApplet))
#define RSS_HOME_APPLET_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RSS_TYPE_HOME_APPLET, HomeRssAppletClass))
#define RSS_IS_HOME_APPLET(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RSS_TYPE_HOME_APPLET))
#define RSS_IS_HOME_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RSS_TYPE_HOME_APPLET))
#define RSS_HOME_APPLET_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RSS_TYPE_HOME_APPLET, HomeRssAppletPrivate))

typedef struct _HomeRssApplet    HomeRssApplet;
typedef struct _HomeRssAppletClass   HomeRssAppletClass;
typedef struct _HomeRssAppletPrivate HomeRssAppletPrivate;

struct _HomeRssApplet
{
  HDHomePluginItem parent;
  HomeRssAppletPrivate  *priv;
};

struct _HomeRssAppletPrivate
{
};

struct _HomeRssAppletClass
{
  HDHomePluginItemClass parent;
};

GType rss_home_applet_get_type (void);

G_END_DECLS


#endif
