/**
  * Copyright (C) 2004 Nokia. All rights reserved.
  *
  * @author Oleg Romashin <oleg.romashin@nokia.com>
  *
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public License
  * as published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this program; if not, write to the Free Software
  * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA
  *
  */
 
#ifndef LOCALESDEF_H
#define LOCALESDEF_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define _(String) dgettext ("osso-browser-ui", String)
#define HISTORY_ITEMS(n) dngettext ("osso-browser-ui", "weba_li_history_list_nr", "weba_li_history_list_nrs", n)

#define TR_WEB1_FOLDER_ROOT_USER "webb_folder_root_user"
#define TR_WEB1_NI_ADDING_NEW_HOME_FAILED "webb_ni_adding_new_home_failed"
#define TR_WEB1_NI_DOWNLOADING_PAUSED "webb_ni_downloading_paused"
#define TR_WEB1_NI_TARGET_FOLDER_NOT_AVAILABLE "webb_ni_target_folder_not_available"
#define TR_WEB1_NI_TARGET_LOCATION_NOT_AVAILABLE "webb_ni_target_location_not_available"
#define TR_WEB3_DOWNLOADS_PERCENTAGE "weba_fi_downloads_percentage"
#define TR_WEB3_SECURE_CONNECTION_DETAILS "weba_bd_secure_connection_details"
#define TR_WEB3_SECURE_CONNECTION_PROCEED "weba_bd_secure_connection_proceed"
#define TR_WEB3_SECURE_CONNECTION_TITLE "weba_ti_secure_connection_title"
#define TR_WEB3_SECURE_CONNECTION_UNTRUSTED_CERT "weba_ti_secure_connection_untrusted_cert"
#define TR_WEB3_SELECT_FILE_TITLE "weba_ti_select_file_title"
#define TR_WEB_BLANK_PAGE "weba_va_blank_page"
#define TR_WEB_DOWNLOADS_REC_KB "weba_va_downloads_rec_kb"
#define TR_WEB_DOWNLOADS_REC_PERCENT "weba_va_downloads_rec_percent"
#define TR_WEB_DOWNLOADS_SIZE_UNKNOWN "weba_va_downloads_size_unknown"
#define TR_WEB_DOWNLOAD_FILE "weba_ti_download_file_title"
#define TR_WEB_ENCODING_WIN_1250 "weba_va_encoding_win_1250"
#define TR_WEB_ENCODING_WIN_1251 "weba_va_encoding_win_1251"
#define TR_WEB_ENCODING_WIN_1253 "weba_va_encoding_win_1253"
#define TR_WEB_ENCODING_WIN_1254 "weba_va_encoding_win_1254"
#define TR_WEB_LOCATION_COMPLETION_SUF "weba_va_location_completion_suf"
#define TR_WEB4_CHANGE_SAVE_TARGET_LOCATION "webb_ni_change_save_target_location"
#define TR_WEB4_SAVE_PWD_SCOPE "weba_fi_save_pwd_scope"
#define TR_WEB4_SAVE_PWD_TITLE "weba_fi_save_pwd_title"
#define TR_WEB4_SELECT_USERNAME_TITLE "weba_fi_select_username_title"
#define TR_WEB3_SETTINGS_CONNECTION_PASSWORD_SAVING "weba_fi_settings_privacy_password"
#define TR_WEB_REMEMBER_PASSWORD "weba_ti_remeber_credentials"
#define TR_WEB4_SAVE_PWD_PAGE "weba_va_save_pwd_scope_page"
#define TR_WEB4_SAVE_PWD_SERVER "weba_va_save_pwd_scope_server"
#define TR_WEB4_SAVE_PWD_NOT_PAGE "weba_va_save_pwd_scope_not_page"
#define TR_WEB4_SAVE_PWD_NOT_SERVER "weba_va_save_pwd_scope_not_server"
#define TR_WEB_MENU_CLEAR "weba_me_clear"
#define TR_WEB_MENU_CLEAR_HISTORY "weba_me_clear_brow_hist"
#define TR_WEB_MENU_CLEAR_CACHE "weba_me_clear_cache"
#define TR_WEB_MENU_CLEAR_COOKIES "weba_me_clear_cookies"
#define TR_WEB_MENU_CLEAR_PASSWORDS "weba_me_clear_pwds"
#define TR_WEB_MENU_CLEAR_ALLPASSWORDS "weba_me_clear_all_personal_data"
#define TR_WEB_CLEAR_ALL_HISTORY_DETAILS "weba_nc_clear_histories"
#define TR_WEB_DELETE_ALL_CACHE_DETAILS "weba_nc_delete_cache_details"
#define TR_WEB_DELETE_ALL_COOKIES_DETAILS "weba_nc_clear_cookies"
#define TR_WEB_DELETE_ALL_PASSWORDS_DETAILS "weba_nc_clear_passwords"
#define TR_WEB_DELETE_ALL_PERSONAL_DETAILS "weba_nc_clear_personal"

#define TR_WEB_UNINSTALL_COMPONENT "weba_nc_uninstall_component"
#define TR_WEB_FIND_UPDATES "weba_bd_find_updates"
#define TR_WEB_UNINSTALL "weba_bd_uninstall"
#define TR_WEBA_FI_COMPONENT_STATE "weba_fi_component_state"
#define TR_WEBA_UNABLE_UNINSTALL "weba_ib_unable_to_uninstall"
#define TR_WEBA_PLUGIN_DETAILS_ENABLE "weba_fi_plugin_details_enable"
#define TR_WEBA_IB_UNABLE_UNINSTALL "weba_ib_unable_to_uninstall"

#define TR_EMBED_ADDRESS "weba_fi_address_colon"
#define TR_EMBED_SIZE "weba_fi_size_colon"
#define TR_EMBED_NAME "weba_fi_name_colon"
#define TR_EMBED_INSTALL_COMPONENT_TITLE "weba_ti_component_install"
#define TR_EMBED_CHECKING_UPDATES "weba_nw_checking_updates"
#define TR_EMBED_AVAIL_UPDATES_TITLE "weba_ti_component_updates"
#define TR_EMBED_BUTTON_INSTALL "weba_bd_install"
#define TR_EMBED_PROGRESS_INSTALL "weba_pb_installing"
#define TR_EMBED_INS_BUTTON_INSTALL "weba_ib_select_update_first"
#define TR_EMBED_BUTTON_CANCEL "weba_bd_cancel"
#define TR_EMBED_NOTE_RESTART "weba_nc_restart_to_apply_changes"
#define TR_EMBED_NOTE_NO_UPDATES "weba_ni_no_updates_found"
#define TR_EMBED_NOTE_SUCCESS_INSTALL "Success Installation."
#define TR_EMBED_NOTE_ERROR_INSTALL "Installation Error."

#define TR_WEB_PLUGINS_MENU "weba_me_components_menu"
#define TR_WEB_PLUGINS_DETAILS "weba_me_plug_ins_details"
#define TR_WEB_TI_PLUGINS "weba_ti_plugins"
#define TR_WEB_PLUGIN_DETAILS "weba_ti_plug_ins_details_title"
#define TR_WEB_PLUGIN_DETAILS_STATE "weba_fi_plugin_details_state"
#define TR_WEB_VA_PLUGINS_STATE_ENABLED "weba_va_plugins_state_enabled"
#define TR_WEB_VA_PLUGINS_STATE_DISABLED "weba_va_plugins_state_disabled"
#define TR_WEB_PLUGIN_DETAILS_SUPPORT "weba_fi_plugin_details_support"
#define TR_WEB_PLUGIN_DETAILS_AUTH_VEND "weba_fi_plugin_details_author"
#define TR_WEB_PLUGIN_DETAILS_TOOLBAR_SHORTCUT "weba_fi_plugin_details_shortcut"
#define TR_WEB_PLUGINS_NO_DESCRIPTION "webb_ia_no_description"
#define TR_WEB_NO_PLUGINS "webb_ia_no_plug-ins"
#define TR_WEB4_STRING_BOOKMARK_MANAGER "weba_me_manage_bookmarks"
#define TR_WEB4_STRING_NO_BOOKMARKS "webb_ia_no_bookmarks_folders_to_show"
#define TR_WEB5_COPY_LINK_LOCATION "weba_me_copy_address"
#define TR_WEB5_SETTINGS_COOKIES_ALWAYS "weba_va_settings_privacy_accept_cookies_always"
#define TR_WEB5_SETTINGS_COOKIES_NEVER "weba_va_settings_privacy_accept_cookies_never"
#define TR_WEB5_SETTINGS_COOKIES_ASK "weba_va_settings_privacy_accept_cookies_askfirst"
#define TR_WEB5_SETTINGS_POP_WIN_ASK "weba_va_settings_privacy_enable_pop_up_windows_askfirst"
#define TR_WEB5_SETTINGS_POP_WIN_ALWAYS "weba_va_settings_privacy_enable_pop_up_windows_always"
#define TR_WEB5_SETTINGS_POP_WIN_NEVER "weba_va_settings_privacy_enable_pop_up_windows_never"
#define TR_WEB5_ADD_FEED_TO_NEWS "weba_me_add_feed_to_news"
#define TR_WEB5_ADD_TO_ADDRESSBOOK "weba_me_add_to_contacts"
#define TR_WEB_ZOOM_VAL "weba_me_zoom_"
#define TR_WEB_ZOOM_APP ""
#define TR_WEB3_SECURE_CNNECTION_SERVER "weba_fi__secure_connection_server"
#define TR_WEB3_SECURE_CONNECTION_AUTHORITY "weba_fi__secure_connection_authority"
#define TR_WEB3_SECURE_CONNECTION_EXPIRED "weba_fi__secure_connection_expired"
#define TR_WEB3_SECURE_CONNECTION_NOT_VALID_YET "weba_fi__secure_connection_not_valid_yet"
#define TR_WEB3_SECURE_CONNECTION_OWNER "weba_fi__secure_connection_owner"
#define TR_WEB3_SETTINGS_CONNECTION_ENABLESSL2 "weba_fi_settings_connection_enablessl2"
#define TR_WEB3_SETTINGS_GENERAL_MAXC_4096 "weba_va_settings_general_maxc_4096"
#define TR_WEB3_SETTINGS_GENERAL_MAXC_2048 "weba_va_settings_general_maxc_2048"
#define TR_WEB3_SETTINGS_GENERAL_MAXC_1024 "weba_va_settings_general_maxc_1024"
#define TR_WEB3_SETTINGS_GENERAL_MAXC_512 "weba_va_settings_general_maxc_512"
#define TR_WEB3_SETTINGS_GENERAL_MAXC_AUT "weba_va_settings_general_maxc_aut"
#define TR_WEB3_SETTINGS_GENERAL_MAXC_OFF "weba_va_settings_general_maxc_off"
#define TR_WEB_ACCEPT "weba_bd_cookie_conf_accept"
#define TR_WEB_ACCEPT_COOKIES "weba_fi_settings_privacy_accept_cookies"
#define TR_WEB_ACCEPT_REJECT_COOKIE "weba_ti_cookie_conf_accept_nor"
#define TR_WEB_ACCEPT_REJECT_COOKIE_WITH_ILLEGAL_PATH "weba_ti_cookie_conf_accept_ill"
#define TR_WEB_ADD_BOOKMARK "weba_ti_add_bookmark_title"
#define TR_WEB_ADD_TO_BOOKMARKS "weba_me_add_to_bookmark"
#define TR_WEB_AFTER_SESSION_ENDS "webb_ia_cookie_after_sessions_ends"
#define TR_WEB_ALERT "weba_ti_java_script_alert"
#define TR_WEB_ALL_WINDOWS "weba_me_close_all_windows"
#define TR_WEB_ALWAYS "weba_me_show_images_always"
#define TR_WEB_AUTHENTICATION "weba_ti_auhentication_title"
#define TR_WEB_BDIMENSIONSB "weba_fi_image_details_dimensions"
#define TR_WEB_BDOMAINB "weba_fi_cookie_details_domain"
#define TR_WEB_BENCODINGB "weba_fi_page_details_encoding"
#define TR_WEB_BEXPIRESB "weba_fi_cookie_details_expiration"
#define TR_WEB_BOOKMARKS "weba_me_bookmarks"
#define TR_WEB_BPATHB "weba_fi_cookie_details_path"
#define TR_WEB_BSECURITYB "weba_fi_page_details_security"
#define TR_WEB_BTITLEB "weba_fi_page_details_page_title"
#define TR_WEB_BVALUEB "weba_fi_cookie_details_value"
#define TR_WEB_CANCEL_DOWNLOAD_AND_DEL "weba_nc_delete_dowload"
#define TR_WEB_CLOSE "weba_me_close"
#define TR_WEB_CLOSE_APPLICATION_AND_P "weba_nc_close_app_pause_load"
#define TR_WEB_CONFIRMATION "weba_ti_java_script_confirmation"
#define TR_WEB_CONNECTION "weba_ti_settings_connection_title"
#define TR_WEB_COOKIE_DETAILS "weba_ti_cookie_details_title"
#define TR_WEB_COOKIE_TITLE "weba_ti_cookie_conf"
#define TR_WEB_BACK "weba_me_back"
#define TR_WEB_FORWARD "weba_me_forward"
#define TR_WEB_RELOAD "weba_me_reload"
#define TR_WEB_GO "weba_me_go"
#define TR_WEB_COPY "weba_me_copy"
#define TR_WEB_CUT "weba_me_cut"
#define TR_WEB_DELETE_ITEM_FROM_HISTOR "weba_nc_delete_history_item"
#define TR_WEB_DETAILS "weba_me_details"
#define TR_WEB_DISPLAY_FRAME_BORDERS_A "weba_fi_settings_general_viewfb"
#define TR_WEB_DOWNLOADS "weba_me_downloads"
#define TR_WEB_EDIT "weba_me_edit"
#define TR_WEB_ENABLE_AUTOMATIC_REDIRE "weba_fi_settings_privacy_enable_automatic_redirection"
#define TR_WEB_ENABLE_JAVASCRIPT "weba_fi_settings_plug_ins_enable_java_script"
#define TR_WEB_ENABLE_PLUGINS "weba_va_enable_plugins"
#define TR_WEB_ENABLE_POPUP_WINDOWS "weba_fi_settings_privacy_enable_pop_up_windows"
#define TR_WEB_ENCODING "weba_me_encoding"
#define TR_WEB_ENCODING_ISO_8859_1 "weba_va_encoding_iso_8859_1"
#define TR_WEB_ENCODING_ISO_8859_15 "weba_va_encoding_iso_8859_15"
#define TR_WEB_ENCODING_ISO_8859_2 "weba_va_encoding_iso_8859_2"
#define TR_WEB_ENCODING_ISO_8859_7 "weba_va_encoding_iso_8859_7"
#define TR_WEB_ENCODING_ISO_8859_9 "weba_va_encoding_iso_8859_9"
#define TR_WEB_ENCODING_UTF_16 "weba_va_encoding_utf_16"
#define TR_WEB_ENCODING_UTF_8 "weba_va_encoding_utf_8"
#define TR_WEB_ENCODING_WIN_KOI_8R "weba_va_encoding_win_koi_8r"
#define TR_WEB_ENCODING_BIG5 "weba_va_encoding_big5"
#define TR_WEB_ENCODING_GB_18030 "weba_va_encoding_gb_18030"
#define TR_WEB_ENCODING_ISO_2022_CN "weba_va_encoding_iso_2022_cn"
#define TR_WEB_ENCODING_EUC_TW "weba_va_encoding_euc_tw"
#define TR_WEB_FIND_ON_PAGE "weba_me_find_on_page"
#define TR_WEB_FULL_SCREEN "weba_me_full_screen"
#define TR_WEB_FULL_SCREEN_SHOW "weba_me_toolbar_show_full"
#define TR_WEB_GENERAL "weba_ti_settings_general_title"
#define TR_WEB_GO_TO "weba_bd_history_list_go_to"
#define TR_WEB_HELP "weba_me_help"
#define TR_WEB_HIGH "weba_va_high"
#define TR_WEB_HISTORY_LIST "weba_me_history_list"
#define TR_WEB_HOME_PAGE "weba_me_home_page"
#define TR_WEB_HOME_PAGE_LOCATION "weba_fi_settings_connection_home_page_location"
#define TR_WEB_HOTFIX10 "weba_ti_encoding_title"
#define TR_WEB_ENCODING_FIELD "weba_fi_encoding_method"
#define TR_WEB_HOTFIX11 "weba_ti_downloads_title"
#define TR_WEB_HOTFIX12 "weba_nc_close_app_pause_loads"
#define TR_WEB_HOTFIX9 "weba_ti_history_list_title"
#define TR_WEB_IMAGE "weba_me_image"
#define TR_WEB_IMAGE_DETAILS "weba_ti_image_details_title"
#define TR_WEB_LINK_DETAILS "weba_ti_link_details_title"
#define TR_WEB_LOAD_IMAGE "weba_me_load_image"
#define TR_WEB_COPY_IMG_LINK "weba_me_copy_img_location"
#define TR_WEB_LOW "weba_va_low"
#define TR_WEB_MAXIMUM_CACHE_SIZEKB "weba_fi_settings_general_maxcache"
#define TR_WEB_MEDIUM "weba_va_medium"
#define TR_WEB_HOTFIX8 "weba_me_settings"
#define TR_WEB_NAME "weba_fi_downloads_name"
#define TR_WEB_NAVIGATION "weba_me_navigation"
#define TR_WEB_NEVER "weba_me_show_images_never"
#define TR_WEB_NEW_WINDOW "weba_me_new_window"
#define TR_WEB_BROWSER_MENU "weba_va_browser_menu"
#define TR_WEB_NORMAL_SCREEN "weba_me_toolbar_show_normal"
#define TR_WEB_NO "webb_db_change_save_target_location_no"
#define TR_WEB_PLUGINS__SCRIPTS "weba_va_plugins__scripts"
#define TR_WEB5_NO_MEM_PERFORM_OPERATION "webb_ni_no_memory_perform_operation"
#define TR_WEB_PRIVACY "weba_va_privacy"
#define TR_WEB_TEXTHTML "weba_va_texthtml"
#define TR_WEB_NOT_A_SECURE_PAGE "weba_va_not_secure"
#define TR_WEB_NOT_DEFINED_IN_HTML "webb_ia_not_defined_in_html"
#define TR_WEB_NO_APPLICATION_TO_OPEN_EMBEDDED "webb_ia_no_application_to_open_with"
#define TR_WEB_NO_DOWNLOADS "webb_ia_no_downloads"
#define TR_WEB_NO_HISTORY "webb_ia_no_history"
#define TR_WEB_OBJECT_DETAILS "weba_ti_object_details_title"
#define TR_WEB_ONLY_LOADED "weba_me_show_images_loaded"
#define TR_WEB_ADD_LINK_MEDIALIBRARY "weba_me_add_link_medialibrary"
#define TR_WEB_ADD_RADIO_CHANNEL "webb_ni_add_radio_channel"
#define TR_WEB_DOWNLOAD_OPEN_BUTTON "weba_bd_download_file_open"
#define TR_WEB_OPEN_FILE "weba_me_open_file"
#define TR_WEB_OPEN_PAGE "weba_me_open_page"
#define TR_WEB_OPEN_WEB_PAGE "weba_ti_open_page_title"
#define TR_WEB_OPTIMISED_VIEW "weba_me_optimised_view"
#define TR_WEB_PAGE_DETAILS "weba_ti_page_details_title"
#define TR_WEB_PASSWORD "weba_fi_auhentication_password"
#define TR_WEB_PASTE "weba_me_paste"
#define TR_WEB_PAUSE "weba_bd_downloads_pause"
#define TR_WEB_PROMPT "weba_ti_java_script_prompt"
#define TR_WEB_REALM "weba_fi_auhentication_realm"
#define TR_WEB_REJECT "weba_bd_cookie_conf_reject"
#define TR_WEB_RESUME "weba_bd_downloads_resume"
#define TR_WEB_RESUMING_DOWNLOAD_FAILE "webb_ni_resuming_failed"
#define TR_WEB_SAVE "weba_bd_download_file_save"
#define TR_WEB_SAVE_WITH_IMAGES_AS "weba_me_save_images_as"
#define TR_WEB_SEND_AS_EMAIL "weba_me_send_as_email"
#define TR_WEB_OPTIONS "weba_me_options"
#define TR_WEB_SETTINGS_TITLE "weba_ti_settings_title"
#define TR_WEB_SET_HOME_PAGE "weba_ti_set_home_page_title"
#define TR_WEB_SET_MENU_HOME_PAGE "weba_me_set_home_page"
#define TR_WEB_SHOW_IMAGES "weba_me_show_images"
#define TR_WEB_SHOW_TOOL_BAR "weba_me_toolbar_show"
#define TR_WEB_SITE "weba_fi_auhentication_site"
#define TR_WEB_SIZE "weba_fi_downloads_size"
#define TR_WEB_STOP "weba_me_stop"
#define TR_WEB_THIS_FRAME "weba_me_this_frame"
#define TR_WEB_TOOLS "weba_me_tools"
#define TR_WEB_UNKNOWN "webb_ia_unknown"
#define TR_WEB_USER_NAME "weba_fi_auhentication_username"
#define TR_WEB_USE_DEFAULT_LOCAL_HOME_ "weba_fi_settings_connection_default_home_page"
#define TR_WEB_VIEW "weba_me_screen"
#define TR_WEB_WEB "weba_ap_web_browser"
#define TR_WEB_WEB_PAGE "weba_me_web_page"
#define TR_WEB_WINDOW "weba_me_close_window"
#define TR_WEB_WINDOWS "weba_me_windows"
#define TR_WEB_YES "webb_db_change_save_target_location_yes"
#define TR_WEB_DLG_YES "weba_va_yes"
#define TR_WEB_DLG_NO "weba_va_no"
#define TR_WEB_ZOOM "weba_me_zoom"
#define TR_WEB_ZOOM_IN "weba_me_zoom_in"
#define TR_WEB_ZOOM_OUT "weba_me_zoom_out"
#define TR_WEB_CONNECTING "weba_pb_connecting"
#define TR_WEB_RECEIVING "weba_pb_receiving"
#define TR_WEB_UPLOADING "weba_pb_uploading"
#define TR_WEB_IA_NOT_AVAILABLE "webb_ia_not_available"
#define TR_WEB4_STRING_ADD_BOOKMARK "weba_me_add_to_bookmark"
#define TR_WEB5_OPEN_LINK_IN_NEW_WINDOW "weba_me_open_link_new_window"
#define TR_WEB5_ADD_LINK_TO_BOOKMARKS "weba_me_add_link_bookmarks"
#define TR_WEB5_COMPOSE_EMAIL_MESS "weba_me_compose_email"
#define TR_WEB5_APPLY_TO_ALL_COOKIES_FROM_SERVER "weba_ti_cookie_conf_server"
#define TR_WEB_THIS_ITEM_IS_NOT_AVAILA "webb_ia_not_available"
#define TR_WEB_PIXELS "weba_va_image_details_dim_px"
#define TR_WEB_KB "weba_va_downloads_rec_kb"
#define TR_WEB_KB_FLOAT "weba_va_downloads_size_kb"
#define TR_WEB_ZOOMING_TO "weba_ib_zooming_"
#define TR_WEB_SETTINGS_DIALOG_PRIVACYTAB "weba_ti_settings_privacy_title"
#define TR_WEB_MODAL_DIALOG_ABORT "weba_va_modal_dialog_abort"
#define TR_WEB_MODAL_DIALOG_CANCEL "weba_va_modal_dialog_cancel"
#define TR_WEB_MODAL_DIALOG_IGNORE "weba_va_modal_dialog_ignore"
#define TR_WEB_MODAL_DIALOG_NO "weba_va_modal_dialog_no"
#define TR_WEB_MODAL_DIALOG_OK "weba_va_modal_dialog_ok"
#define TR_WEB_MODAL_DIALOG_RETRY "weba_va_modal_dialog_retry"
#define TR_WEB_MODAL_DIALOG_YES "weba_va_modal_dialog_yes"
#define TR_WEB_HISTORY_LIST_FOLDER "weba_li_history_list_folder"
#define TR_WEB_HISTORY_ITEM_TIME "weba_li_history_list_item_time"
#define TR_WEB_HISTORY_ITEM_NAME "weba_li_history_list_item_name"
#define TR_WEB_COOKIE_DETAILS_SLASH "weba_fi_cookie_details_slash"
#define TR_WEB_ME_SHOW_FLASH_FILES "weba_me_show_flash_files"
#define TR_WEB_DETAILS_CERTIFICATE_NAME "weba_bd_certificate"
#define TR_WEB_INVALID_USER_NAME "weba_ib_invalid_username_or_password"
#define TR_WEB3_SOME_CACHE_ITEMS_CANNOT_BE_DELETED "weba_ib_some_cache_items_cannot_be_deleted"
#define TR_WEB3_ZOOMING_OUT "weba_ib_zooming_out"
#define TR_WEB_IB_NOTHING_TO_DISABLE "weba_ib_nothing_to_disable"
#define TR_WEB2_ZOOMING_IN "weba_ib_zooming_in"
#define TR_WEB3_DOWNLOADING_COMPLETE "weba_ib_downloading_complete"
#define TR_WEB_ALREADY_AT_END_OF_HISTO "weba_ib_already_at_end_of_history_list"
#define TR_WEB_ALREADY_AT_TOP_OF_HISTO "weba_ib_already_at_top_of_history_list"
#define TR_WEB_A_WINDOW_HAS_BEEN_CLOSE "weba_ib_closing_a_window_background"
#define TR_WEB_POP_WINDOW_BLOCKED "weba_ib_pop_up_window_blocked"
#define TR_WEB_ENTER_LOCATION_FIRST "weba_ib_enter_location"
#define TR_WEB_MERGE_FRAMES "weba_me_merge_frames" /* Not Available */
#define TR_WEB_ENCODING_AUTOMATIC "weba_va_encoding_automatic" // NOT AVAILABLE
#define TR_WEB_NOTHING_TO_ADD_TO_BOOKM "weba_ib_nothing_to_add_to_bm"
#define TR_WEB_NOTHING_TO_PAUSE "weba_ib_nothing_to_pause"
#define TR_WEB_NO_HOME_PAGE_DEFINED "weba_ib_no_home_page_defined" 
#define TR_WEB_OPENING_A_NEW_WINDOW "weba_ib_opening_new_window"
#define TR_WEB_UNABLE_TO_PASTE "weba_ib_unable_paste"
#define TR_WEB_UPLOAD_FAILED "weba_ib_upload_failed"
#define TR_WEB_IB_NO_MEMORY_FOR_DOWNLOAD "weba_ib_no_memory_for_download"
#define TR_WEB_FILE_CANNOT_BE_SAVED "weba_ib_file_cannot_be_saved"
#define TR_WEB_VA_SAVE_COMPLETE "weba_va_save_complete"
#define TR_WEB_VA_SAVE_HTML_ONLY "weba_va_save_html_only"
#define TR_WEB_PASSWORD_DIALOG_MESSAGE "weba_nc_remember_credentials"
#define TR_WEB_PASSWORD_DIALOG_YES "weba_bd_yes"
#define TR_WEB_PASSWORD_DIALOG_NEVER "weba_bd_never"
#define TR_WEB_PASSWORD_DIALOG_NOTNOW "weba_bd_not_now"
#define TR_WEBA_ME_SAVE_TARGET_AS "weba_me_save_target_as"

#define TR_WEB_OPEN_LINK "weba_me_open_link"
#define TR_WEBA_BD_OK "weba_bd_ok"     
#define TR_WEBA_BD_CANCEL "weba_bd_cancel"
#define TR_WEBA_BD_STOP "weba_bd_stop"   
#define TR_WEBA_BD_DELETE "weba_bd_delete" 
#define TR_WEBA_BD_CLOSE "weba_bd_close"
#define TR_WEBA_BD_DETAILS "weba_bd_details"
#define TR_WEBA_FI_NAME "weba_fi_name"   
#define TR_WEBA_FI_ADDRESS "weba_fi_address"
#define TR_WEBA_FI_LOCATION "weba_fi_location"       
#define TR_WEBA_FI_NAME_COLON "weba_fi_name_colon"
#define TR_WEBA_FI_ADDRESS_COLON "weba_fi_address_colon"
#define TR_WEBA_FI_TYPE_COLON "weba_fi_type_colon"
#define TR_WEBA_FI_SIZE_COLON "weba_fi_size_colon"
#define TR_WEBA_FI_OPEN_WITH_COLON "weba_fi_open_with_colon"
#define TR_WEBA_VA_SAVED_PASSWORD "weba_va_saved_password"
#define TR_WEB_DOWNLOAD_FROM "weba_va_download_from"
#define TR_WEB_SETTINGS_AUTO_FOCUS_ADDRESS "weba_va_settings_autofocus"
#define TR_WEB_SETTINGS_ENABLE_ROTATION "weba_va_settings_portrait"
#define TR_WEBA_SUSPEND_TIMEOUTS_IMMEDIATELY "weba_va_settings_javaflash_immediately"
#define TR_WEBA_SUSPEND_TIMEOUTS_IN_15_S "weba_va_settings_javaflash_in15"
#define TR_WEBA_SUSPEND_TIMEOUTS_IN_30_S "weba_va_settings_javaflash_in30"
#define TR_WEBA_SUSPEND_TIMEOUTS_IN_60_S "weba_va_settings_javaflash_in60"

//OS2008
#define TR_WEBA_BD_ADD_ADDRESS "weba_ti_add_adress"
#define TR_WEBA_BD_ADD_BM "weba_me_add_bookmark"
#define TR_WEBA_BD_ADD_HOME "weba_me_add_home"
#define TR_WEBA_BD_ADD_RSS "weba_me_rss"

#define TR_WEBA_BD_OPTIONS "weba_ti_options"
#define TR_WEBA_BD_OPTIONS_DT "weba_me_details"
#define TR_WEBA_BD_OPTIONS_ADJ "weba_me_adjustview"
#define TR_WEBA_BD_OPTIONS_COMP "weba_me_components"
#define TR_WEBA_BD_OPTIONS_ST "weba_me_settings"
#define TR_WEBA_BD_OPTIONS_CLD "weba_me_clear_privatedata"

#define TR_WEBA_BD_CLP_DATA "weba_ti_clear_privatedata" 
#define TR_WEBA_BD_CLP_HIS "weba_fi_browsing_his" 
#define TR_WEBA_BD_CLP_CACHE "weba_fi_cache" 
#define TR_WEBA_BD_CLP_COOKIES "weba_fi_cookies" 
#define TR_WEBA_BD_CLP_PASS "weba_fi_saved_pass" 
#define TR_WEBA_BD_CLP_AUTH "weba_fi_authentivated" 
#define TR_WEBA_BD_CLP_CLEAR "weba_db_clear" 
#define TR_WEBA_NC_CLOSE "weba_nc_close"

#define TR_WEB5_OPEN_IN_NEW_WINDOW "weba_me_open_in_new_window"
#define TR_WEB5_ADD_TO "weba_me_add"
#define TR_WEB5_ADD_LINK_TO "weba_me_add_link"
#define TR_WEB5_SAVE_LINK_AS "weba_me_save_link_as"
#define TR_WEB5_COPY_IMAGE_ADDRESS "weba_me_copy_img_address"
#define TR_WEB5_LOAD_IMAGE "weba_me_load_img"
#define TR_WEB5_SAVE_IMAGE "weba_me_save_img"
#define TR_WEB5_SAVE_AS "weba_save_as"

#define TR_WEB5_WEBSTART "weba_ti_webstart"
#define TR_WEB5_OPENFILE "weba_me_openfile"
#define TR_WEB5_MANGBOO "weba_me_mangboo"

#define TR_WEB5_BOOKMARKS "weba_ti_bookmarks"
#define TR_WEB5_OPEN_BOOKMARK_NEW_WINDOW "weba_me_open_bookmark_new_window"
#define TR_WEB5_BOOKMARK_FOLDERNAME "weba_ti_foldername"
#define TR_WEB5_IMPORTING_BOOKMARKS "webb_nw_importing_bookmark"

#define TR_WEB5_RECENT_HISTORY_TITLE "weba_ti_recenthis"
#define TR_WEB5_COMPLETE_HISTORY "weba_me_complete_his"

#define TR_WEB5_COMPLETE_HISTORY_MAIN_TITLE "weba_ti_compbrhis"
#define TR_WEB5_COMPLETE_HISTORY_FOLDER_TITLE "weba_yi_hisfolder"
#define TR_WEB5_COMPLETE_HISTORY_ITEM_NAME "weba_li_history_list_item_name"
#define TR_WEB5_COMPLETE_HISTORY_ITEM_NR "weba_li_history_list_nr"
#define TR_WEB5_COMPLETE_HISTORY_ITEM_NRS "weba_li_history_list_nrs"
#define TR_WEB5_COMPLETE_HISTORY_TODAY "weba_li_history_list_today"
#define TR_WEB5_COMPLETE_HISTORY_YESTERDAY "weba_li_history_list_yesterday"
#define TR_WEB5_COMPLETE_HISTORY_NONE "webb_ia_none"


#define TR_WEB5_DOWNLOAD_OPEN_WITH "weba_bd_download_open_with"
#define TR_WEB5_DOWNLOAD_SAVE "weba_bd_download_save_to"
#define TR_WEB5_DOWNLOAD_FILE_SIZE "weba_va_download_file_size_kb"

#define TR_WEB5_ADJUVI_TI_TITLE "weba_ti_adjuvi_title"
#define TR_WEB5_ADJUVI_TI_SHOWIMG "weba_ti_adjuvi_met_showimg"
#define TR_WEB5_ADJUVI_ALWAYS "weba_va_always"
#define TR_WEB5_ADJUVI_LOADED "weba_va_loaded"
#define TR_WEB5_ADJUVI_NEVER "weba_va_never"
#define TR_WEB5_ADJUVI_TI_TEXT "weba_ti_text"
#define TR_WEB5_ADJUVI_NORMAL "weba_va_normal"
#define TR_WEB5_ADJUVI_LARGER "weba_va_larger"
#define TR_WEB5_ADJUVI_LARGEST "weba_va_largest"
#define TR_WEB5_ADJUVI_TI_ENCODING "weba_fi_encoding"
#define TR_WEB5_DB_SELECT_CLEAR_ALL "weba_bd_select_clear_alll"
#define TR_WEB5_PAGE_DETAILS_VERIFICATION "weba_fi_page_details_verification"
#define TR_WEB5_PAGE_DETAILS_NOT_VERIFIED "weba_va_page_not_verified"
#define TR_WEB5_SECURE_SERVER "weba_ib_secure_server"

#define TR_WEB_SAVE_AS "weba_me_save_page"
#define TR_WEB_SEARCH_LIST "weba_search_list"

#define TR_WEB_LIST_SELECT "weba_ti_texlist_single"
#define TR_WEB_LIST_SELECT_MULTI "weba_ti_textlist_multi"

#define TR_WEB_SETTINGS_JAVAFLASH "weba_va_settings_javaflash"
#define TR_WEB_SETTINGS_FULLSCREEN "weba_va_settings_fullscreen"
#define TR_WEB_SETTINGS_HWKEYS "weba_va_settings_hwkeys"
#define TR_WEB_SETTINGS_HWKEYS_ZOOM "weba_va_settings_hwkeys_zoom"
#define TR_WEB_SETTINGS_HWKEYS_VOLUME "weba_va_settings_hwkeys_volume"
#define TR_WEB_SETTINGS_BROWSER "weba_ti_settings_browser"
#define TR_WEB_SETTINGS_CONTENT "weba_ti_settings_content"

#define TR_WEBA_GEOLOCATION "weba_ti_geolocoation"
#define TR_WEBA_GEOLOCATION_DIS "weba_nc_geolocaton_dis"
#define TR_WEBA_GEOLOCATION_ALLOW "weba_bd_geolocaton_allow"
#define TR_WEBA_GEOLOCATION_ALWAYS "weba_bd_geolocaton_always"
#define TR_WEBA_GEOLOCATION_NEVER "weba_bd_geolocaton_never"

// bookmarks
#define TR_WEB5_DELETE_ITEMS(n) dngettext ("osso-browser-ui", "webb_nc_delete_item_nr", "webb_nc_delete_item_nrs", n)
#define TR_WEB5_REPLACE_ITEMS(n) dngettext ("osso-browser-ui", "webb_nc_replace_item_nr", "webb_nc_replace_item_nrs", n)
#define TR_WEB5_BM_SELECTBOOK "webb_ti_selectbok"
#define TR_WEB5_BM_DELETEBOOK "weba_ti_deletebook"
#define TR_WEB6_ST7_EDIT_FOLDER "weba_ti_edit_folder"
#define TR_WEB6_ST4_EDIT_BOOKMARK_TITLE "weba_ti_edit_bookmark_title"
#define TR_WEB9_ST3_IMPORT_BOOKMARKS "bookm_ti_import_bookmarks"
#define TR_WEB9_ST3_IMPORTED_BOOKMARKSD "bookm_li_imported_bookmarksd"
#define TR_WEB9_ST3_IMPORTED_BOOKMARKS "webb_folder_imported_bookmarks"
#define TR_WEB7_ST7_BOOKMARK_DETAILS_TITLE "webb_ti_bookmark_details_title"
#define TR_WEB7_ST7_FOLDER_DETAILS "webb_ti_folder_details"
#define TR_WEB7_ST4_FOLDER_DETAILS_CONTENTS "webb_fi_folder_details_contents"
#define TR_WEB7_ST4_BOOKMARK_DETAILS_ADDED "webb_fi_bookmark_details_add"
#define TR_WEB7_ST4_FOLDER_DETAILS_ADDED "webb_fi_folder_details_date"
#define TR_WEB7_ST4_BOOKMARK_DETAILS_USE "webb_fi_bookmark_details_use"
#define TR_WEB7_ST4_FOLDER_DETAILS_USE "webb_fi_folder_details_time"
#define TR_WEB7_ST8_NONE "webb_ia_none"
#define TR_WEB5_FOLDER_DETAILS_CONTENTS_FOLDER(n) dngettext ("osso-browser-ui", \
    "webb_fi_folder_details_contents_folder", \
    "webb_fi_folder_details_contents_folders", n)
#define TR_WEB5_FOLDER_DETAILS_CONTENTS_BOOKMARK(n) dngettext ("osso-browser-ui", \
    "webb_fi_folder_details_contents_bookmark", \
    "webb_fi_folder_details_contents_bookmarks", n)
#define TR_WEB5_BM_DELETE_ME "webb_me_delete"
#define TR_WEB5_BM_DETAILS_ME "webb_me_details"
#define TR_WEB5_BM_EDIT_ME "webb_me_file_edit"
#define TR_WEB7_ST12_DELETE_BOOKMARK "webb_nc_delete_bookmark"
#define TR_WEB7_ST12_DELETE_BOOKMARKS "webb_nc_delete_bookmarks"
#define TR_WEB7_ST12_DELETE_FOLDER "webb_nc_delete_folder"
#define TR_WEB7_ST12_DELETE_FOLDERS "webb_nc_delete_folders"
#define TR_WEB5_BM_MOVETO_ME "webb_me_move_to"
#define TR_WEB5_BM_MOVETO_BTN "weba_bd_moveto"
#define TR_WEB5_MOVING_BOOKMARK "webb_nw_moving_bookmark"
#define TR_WEB7_ST10_IMPORT "webb_me_impor"
#define TR_WEB7_ST13_INVALID_BM_FILE "webb_ni_invalid_bookmarks_file"
#define TR_WEB5_DELETING_BOOKMARK  "webb_nw_deleting_bookmark"
#define TR_WEB_JAVASCRIPT_CONFIRMATION "weba_ti_java_script_confirmation"
#define TR_WEB_JAVASCRIPT_ALERT "weba_ti_javas_alert"

//osso_widgets
#define W_(String) dgettext ("hildon-common-strings", String)
#define TR_WEB3_BOOKMARK_EXISTS "ckdg_ib_bookmark_exists"
#define TR_WEB3_ENTER_NAME "ckdg_ib_enter_name"
#define TR_WEB3_ILLEGAL_CHARACTERS_ENTERED "ckdg_ib_illegal_characters_entered"
#define TR_WEB_NOTHING_TO_COPY "ckct_ib_unable_to_copy"
#define TR_WEB_MAXIMUM_NUMBER_OF_CHARA "ckdg_ib_maximum_characters_reached"
#define TR_WEB_MAXIMUM_ZOOM_LEVEL_REAC "ckct_ib_max_zoom_level_reached"
#define TR_WEB_MINIMUM_ZOOM_LEVEL_REAC "ckct_ib_min_zoom_level_reached"
#define TR_WEB_NOTHING_TO_SEND "ckdg_ib_nothing_to_send"
#define TR_WEB_NOTHING_TO_CUT "ckct_ib_unable_to_cut"
#define TR_WEB_NOTHING_TO_DELETE "ckct_ib_nothing_to_delete"
#define TR_WEB_NOTHING_TO_PASTE "ecoc_ib_edwin_nothing_to_paste"
#define TR_WEB3_NOTHING_TO_SELECT "ckct_ib_nothing_to_select"
#define TR_WEB_NOTHING_TO_OPEN "ckct_ib_nothing_to_open"
#define TR_WEB_UNABLE_TO_OPEN_UNSUPPORTED_FORMAT "ckct_ni_unable_to_open_unsupported_file_format"
#define TR_WEB9_NOT_ENOUGH_MEMORY "sfil_ni_not_enough_memory"
#define TR_WEB9_ST3_DEVICE_FOLDER_NOT_AVAILABLE  "sfil_ni_folder_not_found_switched_to_another_folder"
#define TR_WEB_UPDATING "ckdg_pb_updating"
#define TR_WEB_CANNOT_OPEN_NO_CONNECTION "sfil_ni_cannot_open_no_connection"
#define TR_WEB_UNABLE_TO_MOVE_TO_CURRENT_LOCATION "ckdg_ib_unable_to_move_to_current_location"
#define TR_WEB_UNABLE_TO_MOVE_FOLDER_INTO_ITSELF "ckdg_ib_unable_to_move_folder_into_itself"
#define TR_WEB_UNABLE_TO_DELETE "ckct_ib_unable_to_delete"
#define TR_WEB_UNABLE_TO_MOVE "sfil_ib_unable_to_move_selected_items"
 
//osso-uri
#define U_(String) dgettext ("osso-uri", String)
#define TR_WEB_MISSING_PROTOCOL "uri_link_error_missing_protocol"
#define TR_WEB_INVALID_PROTOCOL "uri_link_error_invalid_protocol"

//osso_file_management
#define M_(String) dgettext ("hildon-fm", String)

#define TR_WEB3_REPLACE_FILE "docm_nc_replace_file"
#define TR_WEB3_REPLACE_FILE_OK "docm_bd_replace_file_ok"
#define TR_WEB_CHANGE_FOLDER "ckdg_ti_change_folder"
#define TR_WEB4_SAVING_NOT_ALLOWED "sfil_ib_saving_not_allowed"
#define TR_WEB9_ST3_NOT_AVAILABLE_SAVE_LOCAL_YES "sfil_bd_not_available_save_local_yes"
#define TR_WEB9_ST3_NOT_AVAILABLE_SAVE_LOCAL_NO "sfil_bd_not_available_save_local_no"
#define TR_WEB_NO_APPLICATION_TO_OPEN "sfil_ib_opening_not_allowed"
#define TR_WEBA_BM_LOCATION_COLON "sfil_fi_save_objects_location"
#define TR_WEB7_MOVE_TO_DIALOG_TITLE  "ckdg_ti_move_to_folder"
#define TR_WEB_PROPERTIES_SIZE_10MB_1GB "ckdg_va_properties_size_10mb_1gb"
#define TR_WEB_PROPERTIES_SIZE_1MB_10MB "ckdg_va_properties_size_1mb_10mb"
#define TR_WEB_PROPERTIES_SIZE_100KB_1MB "ckdg_va_properties_size_100kb_1mb"

//ke-recv
#define K_(String) dgettext ("ke-recv", String)
#define TR_WEB_NO_MEMORY_PERFORM_OPERATION "memr_ib_operation_disabled"

//hildon-libs
#define H_(String) dgettext ("hildon-libs", String)
#define TR_WEB3_SEARCH_COMPLETE "ckct_ib_find_search_complete"
#define TR_WEB3_ENTER_WORDS "ckct_ib_find_enter_the_text"
#define TR_WEB3_NOT_FOUND "ckct_ib_find_no_matches"
#define TR_WEB5_BD_SAVE "wdgt_bd_save"
#define TR_WEB5_BD_DONE "wdgt_bd_done"
#define TR_WEB5_BM_DELETE_BTN "wdgt_bd_delete"
#define TR_WEB9_DATE "wdgt_va_date"
#define TR_WEB9_DATE_LONG "wdgt_va_date_long"
#define TR_WEB9_24H_TIME "wdgt_va_24h_time"
#define TR_WEB9_12H_AM_TIME  "wdgt_va_12h_time_am"
#define TR_WEB9_12H_PM_TIME  "wdgt_va_12h_time_pm"

#define TR_EMBED_NOTE_INSTALL_NOTICE  dgettext ("hildon-application-manager", "ai_nc_non_verified_package")
#define TR_EMBED_NOTE_INSTALL_NOTICE2 dgettext ("hildon-application-manager", "ai_nc_unsure_package")
#define TR_EMBED_TITLE_INSTALL_NOTICE dgettext ("hildon-application-manager", "ai_ti_notice")

#define TR_WEB_WDGT_BD_YES "wdgt_bd_yes"
#define TR_WEB_WDGT_BD_NO "wdgt_bd_no"


#define HSU_(String) dgettext ("hildon-status-bar-usb", String)
#define TR_WEB_MMC_USB_CONNECTED "usbh_ib_mmc_usb_connected"

#endif
