#ifndef _PLUGINSUPPORT_H_
#define _PLUGINSUPPORT_H_

#ifdef HAVE_CONFIG_H
#include "config.h" // may define USE_GTK
#endif

// Check that we are using GDK with X11
#ifdef USE_GTK
#include <gdk/gdk.h>
#ifdef GDK_WINDOWING_X11

// This macro will be defined if any of the PluginSupport functions can be used
//#define PLUGIN_SUPPORT_ENABLED 1

#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <prtypes.h>
#include <map>

class nsIDOMWindow;
class nsWindowListener;

/**
 * Class that contains support for panning gestures on top of browser plugins
 * using GDK and X11 to redirect XEvents to and from plugins.
 */
class PluginSupport
{
public:
  /// Default constructor for PluginSupport
  PluginSupport();

public:
  /**
   * Initializes the plugin support using the specified listener
   * window-listener map.
   * @param aListenerContainer Mapping from DOM windows to respective window
   *                           listeners.
   */
  static void Initialize(
      std::map<nsIDOMWindow*, nsWindowListener*>& aListenerContainer);

  /**
   * Removes the plugin support for the specified listener
   * window-listener map.
   * @param aListenerContainer Mapping from DOM windows to respective window
   *                           listeners.
   */
  static void Uninitialize(
      std::map<nsIDOMWindow*, nsWindowListener*>& aListenerContainer);

public:
  /**
   * Window-specific event handler
   * @param aXEvent The native event to filter
   * @return Filtering result
   * @see GdkFilterReturn
   */
  GdkFilterReturn HandleEvent(XEvent& aXEvent, nsWindowListener& aWindowListener);

private:
  /// PR_TRUE if stylus/tap/left mouse button is being pressed
  PRBool mMouseDown;
  /// PR_TRUE if mCachedButtonPressEvent contains a cached ButtonPress event
  PRBool mButtonPressEventCached;
  /// Cached ButtonPress event to be re-sent if ButtonRelease arrives before
  /// we start panning.
  XEvent mCachedButtonPressEvent;
};

#endif // GDK_WINDOWING_X11
#endif // USE_GTK

#endif // _PLUGINSUPPORT_H_
