#ifndef _ISCROLLBARS_H_
#define _ISCROLLBARS_H_

#include "nsISupports.h"
#include "nsCOMPtr.h"
#include "HelperFunctions.h"
#include "nsRect.h"
#include "IbaseMode.h"
#include "nsStringGlue.h"

class nsIDOMEvent;
class nsIWidget;
class nsIViewManager;
class nsIWebProgress;
class nsIDOMElement;
class nsWindowListener;

class iScrollBars : public IBaseMode
{
public:
  iScrollBars(nsWindowListener *aListener);
  ~iScrollBars();

  static nsIWidget* DOMWindowToWidget(nsIDOMWindow *dw);
  nsresult OnStateChange(nsIWebProgress *aWebProgress, PRUint32 aStateFlags);
  nsresult MouseDown(nsIDOMEvent *aDOMEvent);
  nsresult MouseUp(nsIDOMEvent *aDOMEvent);
  nsresult MouseMove(nsIDOMEvent *aDOMEvent);

  NS_DECL_ISUPPORTS

private:
  nsresult Init();
  nsresult CreateScrollIndicators(nsIDOMWindow *dw);
  nsresult AttachScrollIndicators(nsIDOMWindow *dw, PRBool aAttach = PR_TRUE);
  nsresult SetScrollIndicatorsVisibility(nsIDOMWindow *dw, PRBool aVisible);
  nsresult setMarkerPosition(nsIDOMElement *aDOMElement, nsRect &aRect);

  nsWindowListener *mListener;
  PRBool mHideScrollbars;
  PRBool mDoPaintScrollbars;
  PRInt32 mIndicatorWidth;
  nsCOMPtr<nsIDOMElement> mVElement;
  nsCOMPtr<nsIDOMElement> mHElement;
  nsCOMPtr<nsIDOMWindow> mWindow;
  nsString mScrollIndStyle;
};

#endif //_ISCROLLBARS_H_
