#include "hoverMode.h"
#include "nsITouchInteractListener.h"
#include "nsIDOMEvent.h"
#include "nsIWidget.h"
#include "nsIViewManager.h"
#include "hoverToolTip.h"

NS_IMPL_ISUPPORTS1(HoverMode, IBaseMode)

HoverMode::HoverMode() :
  mViewManager(nsnull),
  mMouseDown(PR_FALSE),
  mToolTip(nsnull)
{
  Init();
}

nsresult
HoverMode::Init()
{
  INIT_MOUSE_DISPATCH();
  mToolTip = new HoverToolTip();
  NS_ENSURE_TRUE(mToolTip, NS_ERROR_OUT_OF_MEMORY);
  return NS_OK;
}

HoverMode::~HoverMode()
{
  delete mToolTip;
}

nsresult
HoverMode::OnHover(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  mDOMEvent = do_QueryInterface(aDOMEvent);
  return CALL_MOUSE_DISPATCH(aDOMEvent);
}

nsresult
HoverMode::MouseDown(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  mMouseDown = PR_TRUE;
  HelperFunctions::RemoveSelection(aDOMEvent);
  HelperFunctions::CloseSelection(aDOMEvent);
  aDOMEvent->StopPropagation();
  aDOMEvent->PreventDefault();

  GET_STATIC_INTERACTLISTENER(sListener);
  if (!sListener) return NS_OK;

  nsCOMPtr<nsIWidget> widget;
  HelperFunctions::GetWidgetFromEvent(aDOMEvent, getter_AddRefs(widget));
  return sListener->OnMouseDownHover(aDOMEvent, widget);
}

nsresult
HoverMode::MouseMove(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(mMouseDown, NS_OK);
  mToolTip->ShowToolTip(aDOMEvent);

  GET_STATIC_INTERACTLISTENER(sListener);
  if (!sListener) return NS_OK;

  nsCOMPtr<nsIViewManager> tmpViewManager;
  HelperFunctions::GetViewManagerFromEvent(aDOMEvent, getter_AddRefs(tmpViewManager));
  NS_IF_ADDREF(mViewManager = tmpViewManager);
  NS_ENSURE_TRUE(mViewManager, NS_ERROR_FAILURE);

  HelperFunctions::EdgeAutoScroll(aDOMEvent, mViewManager);
  nsCOMPtr<nsIWidget> widget;
  HelperFunctions::GetWidgetFromEvent(aDOMEvent, getter_AddRefs(widget));
  return sListener->OnMouseMoveHover(aDOMEvent, widget);
}

nsresult
HoverMode::MouseUp(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  mMouseDown = PR_FALSE;
  if(mToolTip)
    mToolTip->HideToolTip();
  HelperFunctions::StopAutoScroll();
  GET_STATIC_INTERACTLISTENER(sListener);
  if (!sListener) return NS_OK;

  nsCOMPtr<nsIWidget> widget;
  HelperFunctions::GetWidgetFromEvent(aDOMEvent, getter_AddRefs(widget));
  return sListener->OnMouseUpHover(aDOMEvent, widget);
}

nsresult
HoverMode::MouseOver(nsIDOMEvent *aDOMEvent)
{
//  NS_ENSURE_TRUE(aDOMEvent, NS_OK);
//  aDOMEvent->StopPropagation();
//  aDOMEvent->PreventDefault();
//  NS_ENSURE_TRUE(mMouseDown, NS_OK);
//  NS_ENSURE_TRUE(mToolTip, NS_OK);
//  return mToolTip->ShowToolTip(aDOMEvent);
  return NS_OK;
}

nsresult
HoverMode::MouseOut(nsIDOMEvent *aDOMEvent)
{
//  NS_ENSURE_TRUE(aDOMEvent, NS_OK);
//  aDOMEvent->StopPropagation();
//  aDOMEvent->PreventDefault();
//  NS_ENSURE_TRUE(mMouseDown, NS_OK);
//  NS_ENSURE_TRUE(mToolTip, NS_OK);
//  return mToolTip->HideToolTip();
   return NS_OK;
}
