#ifndef _MONOMODE_H_
#define _MONOMODE_H_

#include "nsISupports.h"
#include "nsCOMPtr.h"
#include "HelperFunctions.h"
#include "IbaseMode.h"

class nsIDOMEvent;
class nsIWidget;
class nsIViewManager;
class nsITimer;
class SpeedManager;
class nsIDOMNSHTMLElement;

class MonoMode : public IBaseMode
{
public:
  MonoMode();
  ~MonoMode();

  nsresult OnMono(nsIDOMEvent *aDOMEvent);
  PRBool SetMouseDown(PRBool aMouseDown);
  PRBool CanShowCxtMenu();
  nsIDOMEvent* GetDOMEvent();
  nsresult ModifierActionEvent(PRInt32 aModifier);

  NS_DECL_ISUPPORTS

  float GetZoomLevel(void) { return mMouseDownZoomLevel; };
private:
  nsresult Init();

  nsresult MouseDown(nsIDOMEvent *aDOMEvent);
  nsresult MouseMove(nsIDOMEvent *aDOMEvent);
  nsresult MouseUp(nsIDOMEvent *aDOMEvent);
  nsresult MouseClick(nsIDOMEvent *aDOMEvent);

  nsresult DoPan(nsIDOMEvent *aDOMEvent, nsIViewManager* aViewManager,
                 PRInt32 aDx, PRInt32 aDy);
  nsresult EndPan(PRBool aDelay = PR_FALSE);
  SpeedManager* GetSpeedMngX();
  SpeedManager* GetSpeedMngY();
  PRInt32 GetKineticPanStep();

  nsresult ChangeFocus(nsIDOMEvent *aDOMEvent);

  //timer callback
  static void DoKineticPan(nsITimer *timer, void *closure);
  static void EndPanDelayCallBack(nsITimer *timer, void *closure);
  static void DispatchMouseEvent(nsITimer *timer, void *closure);

  //timer
  nsCOMPtr<nsITimer> mPanningTimer;
  nsCOMPtr<nsITimer> mEndPanTimer;

  nsCOMPtr<nsIDOMEvent> mDOMEvent;
  nsIViewManager *mViewManager;
  PRBool mMouseDown;
  PRBool mIsDblClick;
  PRBool mKineticEn;
  nsCOMPtr<nsITimer> mRedispatchTimer;
  SpeedManager *mSpeedX;
  SpeedManager *mSpeedY;
  PRInt32 mKineticPanStep;

  //mouse
  MouseEventArg mFirstMousedownEvent;
  MouseEventArg mLastMouseEvent;
  MouseEventArg mCurrentMouseEvent;
  static PRUint32 sIsPanning;
  nsCOMPtr<nsIDOMNSHTMLElement> mFocusElement;
  DECLARE_MOUSE_DISPATCH(MonoMode);
  float mMaxPressure;
  PRBool mHasDispatchEvent;
  float mMouseDownZoomLevel;
};

#endif //_MONOMODE_H_
