#include "HelperFunctions.h"
#include "nsIDOMEvent.h"
#include "nsIDOMEventTarget.h"
#include "nsIDOMMouseEvent.h"
#include "nsIWidget.h"
#include "nsIViewManager.h"
#include "nsISelectionController.h"
#include "nsIDOMNode.h"
#include "nsIDOMWindow.h"
#include "nsIURI.h"
#include "nsStringGlue.h"
#include "nsIDOMHTMLInputElement.h"
#include "nsIDOMHTMLTextAreaElement.h"
#include "nsIDOMHTMLAnchorElement.h"
#include "nsIDOMHTMLSelectElement.h"
#include "nsIDOMHTMLOptionElement.h"
#include "nsITouchInteractListener.h"
#include "nsServiceManagerUtils.h"
#include "nsIDOMNSEvent.h"
#include "nsIDocument.h"
#include "nsIDOMDocument.h"
#include "nsIPresShell.h"
#include "nsIDOMDocumentView.h"
#include "nsIDOMAbstractView.h"
#include "nsITimer.h"
#include "nsComponentManagerUtils.h"
#include "IbaseMode.h"
#include "nsIDOMWindowInternal.h"
#include "nsIScrollableView.h"
#include "nsIDOMNSHTMLButtonElement.h"
#include "nsIDOMNSHTMLElement.h"
#include "nsIWebNavigation.h"
#include "nsIDOM3Document.h"
#include "nsIMarkupDocumentViewer.h"
#include "nsPIDOMWindow.h"
#include "nsIDocShell.h"
#include "nsIPrefService.h"
#include "nsIContentViewer.h"
#include "nsIInterfaceRequestorUtils.h"
//#include "nsIDOMMouseWithPressureEvent.h"
#include "nsIContent.h"
#include "nsGkAtoms.h"
#include "nsIDOMNSHTMLDocument.h"
#include <config.h>
#ifdef USE_GTK
#include <gdk/gdk.h>
#endif

nsITimer* HelperFunctions::sLongPressTimer;
nsITimer* HelperFunctions::sAutoScrollTimer;
PRInt32 HelperFunctions::sAutoDx;
PRInt32 HelperFunctions::sAutoDy;

//static
PRBool
HelperFunctions::IsHTMLInputElement(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, PR_FALSE);
  nsCOMPtr<nsIDOMHTMLInputElement> inputElement = do_QueryInterface(eventTarget);

  return !!inputElement;
}

//static
PRBool
HelperFunctions::IsHTMLTextAreaElement(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, PR_FALSE);
  nsCOMPtr<nsIDOMHTMLTextAreaElement> textAreaElement = do_QueryInterface(eventTarget);

  return !!textAreaElement;
}

//static
PRBool
HelperFunctions::IsHTMLAnchorElement(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, PR_FALSE);
  nsCOMPtr<nsIDOMHTMLAnchorElement> anchorElement = do_QueryInterface(eventTarget);

  return !!anchorElement;
 }

//static
PRBool
HelperFunctions::IsHTMLSelectElement(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, PR_FALSE);
  nsCOMPtr<nsIDOMHTMLSelectElement> selectElement = do_QueryInterface(eventTarget);

  return !!selectElement;
}

//static
PRBool
HelperFunctions::IsHTMLOptionElement(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, PR_FALSE);
  nsCOMPtr<nsIDOMHTMLOptionElement> OptionElement = do_QueryInterface(eventTarget);

  return !!OptionElement;
}

//static
PRBool
HelperFunctions::IsNSHTMLButtonElement(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, PR_FALSE);
  nsCOMPtr<nsIDOMNSHTMLButtonElement> buttonElement = do_QueryInterface(eventTarget);

  return !!buttonElement;
}

//static
PRBool
HelperFunctions::IsNSHTMLElement(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, PR_FALSE);
  nsCOMPtr<nsIDOMNSHTMLElement> htmlElement = do_QueryInterface(eventTarget);

  return !!htmlElement;
}

//static
PRBool
HelperFunctions::InActiveRegion(nsIDOMEvent *aDOMEvent)
{
  nsCOMPtr<nsIDOMWindow> tmpDOMWindow;
  HelperFunctions::GetDOMWindowFromEvent(aDOMEvent, getter_AddRefs(tmpDOMWindow));
  NS_ENSURE_TRUE(tmpDOMWindow, PR_FALSE);
  nsCOMPtr<nsIDOMWindow> topDOMWindow;
  tmpDOMWindow->GetTop(getter_AddRefs(topDOMWindow));
  NS_ENSURE_TRUE(topDOMWindow, PR_FALSE);
  nsCOMPtr<nsIDOMWindowInternal> windowInternal = do_QueryInterface(topDOMWindow);
  NS_ENSURE_TRUE(windowInternal, PR_FALSE);
  PRInt32 windowScreenX;
  windowInternal->GetScreenX(&windowScreenX);
  nsCOMPtr<nsIDOMMouseEvent> mouseEvent = do_QueryInterface(aDOMEvent);
  NS_ENSURE_TRUE(mouseEvent, PR_FALSE);
  PRInt32 mouseScreenX;
  mouseEvent->GetScreenX(&mouseScreenX);
  if(mouseScreenX - windowScreenX > -1 && mouseScreenX - windowScreenX < 15)
    return PR_TRUE;
  else
    return PR_FALSE;
}

//static
nsresult
HelperFunctions::GetWidgetFromEvent(nsIDOMEvent *aDOMEvent, nsIWidget **aWidget)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWidget, NS_ERROR_FAILURE);
  return UpdateFromEvent(aDOMEvent, aWidget, nsnull, nsnull, nsnull);
}

//static
nsresult
HelperFunctions::GetViewManagerFromEvent(nsIDOMEvent *aDOMEvent,
                                         nsIViewManager **aViewManager)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aViewManager, NS_ERROR_FAILURE);
  return UpdateFromEvent(aDOMEvent, nsnull, aViewManager, nsnull, nsnull);
}

//static
nsresult
HelperFunctions::GetSelectionControllerFromEvent(nsIDOMEvent *aDOMEvent,
                                                 nsISelectionController **aSelect)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aSelect, NS_ERROR_FAILURE);
  return UpdateFromEvent(aDOMEvent, nsnull, nsnull, aSelect, nsnull);
}

//static
nsresult
HelperFunctions::GetDOMWindowFromEvent(nsIDOMEvent *aDOMEvent,
                                       nsIDOMWindow **aDOMWindow)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aDOMWindow, NS_ERROR_FAILURE);
  return UpdateFromEvent(aDOMEvent, nsnull, nsnull, nsnull, aDOMWindow);
}

//static
nsresult
HelperFunctions::GetWebNavigationwFromEvent(nsIDOMEvent *aDOMEvent,
                                            nsIWebNavigation **aWebNav)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aWebNav, NS_ERROR_FAILURE);

  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget , NS_ERROR_FAILURE);
  nsCOMPtr<nsIDOMNode> eventNode = do_QueryInterface(eventTarget);
  NS_ENSURE_TRUE(eventNode , NS_ERROR_FAILURE);
  nsCOMPtr<nsIDOMDocument> domDoc;
  eventNode->GetOwnerDocument(getter_AddRefs(domDoc));
  NS_ENSURE_TRUE(domDoc , NS_ERROR_FAILURE);
  nsCOMPtr<nsIDOMDocumentView> docView(do_QueryInterface(domDoc));
  NS_ENSURE_TRUE(docView, NS_ERROR_FAILURE);
  nsCOMPtr<nsIDOMAbstractView> abstractView;
  docView->GetDefaultView(getter_AddRefs(abstractView));
  NS_ENSURE_TRUE(abstractView, NS_ERROR_FAILURE);
  nsresult rv;
  nsCOMPtr<nsIWebNavigation> webNav(do_GetInterface(abstractView, &rv));
  NS_ENSURE_SUCCESS (rv, rv);
  NS_ADDREF(*aWebNav = webNav);
  return NS_OK;
}

//static
PRBool
HelperFunctions::UpdateMouseEventArg(nsIDOMEvent *aDOMEvent,
                                     MouseEventArg *aMouseEventArg)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  NS_ENSURE_TRUE(aMouseEventArg, PR_FALSE);
  nsCOMPtr<nsIDOMMouseEvent> currentMouseEvent = do_QueryInterface(aDOMEvent);
  NS_ENSURE_TRUE(currentMouseEvent, PR_FALSE);

  currentMouseEvent->GetTimeStamp(&aMouseEventArg->timeStamp);
  currentMouseEvent->GetScreenX(&aMouseEventArg->screenX);
  currentMouseEvent->GetScreenY(&aMouseEventArg->screenY);
  currentMouseEvent->GetClientX(&aMouseEventArg->clientX);
  currentMouseEvent->GetClientY(&aMouseEventArg->clientY);
  aMouseEventArg->eventType = GetMouseEventType(aDOMEvent);
  aMouseEventArg->pressure = 0.4;
//  nsCOMPtr <nsIDOMMouseWithPressureEvent> pev = do_QueryInterface(aDOMEvent);
//  if (pev)
//    pev->GetPressure(&aMouseEventArg->pressure);

  return PR_TRUE;
}

//static
PRBool
HelperFunctions::IsWrongEventSequence(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  static MouseEventArg lastEvent;
  if(lastEvent.timeStamp == 0 || lastEvent.eventType != MOUSE_UP) {
    UpdateMouseEventArg(aDOMEvent, &lastEvent);
    return PR_FALSE;
  }
  MouseEventArg currentEvent;
  memset((void*)&currentEvent, 0, sizeof(currentEvent));
  UpdateMouseEventArg(aDOMEvent, &currentEvent);
  currentEvent.timeStamp = lastEvent.timeStamp + 1;
  PRBool rv = PR_FALSE;
  if(lastEvent.timeStamp >= currentEvent.timeStamp &&
          currentEvent.eventType == MOUSE_DOWN)
    rv = PR_TRUE;

  memcpy((void*)&lastEvent, (void*)&currentEvent, sizeof(MouseEventArg));
  return rv;
}

//static
PRBool
HelperFunctions::IsMouseJittering(MouseEventArg *aCurrent,
                                  MouseEventArg *aLast,
                                  PRInt32 *aTime,
                                  PRInt32 *aX,
                                  PRInt32 *aY,
                                  float aPressure)
{
  NS_ENSURE_TRUE(aCurrent, PR_FALSE);
  NS_ENSURE_TRUE(aLast, PR_FALSE);
  PRBool result = PR_FALSE;
  DOMTimeStamp currentTime = aCurrent->timeStamp;
  DOMTimeStamp lastTime = aLast->timeStamp;
  PRInt32 currentX = aCurrent->screenX;
  PRInt32 currentY = aCurrent->screenY;
  PRInt32 lastX = aLast->screenX;
  PRInt32 lastY = aLast->screenY;

  PRInt32 delta = currentTime - lastTime;
  PRInt32 dx = currentX - lastX;
  PRInt32 dy = currentY - lastY;

  if (aTime)
    *aTime = delta;
  if (aX)
    *aX = dx;
  if (aY)
    *aY = dy;

  // To reduce jitters, return if the mousemove was a small delta
  int finger_jitter = JITTER_DISTANCE;
  if (aPressure > 0)
    finger_jitter += 40.0 * aPressure;

  if (JITTER_TIME > delta ||
      (finger_jitter > PR_ABS(dx) && finger_jitter > PR_ABS(dy)))
    return PR_TRUE;
  else
    return PR_FALSE;
}

//static
PRBool
HelperFunctions::IsDblClick(MouseEventArg *aCurrent, MouseEventArg *aLast)
{
  NS_ENSURE_TRUE(aCurrent, PR_FALSE);
  NS_ENSURE_TRUE(aLast, PR_FALSE);
  DOMTimeStamp lastMousedownTime = aLast->timeStamp;
  DOMTimeStamp currentMousedownTime = aCurrent->timeStamp;

  PRInt32 lastMousedownX = aLast->screenX;
  PRInt32 lastMousedownY = aLast->screenY;
  PRInt32 currentMousedownX = aCurrent->screenX;
  PRInt32 currentMousedownY = aCurrent->screenY;

  if (currentMousedownTime - lastMousedownTime < 400 &&
          PR_ABS(lastMousedownX - currentMousedownX) < 30 &&
          PR_ABS(lastMousedownY - currentMousedownY) < 30)
    return PR_TRUE;
  else
    return PR_FALSE;
}

//static
nsresult
HelperFunctions::DumpMousePosition(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  nsCOMPtr<nsIDOMMouseEvent> mouseEvent = do_QueryInterface(aDOMEvent);
  NS_ENSURE_TRUE(mouseEvent, NS_ERROR_FAILURE);

  DOMTimeStamp timestamp;
  mouseEvent->GetTimeStamp(&timestamp) ;

  PRInt32 screenX, screenY, clientX, clientY;
  mouseEvent->GetScreenX(&screenX);
  mouseEvent->GetScreenY(&screenY);
  mouseEvent->GetClientX(&clientX);
  mouseEvent->GetClientY(&clientY);

  printf("Time %ul\n", timestamp);
  printf("ScreenX %d\n", screenX);
  printf("ScreenY %d\n", screenY);
  printf("ClientX %d\n", clientX);
  printf("ClientY %d\n", clientY);

  return NS_OK;
}

//static
void
HelperFunctions::DumpShouldLoad(PRUint32 aContentType,
                                nsIURI *aContentLocation,
                                nsIURI *aRequestingLocation,
                                nsISupports *aRequestingContext,
                                const nsACString &aMimeGuess)
{
  printf("aContentType = %d\n", aContentType);

  nsCAutoString path;
  const char *kStr;
  if (aContentLocation) {
    aContentLocation->GetPrePath(path);
    NS_CStringGetData(path, &kStr);
    printf("aContentLocation PrePath = %s\n", kStr);
    aContentLocation->GetPath(path);
    NS_CStringGetData(path, &kStr);
    printf("aContentLocation Path %s\n", kStr);
  }

  if (aRequestingLocation) {
    aRequestingLocation->GetPrePath(path);
    NS_CStringGetData(path, &kStr);
    printf("aRequestingLocation PrePath = %s\n", kStr);
    aRequestingLocation->GetPath(path);
    NS_CStringGetData(path, &kStr);
    printf("aRequestingLocation Path = %s\n", kStr);
  }

  NS_CStringGetData(aMimeGuess, &kStr);
  printf("aMimeGuess = %s\n", kStr);
}

//static
nsresult
HelperFunctions::GetTouchInteractListener(nsITouchInteractListener **aListener)
{
  NS_ENSURE_TRUE(aListener, NS_ERROR_FAILURE);
  nsresult rv = NS_ERROR_FAILURE;
  nsCOMPtr<nsITouchInteractListener> listener =
    do_GetService("@browser.garage.maemo.org/microb/touchinteractlistener;1", &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  NS_IF_ADDREF(*aListener = listener);
  return rv;
}

//static
nsresult
HelperFunctions::OpenSelection(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  nsCOMPtr<nsISelectionController> curSelCon;
  HelperFunctions::GetSelectionControllerFromEvent(aDOMEvent, getter_AddRefs(curSelCon));

  NS_ENSURE_TRUE(curSelCon, NS_ERROR_FAILURE);
  return curSelCon->SetDisplaySelection(nsISelectionController::SELECTION_ON);
}

//static
nsresult
HelperFunctions::CloseSelection(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  nsCOMPtr<nsISelectionController> curSelCon;
  HelperFunctions::GetSelectionControllerFromEvent(aDOMEvent, getter_AddRefs(curSelCon));

  NS_ENSURE_TRUE(curSelCon, NS_ERROR_FAILURE);
  return curSelCon->SetDisplaySelection(nsISelectionController::SELECTION_OFF);
}

nsresult
HelperFunctions::IsSelectionAvailable(nsIDOMEvent *aDOMEvent, nsAString &aString)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  nsCOMPtr<nsIDOMWindow> win;
  HelperFunctions::GetDOMWindowFromEvent(aDOMEvent, getter_AddRefs(win));
  NS_ENSURE_TRUE(win, NS_OK);
  nsCOMPtr<nsIDOMNSHTMLDocument> doc;
  nsCOMPtr<nsIDOMDocument> domDoc;
  win->GetDocument(getter_AddRefs(domDoc));
  NS_ENSURE_TRUE(domDoc, NS_OK);
  doc = do_QueryInterface(domDoc);
  NS_ENSURE_TRUE(doc, NS_OK);
  doc->GetSelection(aString);
  if (aString.IsEmpty())
    return NS_ERROR_FAILURE;
  return NS_OK;
}

//static
nsresult
HelperFunctions::RemoveSelection(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  nsCOMPtr<nsISelectionController> curSelCon;
  HelperFunctions::GetSelectionControllerFromEvent(aDOMEvent, getter_AddRefs(curSelCon));
  NS_ENSURE_TRUE(curSelCon, NS_ERROR_FAILURE);

  curSelCon->SetDisplaySelection(nsISelectionController::SELECTION_ON);
  nsCOMPtr<nsISelection> domSel;
  curSelCon->GetSelection(nsISelectionController::SELECTION_NORMAL, getter_AddRefs(domSel));
  NS_ENSURE_TRUE(domSel, NS_ERROR_FAILURE);
  return domSel->RemoveAllRanges();
}

//static
PRInt32
HelperFunctions::GetMouseEventType(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, EVENT_TYPE_UNSUPPORTED);
  nsresult rv;
  nsString eventType;
  rv = aDOMEvent->GetType(eventType);
  NS_ENSURE_SUCCESS(rv, EVENT_TYPE_UNSUPPORTED);

  if (eventType.EqualsLiteral("mousedown"))
    return MOUSE_DOWN;
  else if (eventType.EqualsLiteral("mouseup"))
    return MOUSE_UP;
  else if (eventType.EqualsLiteral("mousemove"))
    return MOUSE_MOVE;
  else if (eventType.EqualsLiteral("mouseover"))
      return MOUSE_OVER;
  else if (eventType.EqualsLiteral("mouseout"))
      return MOUSE_OUT;
  else if (eventType.EqualsLiteral("click"))
    return MOUSE_CLICK;
  else
    return EVENT_TYPE_UNSUPPORTED;
}

//static
nsresult
HelperFunctions::GetMarkupViewerByWindow(nsIDOMWindow *aDOMWindow,
                                         nsIMarkupDocumentViewer * *aMarkupDocViewver)
{
  nsresult rv;
  NS_ENSURE_ARG_POINTER(aMarkupDocViewver);
  nsCOMPtr<nsPIDOMWindow> window(do_QueryInterface(aDOMWindow, &rv));
  NS_ENSURE_SUCCESS(rv, rv);
  nsIDocShell *docShell = nsnull;
  if (window)
    docShell = window->GetDocShell();
  NS_ENSURE_TRUE(docShell, NS_ERROR_FAILURE);
  nsCOMPtr<nsIContentViewer> contentViewer;
  rv = docShell->GetContentViewer(getter_AddRefs(contentViewer));
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIMarkupDocumentViewer> markupViewer(do_QueryInterface(contentViewer, &rv));
  NS_ENSURE_TRUE(markupViewer, NS_ERROR_FAILURE);
  *aMarkupDocViewver = markupViewer;
  NS_IF_ADDREF(*aMarkupDocViewver);
  return rv;
}

//static
PRInt32
HelperFunctions::GetZoomLevel(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, 0);
  float zoomLevelFloat = 100;
  nsCOMPtr<nsIDOMWindow> DOMWindow;
  GetDOMWindowFromEvent(aDOMEvent,getter_AddRefs(DOMWindow));
  NS_ENSURE_TRUE(DOMWindow, 0);
  nsCOMPtr<nsIMarkupDocumentViewer> markupViewer;
  nsresult rv = GetMarkupViewerByWindow(DOMWindow, getter_AddRefs(markupViewer));
  NS_ENSURE_SUCCESS(rv, 0);

  PRBool bval = PR_FALSE;
  if (NS_SUCCEEDED(GetPref (PREF_TYPE_BOOL,"gtkmozembed.textzoom", &bval)) && bval)
    rv = markupViewer->GetTextZoom(&zoomLevelFloat);
  else
    rv = markupViewer->GetFullZoom(&zoomLevelFloat);

  NS_ENSURE_SUCCESS(rv, 0);

  return (PRInt32)round(zoomLevelFloat * 100.);
}

//static
nsresult
HelperFunctions::SetCursor(nsIDOMEvent *aDOMEvent, nsCursor aCursor)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  nsCOMPtr<nsIWidget> widget;
  GetWidgetFromEvent(aDOMEvent, getter_AddRefs(widget));
  NS_ENSURE_TRUE(widget, NS_ERROR_FAILURE);
  return widget->SetCursor(aCursor);
}

//static
nsresult
HelperFunctions::StartShowCxtMenu(IBaseMode *aBaseMode)
{
  NS_ENSURE_TRUE(aBaseMode, NS_ERROR_FAILURE);
  if (!sLongPressTimer) {
    nsresult rv;
    nsCOMPtr<nsITimer> timer = do_CreateInstance(NS_TIMER_CONTRACTID, &rv);
    NS_ENSURE_SUCCESS(rv, rv);
    NS_ENSURE_TRUE(timer, NS_ERROR_FAILURE);
    NS_IF_ADDREF(sLongPressTimer = timer);
  }

  NS_ENSURE_TRUE(sLongPressTimer, NS_ERROR_FAILURE);
  sLongPressTimer->Cancel();
  return sLongPressTimer->InitWithFuncCallback(HelperFunctions::LongPressCallback,
                                               (void*)aBaseMode,
                                               1000,
                                               nsITimer::TYPE_ONE_SHOT);
 }

//static
nsresult
HelperFunctions::CancelShowCxtMenu()
{
  NS_ENSURE_TRUE(sLongPressTimer, NS_ERROR_FAILURE);
  sLongPressTimer->Cancel();
  return NS_OK;
}

//static
nsresult
HelperFunctions::EdgeAutoScroll(nsIDOMEvent *aDOMEvent,
                                nsIViewManager *aViewManager)
{
  if (!sAutoScrollTimer) {
    nsresult rv;
    nsCOMPtr<nsITimer> timer = do_CreateInstance(NS_TIMER_CONTRACTID, &rv);
    NS_ENSURE_SUCCESS(rv, rv);
    NS_IF_ADDREF(sAutoScrollTimer = timer);
    NS_ENSURE_TRUE(sAutoScrollTimer, NS_OK);
  } else
    sAutoScrollTimer->Cancel();

  NS_ENSURE_TRUE(aDOMEvent, NS_OK);
  NS_ENSURE_TRUE(aViewManager, NS_OK);

  PRBool autoScroll = ShouldAutoScroll(aDOMEvent, &sAutoDx, &sAutoDy);
  NS_ENSURE_TRUE(autoScroll, NS_OK);
  ScrollWindow(aDOMEvent, aViewManager, sAutoDx/2, sAutoDy/2);
  return sAutoScrollTimer->InitWithFuncCallback(HelperFunctions::AutoScrollCallback,
                                                (void*)aViewManager,
                                                100,
                                                nsITimer::TYPE_ONE_SHOT);
}

//static
nsresult
HelperFunctions::StopAutoScroll()
{
  NS_ENSURE_TRUE(sAutoScrollTimer, NS_OK);
  sAutoScrollTimer->Cancel();
  return NS_OK;
}

//static
nsresult
HelperFunctions::ScrollWindow(nsIDOMEvent *aDOMEvent,
                              nsIViewManager *aViewManager,
                              PRInt32 aDx,
                              PRInt32 aDy)
{
  NS_ENSURE_TRUE(aViewManager, NS_ERROR_FAILURE);

  nsIScrollableView *scrollableView = nsnull;
  aViewManager->GetRootScrollableView(&scrollableView);
  NS_ENSURE_TRUE(scrollableView, NS_ERROR_FAILURE);

  do { // find a really scrollable view
    NS_ENSURE_TRUE(scrollableView, NS_ERROR_FAILURE);
    PRBool up, down, left, right; // this is mouse direction
    scrollableView->CanScroll(PR_FALSE, PR_TRUE, up); // == aDy > 0
    scrollableView->CanScroll(PR_FALSE, PR_FALSE, down); // == aDy < 0
    scrollableView->CanScroll(PR_TRUE, PR_TRUE, left); // == aDx > 0
    scrollableView->CanScroll(PR_TRUE, PR_FALSE, right); // == aDx < 0
    if (up || down || left || right)
      break;
    else {
      nsIView *view = scrollableView->View();
      do {
        NS_ENSURE_TRUE(view, NS_ERROR_FAILURE);
        view = view->GetParent();
        NS_ENSURE_TRUE(view, NS_ERROR_FAILURE);
        scrollableView = view->ToScrollableView();
      } while (!scrollableView);
      }
  } while (scrollableView);

  NS_ENSURE_TRUE(scrollableView, NS_ERROR_FAILURE);

  PRInt32 overflowX = 0, overflowY = 0;
  return scrollableView->ScrollByPixels(aDx, aDy, overflowX, overflowY);
}

//static
PRBool
HelperFunctions::CanScrollVertical(nsIViewManager *aViewManager)
{
  NS_ENSURE_TRUE(aViewManager, PR_FALSE);
  nsIScrollableView *scrollableView = nsnull;
  aViewManager->GetRootScrollableView(&scrollableView);
  NS_ENSURE_TRUE(scrollableView, PR_FALSE);

  do { // find a really scrollable view
    NS_ENSURE_TRUE(scrollableView, PR_FALSE);
    PRBool up, down; // this is mouse direction
    scrollableView->CanScroll(PR_FALSE, PR_TRUE, up); // == aDy > 0
    scrollableView->CanScroll(PR_FALSE, PR_FALSE, down); // == aDy < 0
    if (up || down)
      return PR_TRUE;
    else {
      nsIView *view = scrollableView->View();
      do {
        NS_ENSURE_TRUE(view, PR_FALSE);
        view = view->GetParent();
        NS_ENSURE_TRUE(view, PR_FALSE);
        scrollableView = view->ToScrollableView();
      } while (!scrollableView);
    }
  } while (scrollableView);

  return PR_FALSE;
}

//static
PRBool
HelperFunctions::CanScrollHorizontal(nsIViewManager *aViewManager)
{
  NS_ENSURE_TRUE(aViewManager, PR_FALSE);
  nsIScrollableView *scrollableView = nsnull;
  aViewManager->GetRootScrollableView(&scrollableView);
  NS_ENSURE_TRUE(scrollableView, PR_FALSE);

  do { // find a really scrollable view
    NS_ENSURE_TRUE(scrollableView, PR_FALSE);
    PRBool left, right; // this is mouse direction
    scrollableView->CanScroll(PR_TRUE, PR_TRUE, left); // == aDx > 0
    scrollableView->CanScroll(PR_TRUE, PR_FALSE, right); // == aDx < 0
    if (left || right)
      return PR_TRUE;
    else {
      nsIView *view = scrollableView->View();
      do {
        NS_ENSURE_TRUE(view, PR_FALSE);
        view = view->GetParent();
        NS_ENSURE_TRUE(view, PR_FALSE);
        scrollableView = view->ToScrollableView();
      } while (!scrollableView);
    }
  } while (scrollableView);

  return PR_FALSE;
}

//private static
void
HelperFunctions::LongPressCallback(nsITimer *timer, void *closure)
{
  NS_ENSURE_TRUE(timer, );
  NS_ENSURE_TRUE(closure, );
  IBaseMode *self = (IBaseMode*)closure;
  NS_ENSURE_TRUE(self, );
  if (!self->CanShowCxtMenu())
    return;

  GET_STATIC_INTERACTLISTENER(sListener);

  if (!self->CanShowCxtMenu())
    return;

  PRBool modifier = PR_FALSE;
  nsIDOMEvent *event = self->GetDOMEvent();
  nsCOMPtr<nsIDOMMouseEvent> ev = do_QueryInterface(event);
  if (ev)
    ev->GetShiftKey(&modifier);
  if (modifier) {
    self->ModifierActionEvent(modifier);
  } else
  if (event) {
    if (sListener) {
      nsCOMPtr<nsIWidget> widget;
      GetWidgetFromEvent(event, getter_AddRefs(widget));
      sListener->OnMouseLongPress(event, widget);
    } else {
      nsCOMPtr<nsIObserver> ecObserver = do_GetService("@browser/engine-client-observer;1");
      if (ecObserver)
        ecObserver->Observe((nsISupports*)event, "widgetutils:longpress", nsnull);
    }
  }

  self->SetMouseDown(PR_FALSE);
}

//private static
void
HelperFunctions::AutoScrollCallback(nsITimer *timer, void *closure)
{
  NS_ENSURE_TRUE(timer, );
  NS_ENSURE_TRUE(closure, );
  nsIViewManager *viewManager = (nsIViewManager*)closure;
  NS_ENSURE_TRUE(viewManager, );
  ScrollWindow(nsnull, viewManager, sAutoDx/2, sAutoDy/2);
  timer->InitWithFuncCallback(HelperFunctions::AutoScrollCallback,
                              (void*)closure,
                              100,
                              nsITimer::TYPE_ONE_SHOT);
}

//private static
PRBool
HelperFunctions::ShouldAutoScroll(nsIDOMEvent *aDOMEvent,
                                  PRInt32 *aDx,
                                  PRInt32 *aDy)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  const PRInt32 kEdgeThreshold = 40;
  MouseEventArg mouseArg;
  memset((void*)&mouseArg, 0, sizeof(mouseArg));
  UpdateMouseEventArg(aDOMEvent, &mouseArg);

  nsCOMPtr<nsIDOMWindow> domWindow;
  GetDOMWindowFromEvent(aDOMEvent, getter_AddRefs(domWindow));
  NS_ENSURE_TRUE(domWindow, PR_FALSE);
  nsCOMPtr<nsIDOMWindowInternal> internal = do_QueryInterface(domWindow);
  NS_ENSURE_TRUE(internal, PR_FALSE);

  PRInt32 outerWidth, outerHeight, zoom, screenX, screenY;
  internal->GetOuterWidth(&outerWidth);
  internal->GetOuterHeight(&outerHeight);
  internal->GetScreenX(&screenX);
  internal->GetScreenY(&screenY);
  zoom = GetZoomLevel(aDOMEvent);

  outerWidth = outerWidth * zoom / 100 + screenX;
  outerHeight = outerHeight * zoom / 100 + screenY;

  PRInt32 dx = 0;
  PRInt32 dy = 0;
  if (mouseArg.screenX < kEdgeThreshold + screenX)
    dx = -kEdgeThreshold;
  if (mouseArg.screenY < kEdgeThreshold + screenY)
    dy = -kEdgeThreshold;
  if (mouseArg.screenX > outerWidth - kEdgeThreshold)
    dx = kEdgeThreshold;
  if (mouseArg.screenY > outerHeight - kEdgeThreshold)
    dy = kEdgeThreshold;
  if(aDx)
    *aDx = dx;
  if(aDy)
    *aDy = dy;
  if (dx == 0 && dy == 0)
    return PR_FALSE;
  else
    return PR_TRUE;
}

//private static
nsresult
HelperFunctions::UpdateFromEvent(nsIDOMEvent *aDOMEvent,
                                 nsIWidget **aWidget,
                                 nsIViewManager **aViewManager,
                                 nsISelectionController **aSelect,
                                 nsIDOMWindow **aDOMWindow)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_OK);
  nsCOMPtr<nsIDOMMouseEvent> mouseEvent = do_QueryInterface(aDOMEvent);
  NS_ENSURE_TRUE(mouseEvent, NS_OK);

  nsCOMPtr<nsIDOMWindow> mWindow;
  nsCOMPtr<nsIDOMNode> mNode;
  nsCOMPtr<nsIDOMNode> mOrigNode;
  nsCOMPtr<nsIWidget> mWidget;
  nsCOMPtr<nsIViewManager> mViewManager;
  nsCOMPtr<nsISelectionController> mCurSelCon;

//  NS_ENSURE_FALSE(IsXULNode(aDOMEvent), NS_ERROR_FAILURE);

  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  if (eventTarget)
    mNode = do_QueryInterface(eventTarget);
  NS_ENSURE_TRUE(mNode, NS_OK);

  GetDOMWindowByNode(mNode, getter_AddRefs(mWindow));
  NS_ENSURE_TRUE(mWindow, NS_OK);

  nsCOMPtr<nsIDocument> doc;
  nsCOMPtr<nsIDOMDocument> domDoc;
  mWindow->GetDocument(getter_AddRefs(domDoc));
  NS_ENSURE_TRUE(domDoc, NS_OK);
  doc = do_QueryInterface(domDoc);
  NS_ENSURE_TRUE(doc, NS_OK);
  // the only case where there could be more shells in printpreview
  nsIPresShell *shell = doc->GetPrimaryShell();
  NS_ENSURE_TRUE(shell, NS_ERROR_FAILURE);

  mViewManager = shell->GetViewManager();
  NS_ENSURE_TRUE(mViewManager, NS_ERROR_FAILURE);
  mViewManager->GetWidget(getter_AddRefs(mWidget));
  NS_ENSURE_TRUE(mWidget, NS_ERROR_FAILURE);
  /* Gets nsISelectionController interface for the current context */
  mCurSelCon = do_QueryInterface(shell);
  NS_ENSURE_TRUE(mCurSelCon, NS_ERROR_FAILURE);

  if (aWidget)
    NS_ADDREF(*aWidget = mWidget);
  if (aViewManager)
    NS_ADDREF(*aViewManager = mViewManager);
  if (aSelect)
    NS_ADDREF(*aSelect = mCurSelCon);
  if (aDOMWindow)
    NS_ADDREF(*aDOMWindow = mWindow);

  return NS_OK;
}

//static
PRBool
HelperFunctions::IsXULNode(nsIDOMEvent *aDOMEvent, PRUint32 *aType)
{
  NS_ENSURE_TRUE(aDOMEvent, PR_FALSE);
  nsCOMPtr<nsIDOMNSEvent> domNSEvent = do_QueryInterface(aDOMEvent);
  NS_ENSURE_TRUE(domNSEvent, PR_FALSE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  domNSEvent->GetOriginalTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, PR_FALSE);
  nsCOMPtr<nsIContent> targetContent = do_QueryInterface(eventTarget);
  NS_ENSURE_TRUE(targetContent, PR_FALSE);
  nsCOMPtr<nsIDOMNode> node = do_QueryInterface(eventTarget);
  NS_ENSURE_TRUE(node, PR_FALSE);

  const PRUint32 kThumb = 0;
  const PRUint32 kSlider = 2;
  const PRUint32 kScrollBarButton = 3;

  nsString sorigNode;
  node->GetNodeName(sorigNode);
  if (sorigNode.EqualsLiteral("#document"))
    return PR_FALSE;

  PRBool retval = targetContent->IsNodeOfType(nsINode::eXUL);

  NS_ENSURE_TRUE(aType, retval);
  if (sorigNode.EqualsLiteral("xul:thumb") ||
          sorigNode.EqualsLiteral("xul:vbox") ||
          sorigNode.EqualsLiteral("xul:spacer"))
    *aType = kThumb;
  else if (sorigNode.EqualsLiteral("xul:slider"))
    *aType = kSlider;
  else if (sorigNode.EqualsLiteral("xul:scrollbarbutton"))
    *aType = kScrollBarButton;

  return retval;
}

//static
nsresult
HelperFunctions::GetDOMWindowByNode(nsIDOMNode *aNode,
                                    nsIDOMWindow **aDOMWindow)
{
  NS_ENSURE_TRUE(aNode, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aDOMWindow, NS_ERROR_FAILURE);
  nsresult rv;
  nsCOMPtr<nsIDOMDocument> nodeDoc;
  rv = aNode->GetOwnerDocument(getter_AddRefs(nodeDoc));
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMDocumentView> docView = do_QueryInterface(nodeDoc, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMAbstractView> absView;
  rv = docView->GetDefaultView(getter_AddRefs(absView));
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMWindow> window = do_QueryInterface(absView, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  NS_IF_ADDREF(*aDOMWindow = window);
  return rv;
}

//static
nsresult
HelperFunctions::GetPref(PREF_TYPE type, const char *name, void *value)
{
  NS_ENSURE_TRUE(name, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(value, NS_ERROR_FAILURE);

  nsresult rv = NS_ERROR_FAILURE;
  nsCOMPtr<nsIPrefBranch> prefBranch = do_GetService(NS_PREFSERVICE_CONTRACTID, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  NS_ENSURE_TRUE(prefBranch, NS_ERROR_FAILURE);

  switch (type) {
    case PREF_TYPE_BOOL:
    {
      rv = prefBranch->GetBoolPref(name, (PRBool*) value);
      break;
    }
    case PREF_TYPE_INT:
    {
      rv = prefBranch->GetIntPref(name, (PRInt32*) value);
      break;
    }
    case PREF_TYPE_STRING:
    {
      rv = prefBranch->GetCharPref(name, (char**) value);
      break;
    }
    default:
      break;
  }
  return rv;
}

//static
nsresult
HelperFunctions::ShowElementTree(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  nsCOMPtr<nsIDOMEventTarget> eventTarget;
  aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
  NS_ENSURE_TRUE(eventTarget, NS_ERROR_FAILURE);

  nsCOMPtr<nsIDOMNode> eventNode = do_QueryInterface(eventTarget);
  NS_ENSURE_TRUE(eventNode, NS_ERROR_FAILURE);
  nsCOMPtr<nsIDOMNode> parentNode;
  nsString uTag;
  while (eventNode) {
    eventNode->GetLocalName(uTag);
    printf("%s\n", NS_ConvertUTF16toUTF8(uTag).get());
    eventNode->GetParentNode(getter_AddRefs(parentNode));
    eventNode = parentNode;
  }
  return NS_OK;
}

//static
nsresult
HelperFunctions::UpdateCursorVisibility(nsIDOMEvent* aDOMEvent, PRBool* aVisibilityPtr)
{
#ifdef USE_GTK
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(aVisibilityPtr, NS_ERROR_FAILURE);
  nsCOMPtr<nsIWidget> widget;
  GetWidgetFromEvent(aDOMEvent, getter_AddRefs(widget));
  NS_ENSURE_TRUE(widget, NS_ERROR_FAILURE);

  for (GdkWindow* window = GDK_WINDOW(widget->GetNativeData(NS_NATIVE_WINDOW));
       window;
       window = gdk_window_get_parent(window)) {
    if (g_object_get_data(G_OBJECT(window), "nsWindow")) {
      g_object_set_data(G_OBJECT(window), "cursor-visibile", aVisibilityPtr);
    }
  }
  return NS_OK;
#else // !USE_GTK
  return NS_ERROR_FAILURE;
#endif // USE_GTK
}
