#include "inputMode.h"
#include "nsIDOMEvent.h"
#include "nsITimer.h"
#include "nsComponentManagerUtils.h"
#include "nsITouchInteractListener.h"
#include "nsIWidget.h"
#include "nsIViewManager.h"

NS_IMPL_ISUPPORTS1(InputMode, IBaseMode)

InputMode::InputMode() :
  mViewManager(nsnull),
  mMouseDown(PR_FALSE)
{
  Init();
}

nsresult
InputMode::Init()
{
  INIT_MOUSE_DISPATCH();
  return NS_OK;
}

InputMode::~InputMode()
{
}

PRBool
InputMode::SetMouseDown(PRBool aMouseDown)
{
  mMouseDown = aMouseDown;
  return mMouseDown;
}

PRBool
InputMode::CanShowCxtMenu()
{
  return PR_FALSE;
}

nsIDOMEvent*
InputMode::GetDOMEvent()
{
  return mDOMEvent;
}

nsresult
InputMode::OnInput(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  mDOMEvent = do_QueryInterface(aDOMEvent);
  return CALL_MOUSE_DISPATCH(aDOMEvent);
}

nsresult
InputMode::MouseDown(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  mMouseDown = PR_TRUE;

  MouseEventArg tmpMousedownEvent;
  memcpy((void*)&tmpMousedownEvent, (void*)&mFirstMousedownEvent, sizeof(MouseEventArg));
  HelperFunctions::UpdateMouseEventArg(aDOMEvent, &mFirstMousedownEvent);
  HelperFunctions::UpdateMouseEventArg(aDOMEvent, &mLastMouseEvent);
  HelperFunctions::RemoveSelection(aDOMEvent);
  HelperFunctions::OpenSelection(aDOMEvent);

  GET_STATIC_INTERACTLISTENER(sListener);
  if (!sListener) return NS_OK;

  nsCOMPtr<nsIWidget> widget;
  HelperFunctions::GetWidgetFromEvent(aDOMEvent, getter_AddRefs(widget));
  return sListener->OnMouseDownInput(aDOMEvent, widget);
}

nsresult
InputMode::MouseMove(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  NS_ENSURE_TRUE(mMouseDown, NS_OK);
  HelperFunctions::UpdateMouseEventArg(aDOMEvent, &mCurrentMouseEvent);
  PRBool isJittering = HelperFunctions::IsMouseJittering(&mCurrentMouseEvent,
                                                         &mLastMouseEvent,
                                                         nsnull,
                                                         nsnull,
                                                         nsnull);
  NS_ENSURE_FALSE(isJittering, NS_OK);
  HelperFunctions::UpdateMouseEventArg(aDOMEvent, &mLastMouseEvent);

  GET_STATIC_INTERACTLISTENER(sListener);
  if (!sListener) return NS_OK;

  nsCOMPtr<nsIViewManager> tmpViewManager;
  HelperFunctions::GetViewManagerFromEvent(aDOMEvent, getter_AddRefs(tmpViewManager));
  NS_IF_ADDREF(mViewManager = tmpViewManager);
  NS_ENSURE_TRUE(mViewManager, NS_ERROR_FAILURE);

  HelperFunctions::EdgeAutoScroll(aDOMEvent, mViewManager);
  nsCOMPtr<nsIWidget> widget;
  HelperFunctions::GetWidgetFromEvent(aDOMEvent, getter_AddRefs(widget));
  return sListener->OnMouseMoveInput(aDOMEvent, widget);
}

nsresult
InputMode::MouseUp(nsIDOMEvent *aDOMEvent)
{
  NS_ENSURE_TRUE(aDOMEvent, NS_ERROR_FAILURE);
  mMouseDown = PR_FALSE;
  HelperFunctions::StopAutoScroll();

  GET_STATIC_INTERACTLISTENER(sListener);
  if (!sListener) return NS_OK;

  nsCOMPtr<nsIWidget> widget;
  HelperFunctions::GetWidgetFromEvent(aDOMEvent, getter_AddRefs(widget));
  return sListener->OnMouseUpInput(aDOMEvent, widget);
}
