#ifndef _HELPERFUNCTIONS_H_
#define _HELPERFUNCTIONS_H_

#include "nsISupports.h"
#include "domstubs.h"
#include "nsCOMPtr.h"
#include "nsIWidget.h"

enum TOUCHSCREEN_MODE
{
  MODE_PANNING,
  MODE_HOVER,
  MODE_DINPUT,
  MODE_MONO,
  MODE_UNSUPPORTED,
  MODE_ALL
};

enum EVENT_TYPE
{
  MOUSE_DOWN,
  MOUSE_MOVE,
  MOUSE_UP,
  MOUSE_OVER,
  MOUSE_OUT,
  MOUSE_CLICK,
  EVENT_TYPE_UNSUPPORTED,
  EVENT_TYPE_ALL

};

enum PREF_TYPE
{
  PREF_TYPE_BOOL,
  PREF_TYPE_INT,
  PREF_TYPE_STRING,
  PREF_TYPE_UNSUPPORTED,
  PREF_TYPE_ALL
};

typedef struct _mouseEventArg
{
  DOMTimeStamp timeStamp;
  PRInt32 screenX;
  PRInt32 screenY;
  PRInt32 clientX;
  PRInt32 clientY;
  PRInt32 eventType;
  float pressure;
} MouseEventArg;

#define JITTER_DISTANCE 15
#define JITTER_TIME 50

class nsIViewManager;
class nsISelectionController;
class nsIDOMNode;
class nsIDOMWindow;
class nsIMarkupDocumentViewer;
class nsIURI;
class nsACString;
class nsITouchInteractListener;
class IBaseMode;
class nsITimer;
class nsIDOMEvent;
class nsIWebNavigation;

class HelperFunctions
{
public:
  static PRBool IsHTMLInputElement(nsIDOMEvent *aDOMEvent);
  static PRBool IsHTMLTextAreaElement(nsIDOMEvent *aDOMEvent);
  static PRBool IsHTMLAnchorElement(nsIDOMEvent *aDOMEvent);
  static PRBool IsHTMLSelectElement(nsIDOMEvent *aDOMEvent);
  static PRBool IsHTMLOptionElement(nsIDOMEvent *aDOMEvent);
  static PRBool IsNSHTMLButtonElement(nsIDOMEvent *aDOMEvent);
  static PRBool IsNSHTMLElement(nsIDOMEvent *aDOMEvent);
  static PRBool InActiveRegion(nsIDOMEvent *aDOMEvent);

  static nsresult GetWidgetFromEvent(nsIDOMEvent *aDOMEvent,
                                     nsIWidget **aWidget);
  static nsresult GetViewManagerFromEvent(nsIDOMEvent *aDOMEvent,
                                          nsIViewManager **aViewManager);
  static nsresult GetSelectionControllerFromEvent(nsIDOMEvent *aDOMEvent,
                                                  nsISelectionController **aSelect);
  static nsresult GetDOMWindowFromEvent(nsIDOMEvent *aDOMEvent,
                                        nsIDOMWindow **aDOMWindow);
  static nsresult GetWebNavigationwFromEvent(nsIDOMEvent *aDOMEvent,
                                             nsIWebNavigation **aWebNav);
  static nsresult GetTouchInteractListener(nsITouchInteractListener **aListener);
  static nsresult OpenSelection(nsIDOMEvent *aDOMEvent);
  static nsresult CloseSelection(nsIDOMEvent *aDOMEvent);
  static nsresult RemoveSelection(nsIDOMEvent *aDOMEvent);
  static nsresult IsSelectionAvailable(nsIDOMEvent *aDOMEvent, nsAString &aString);
  static PRInt32 GetMouseEventType(nsIDOMEvent *aDOMEvent);
  static nsresult GetMarkupViewerByWindow(nsIDOMWindow *aDOMWindow,
                                         nsIMarkupDocumentViewer * *aMarkupDocViewver);
  static PRInt32 GetZoomLevel(nsIDOMEvent *aDOMEvent);
  static nsresult GetPref(PREF_TYPE type, const char *name, void *value);
  static nsresult SetCursor(nsIDOMEvent *aDOMEvent, nsCursor aCursor);

  static PRBool UpdateMouseEventArg(nsIDOMEvent *aDOMEvent,
                                    MouseEventArg *aMouseEventArg);
  static PRBool IsMouseJittering(MouseEventArg *aCurrent,
                                 MouseEventArg *aLast,
                                 PRInt32 *aTime = nsnull,
                                 PRInt32 *aX = nsnull,
                                 PRInt32 *aY = nsnull, float aPressure = nsnull);
  static PRBool IsDblClick(MouseEventArg *aCurrent, MouseEventArg *aLast);
  static PRBool IsWrongEventSequence(nsIDOMEvent *aDOMEvent);

  static nsresult StartShowCxtMenu(IBaseMode *aBaseMode);
  static nsresult CancelShowCxtMenu();
  static nsresult EdgeAutoScroll(nsIDOMEvent *aDOMEvent,
                                 nsIViewManager *aViewManager);
  static nsresult StopAutoScroll();
  static nsresult ScrollWindow(nsIDOMEvent *aDOMEvent,
                               nsIViewManager *aViewManager,
                               PRInt32 aDx,
                               PRInt32 aDy);
  static PRBool CanScrollHorizontal(nsIViewManager *aViewManager);
  static PRBool CanScrollVertical(nsIViewManager *aViewManager);

  static PRBool IsXULNode(nsIDOMEvent *aDOMEvent, PRUint32 *aType = nsnull);

  static nsresult DumpMousePosition(nsIDOMEvent *aDOMEvent);
  static void DumpShouldLoad(PRUint32 aContentType,
                             nsIURI *aContentLocation,
                             nsIURI *aRequestingLocation,
                             nsISupports *aRequestingContext,
                             const nsACString &aMimeGuess);
  static nsresult ShowElementTree(nsIDOMEvent *aDOMEvent);
  static nsresult UpdateCursorVisibility(nsIDOMEvent* aDOMEvent,
                                         PRBool* aVisibilityPtr);

private:
  HelperFunctions();
  ~HelperFunctions();

  static void LongPressCallback(nsITimer *timer, void *closure);
  static void AutoScrollCallback(nsITimer *timer, void *closure);
  static PRBool ShouldAutoScroll(nsIDOMEvent *aDOMEvent,
                                 PRInt32 *aDx = nsnull,
                                 PRInt32 *aDy = nsnull);
  static nsresult GetDOMWindowByNode(nsIDOMNode *aNode,
                                     nsIDOMWindow **aDOMWindow);
  static nsresult UpdateFromEvent(nsIDOMEvent *aDOMEvent,
                                  nsIWidget **aWidget = nsnull,
                                  nsIViewManager **aViewManager = nsnull,
                                  nsISelectionController **aSelect = nsnull,
                                  nsIDOMWindow **aDOMWindow = nsnull);
  static nsITimer *sLongPressTimer;
  static nsITimer *sAutoScrollTimer;

  static PRInt32 sAutoDx;
  static PRInt32 sAutoDy;
};

#define DECLARE_MOUSE_DISPATCH(CLASSNAME) \
  typedef nsresult(CLASSNAME::* CLASSNAME##DispatchFunc)(nsIDOMEvent*); \
  typedef CLASSNAME CLASSNAMEAGENT; \
  CLASSNAME##DispatchFunc mDispatchTable[EVENT_TYPE_ALL];

#define INIT_MOUSE_DISPATCH() do{ \
  mDispatchTable[MOUSE_DOWN] = &CLASSNAMEAGENT::MouseDown; \
  mDispatchTable[MOUSE_MOVE] = &CLASSNAMEAGENT::MouseMove; \
  mDispatchTable[MOUSE_UP] = &CLASSNAMEAGENT::MouseUp; \
  mDispatchTable[MOUSE_OVER] = &CLASSNAMEAGENT::MouseOver; \
  mDispatchTable[MOUSE_OUT] = &CLASSNAMEAGENT::MouseOut; \
  mDispatchTable[MOUSE_CLICK] = &CLASSNAMEAGENT::MouseClick; \
  mDispatchTable[EVENT_TYPE_UNSUPPORTED] = &CLASSNAMEAGENT::UnsupportedEvent; \
  }while(0);

#define CALL_MOUSE_DISPATCH(aDOMEvent) \
  (this->*mDispatchTable[HelperFunctions::GetMouseEventType(aDOMEvent)])(aDOMEvent);

#define GET_STATIC_INTERACTLISTENER(sListener) \
  static nsITouchInteractListener *sListener = nsnull; \
  if (!sListener) { \
    nsCOMPtr<nsITouchInteractListener> listener; \
    HelperFunctions::GetTouchInteractListener(getter_AddRefs(listener)); \
    NS_IF_ADDREF(sListener = listener); \
    }

#endif //_HELPERFUNCTIONS_H_
