/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nokia code.
 *
 * The Initial Developer of the Original Code is Novell.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Aiken Tie <ext-tie.aiken@nokia.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef TESTGTKMOZEMBED_H
#define TESTGTKMOZEMBED_H

#include <cppunit/extensions/HelperMacros.h>
#include <gtk/gtk.h>
#include <glib.h>

#include "gtkmozembed.h"
#include "gtkmozembed_common.h"

class TestGtkMozEmbed : public CppUnit::TestFixture
{
	CPPUNIT_TEST_SUITE( TestGtkMozEmbed );
	CPPUNIT_TEST(testConstructor);
	CPPUNIT_TEST(testDestructor);
	CPPUNIT_TEST(testPushStartup);
	CPPUNIT_TEST(testPopStartup);
	CPPUNIT_TEST(testSetPathWithNULL);
	CPPUNIT_TEST(testSetPath);
	CPPUNIT_TEST(testSetCompPathWithNULL);
	CPPUNIT_TEST(testSetCompPath);
	CPPUNIT_TEST(testSetProfilePathWithNULL);
	CPPUNIT_TEST(testSetProfilePath);
	CPPUNIT_TEST(testLoadUrlWithNULL);
	CPPUNIT_TEST(testLoadUrl1);
	CPPUNIT_TEST(testLoadUrl2);
	CPPUNIT_TEST(testStopLoadWithNULL);
	CPPUNIT_TEST(testStopLoad);
	CPPUNIT_TEST(testCanGoBackWithNULL);
	CPPUNIT_TEST(testCanGoBack);
	CPPUNIT_TEST(testBackwardForward);
	CPPUNIT_TEST(testCanGoForwardWithNULL);
	CPPUNIT_TEST(testGoBackWithNULL);
	CPPUNIT_TEST(testGoForwardWithNULL);
	CPPUNIT_TEST(testRenderDataWithNULL);
	CPPUNIT_TEST(testOpenStreamWithNULL);
	CPPUNIT_TEST(testAppendDataWithNULL);
	CPPUNIT_TEST(testCloseStreamWithNULL);
	CPPUNIT_TEST(testGetLinkMessageWithNULL);
	CPPUNIT_TEST(testGetJsStatusWithNULL);
	CPPUNIT_TEST(testGetTitleWithNULL);
	CPPUNIT_TEST(testGetLocationWithNULL);
	CPPUNIT_TEST(testReloadWithNULL);
	CPPUNIT_TEST(testSetChromeMaskWithNULL);
	CPPUNIT_TEST(testGetChromeMaskWithNULL);
	CPPUNIT_TEST(testCanGoForward);
	CPPUNIT_TEST(testGoBack);
	CPPUNIT_TEST(testGoForward);
	CPPUNIT_TEST(testRenderData);
	CPPUNIT_TEST(testOpenStream1);
	CPPUNIT_TEST(testOpenStream2);
	CPPUNIT_TEST(testAppendData1);
	CPPUNIT_TEST(testAppendData2);
	CPPUNIT_TEST(testCloseStream);
	CPPUNIT_TEST(testGetLinkMessage);
	CPPUNIT_TEST(testGetJsStatus);
	CPPUNIT_TEST(testGetTitle);
	CPPUNIT_TEST(testGetLocation1);
	CPPUNIT_TEST(testGetLocation2);
	CPPUNIT_TEST(testReload);
	CPPUNIT_TEST(testSetChromeMask);
	CPPUNIT_TEST(testGetChromeMask);
	CPPUNIT_TEST(test_get_nsIWebBrowser1);
	CPPUNIT_TEST(test_get_nsIWebBrowser2);
	CPPUNIT_TEST(test_get_nsIWebBrowser3);
	CPPUNIT_TEST(test_get_title_unichar1);
	CPPUNIT_TEST(test_get_title_unichar2);
	CPPUNIT_TEST(test_get_js_status_unichar1);
	CPPUNIT_TEST(test_get_js_status_unichar2);
	CPPUNIT_TEST(test_get_link_message_unichar1);
	CPPUNIT_TEST(test_get_link_message_unichar2);
	CPPUNIT_TEST(test_set_directory_service_provider);
	CPPUNIT_TEST(test_set_app_components);
	CPPUNIT_TEST(test_set_static_components);
	CPPUNIT_TEST(test_single_create_window);
//	CPPUNIT_TEST(testGetZoomLevelWithNULL);
//	CPPUNIT_TEST(testSetZoomLevelWithNULL);
//	CPPUNIT_TEST(testFindTextWithNULL);
//	CPPUNIT_TEST(testNotifyPluginsWithNULL);
//	CPPUNIT_TEST(testCheckLoginsWithNULL);
//	CPPUNIT_TEST(testLoadImageWithNULL);
//	CPPUNIT_TEST(testGetDocInfoWithNULL);
	CPPUNIT_TEST_SUITE_END();
	public:

	void setUp();
	void testConstructor();
	void testDestructor();
	void testPushStartup();
	void testPopStartup();
	void testSetPathWithNULL();
	void testSetPath();
	void testSetCompPathWithNULL();
	void testSetCompPath();
	void testSetProfilePathWithNULL();
	void testSetProfilePath();
	void testLoadUrlWithNULL();
	void testLoadUrl1();
	void testLoadUrl2();
	void testStopLoadWithNULL();
	void testStopLoad();
	void testCanGoBackWithNULL();
	void testCanGoBack();
	void testBackwardForward();
	void testCanGoForwardWithNULL();
	void testGoBackWithNULL();
	void testGoForwardWithNULL();
	void testRenderDataWithNULL();
	void testOpenStreamWithNULL();
	void testAppendDataWithNULL();
	void testCloseStreamWithNULL();
	void testGetLinkMessageWithNULL();
	void testGetJsStatusWithNULL();
	void testGetTitleWithNULL();
	void testGetLocationWithNULL();
	void testReloadWithNULL();
	void testSetChromeMaskWithNULL();
	void testGetChromeMaskWithNULL();
	void testCanGoForward();
	void testGoBack();
	void testGoForward();
	void testRenderData();
	void testOpenStream1();
	void testOpenStream2();
	void testAppendData1();
	void testAppendData2();
	void testCloseStream();
	void testGetLinkMessage();
	void testGetJsStatus();
	void testGetTitle();
	void testGetLocation1();
	void testGetLocation2();
	void testReload();
	void testSetChromeMask();
	void testGetChromeMask();
	void test_get_nsIWebBrowser1();
	void test_get_nsIWebBrowser2();
	void test_get_nsIWebBrowser3();
	void test_get_title_unichar1();
	void test_get_title_unichar2();
	void test_get_js_status_unichar1();
	void test_get_js_status_unichar2();
	void test_get_link_message_unichar1();
	void test_get_link_message_unichar2();
	void test_set_directory_service_provider();
	void test_set_app_components();
	void test_set_static_components();
	void test_single_create_window();
//	void testGetZoomLevelWithNULL();
//	void testSetZoomLevelWithNULL();
//	void testFindTextWithNULL();
//	void testNotifyPluginsWithNULL();
//	void testCheckLoginsWithNULL();
//	void testLoadImageWithNULL();
//	void testGetDocInfoWithNULL();


	GtkWidget* mWidget;
	GtkMozEmbed *mEmbed;
	GtkMozEmbedClass *mEmbedClass;
	const char* path;
	const char* uri;

	private:
	void initGtkMozEmbed();

};






#endif //TESTGTKMOZEMBED_H
