/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Nokia code.
 *
 * The Initial Developer of the Original Code is Novell.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Aiken Tie <ext-tie.aiken@nokia.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "testgtkmozembed_common.h"
#include "CppUnitSignalException.h"

CPPUNIT_TEST_SUITE_REGISTRATION( TestGtkMozEmbedCommon );

char* SOME_STRING = "some string";

void
TestGtkMozEmbedCommon::testConstructor()
{
	GtkWidget* widget;
	widget = gtk_moz_embed_common_new();
	CPPUNIT_ASSERT(widget != NULL);
	CPPUNIT_ASSERT(GTK_IS_MOZ_EMBED_COMMON(widget));
}

void
TestGtkMozEmbedCommon::testDestructor()
{
	GtkWidget* widget;
	widget = gtk_moz_embed_common_new();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_widget_destroy(widget));
}

/*
 * private initilize GtkMozEmbedCommon class
 */
void
TestGtkMozEmbedCommon::initGtkMozEmbedCommon()
{
	mWidget = gtk_moz_embed_common_new();
	mEmbed = GTK_MOZ_EMBED_COMMON(mWidget);
}


void
TestGtkMozEmbedCommon::testSetPref1()
{
	gboolean retvalue;
	initGtkMozEmbedCommon();
	retvalue = gtk_moz_embed_common_set_pref(gtk_moz_embed_common_get_type(), NULL, NULL);
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbedCommon::testSetPref2()
{
	gboolean retvalue;
	initGtkMozEmbedCommon();
	retvalue = gtk_moz_embed_common_set_pref(gtk_moz_embed_common_get_type(), SOME_STRING, NULL);
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbedCommon::testSetPref3()
{
	gboolean retvalue;
	initGtkMozEmbedCommon();
	retvalue = gtk_moz_embed_common_set_pref(gtk_moz_embed_common_get_type(), SOME_STRING, (void*)SOME_STRING);
	CPPUNIT_ASSERT(!retvalue);
}


void
TestGtkMozEmbedCommon::testGetPref1()
{
	gboolean retvalue;
	initGtkMozEmbedCommon();
	retvalue = gtk_moz_embed_common_get_pref(gtk_moz_embed_common_get_type(), NULL, NULL);
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbedCommon::testGetPref2()
{
	gboolean retvalue;
	gchar** value = NULL;
	initGtkMozEmbedCommon();
	retvalue = gtk_moz_embed_common_get_pref(gtk_moz_embed_common_get_type(), SOME_STRING, value);
	CPPUNIT_ASSERT(!retvalue);
}

void
TestGtkMozEmbedCommon::testGetPref3()
{
	gboolean retvalue;
	gchar* value = NULL;
	initGtkMozEmbedCommon();
	retvalue = gtk_moz_embed_common_get_pref(GTK_TYPE_STRING, SOME_STRING, &value);
	CPPUNIT_ASSERT(!retvalue);
}


void
TestGtkMozEmbedCommon::testSavePref()
{
	initGtkMozEmbedCommon();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_common_save_prefs());
}


void
TestGtkMozEmbedCommon::testGetLogins()
{
	// That function implementation already moved to microb-eal
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_common_get_logins(NULL, NULL));
}

void
TestGtkMozEmbedCommon::remove_passwords()
{
	// That function implementation already moved to microb-eal
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_common_remove_passwords(NULL, NULL, 0));
}

void
TestGtkMozEmbedCommon::testGetHistoryList()
{
	// That function implementation already moved to microb-eal
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_common_get_history_list(NULL));
}

void
TestGtkMozEmbedCommon::testRemoveHistory()
{
	// That function implementation already moved to microb-eal
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_common_remove_history(NULL, NULL));
}


void
TestGtkMozEmbedCommon::testGetCookieList()
{
	initGtkMozEmbedCommon();
	GSList* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_common_get_cookie_list());
	CPPUNIT_ASSERT(NULL == retvalue);
}

void
TestGtkMozEmbedCommon::testDeleteAllCookies()
{
	initGtkMozEmbedCommon();
	gint retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_common_delete_all_cookies(NULL));
	CPPUNIT_ASSERT(-1 == retvalue);
}

void
TestGtkMozEmbedCommon::testNSX509toRaw()
{
	initGtkMozEmbedCommon();
	unsigned char* retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_common_nsx509_to_raw(NULL, NULL));
	CPPUNIT_ASSERT(NULL == retvalue);
}

void
TestGtkMozEmbedCommon::testGetPluginsList()
{
	initGtkMozEmbedCommon();
	GList* pluginArray = NULL;
	gint retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_common_get_plugins_list(&pluginArray));
}

void
TestGtkMozEmbedCommon::testGetPluginsListWithNULL()
{
	initGtkMozEmbedCommon();
	GList** pluginArray = NULL;
	gint retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_common_get_plugins_list(pluginArray));
}

void
TestGtkMozEmbedCommon::testReloadPlugins()
{
	initGtkMozEmbedCommon();
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_common_reload_plugins(true));
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(gtk_moz_embed_common_reload_plugins(false));
}

void
TestGtkMozEmbedCommon::testGetSecurityMode()
{
	initGtkMozEmbedCommon();
	guint retvalue = gtk_moz_embed_common_get_security_mode(0);
	CPPUNIT_ASSERT(GTK_MOZ_EMBED_UNKNOWN_SECURITY == retvalue); 
}

void
TestGtkMozEmbedCommon::testClearCache()
{
	initGtkMozEmbedCommon();
	gint retvalue;
	CPPUNIT_ASSERT_NO_SIGNAL_OR_EXCEPTION(retvalue = gtk_moz_embed_common_clear_cache());
}


