/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Oleg Romashin <romaxa@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "EmbedGtkTools.h"
#include "nsServiceManagerUtils.h"
#include "EmbedPrivate.h"
#include "nsIWebBrowser.h"
#include "nsPIDOMWindow.h"
#include "nsIDOMDocument.h"
#include "nsIDOMDocumentView.h"
#include "nsIDOMAbstractView.h"
#include "nsICommandManager.h"
#include "nsIImageLoadingContent.h"
#include "nsIDOMNSHTMLElement.h"
#include "nsIWebBrowserFocus.h"
#include "nsIDOMElement.h"
#include "gfxIImageFrame.h"
#include "imgIRequest.h"
#include "imgIContainer.h"
#include "nsIImageLoadingContent.h"
#include "nsIDOMHTMLImageElement.h"
#include "nsIContent.h"
#include "nsIDocument.h"
#include "nsIPresShell.h"
#include "nsIImageDocument.h"
#include "nsIDOMNodeList.h"

GtkWidget * GetGtkWidgetForDOMWindow(nsIDOMWindow* aDOMWindow)
{
  nsCOMPtr<nsIWindowWatcher> wwatch = do_GetService("@mozilla.org/embedcomp/window-watcher;1");
  nsCOMPtr<nsIWebBrowserChrome> chrome;
  if (wwatch) {
    if (!aDOMWindow) {
      nsCOMPtr <nsIDOMWindow> DOMWindow;
      wwatch->GetActiveWindow(getter_AddRefs(DOMWindow));
      wwatch->GetChromeForWindow(DOMWindow, getter_AddRefs(chrome));
    } else
      wwatch->GetChromeForWindow(aDOMWindow, getter_AddRefs(chrome));
  }

  if (!chrome)
    return GTK_WIDGET(GetAnyLiveWidget());

  nsCOMPtr<nsIEmbeddingSiteWindow> siteWindow = nsnull;
  siteWindow = do_QueryInterface(chrome);

  if (!siteWindow)
    return GTK_WIDGET(GetAnyLiveWidget());

  GtkWidget* parentWidget;
  siteWindow->GetSiteWindow((void**)&parentWidget);
  if (GTK_IS_WIDGET(parentWidget))
    return parentWidget;
  return GTK_WIDGET(GetAnyLiveWidget());
}

GtkWindow * GetGtkWindowForDOMWindow(nsIDOMWindow* aDOMWindow)
{
  GtkWidget* parentWidget = GetGtkWidgetForDOMWindow(aDOMWindow);
  if (!parentWidget)
    return NULL;
  GtkWidget* gtkWin = gtk_widget_get_toplevel(parentWidget);
  if (GTK_WIDGET_TOPLEVEL(gtkWin))
    return GTK_WINDOW(gtkWin);
  return NULL;
}

nsresult GetContentViewer(nsIWebBrowser *webBrowser, nsIContentViewer **aViewer)
{
  g_return_val_if_fail(webBrowser, NS_ERROR_FAILURE);
  nsCOMPtr<nsIDocShell> docShell(do_GetInterface((nsISupports*)webBrowser));
  NS_ENSURE_TRUE(docShell, NS_ERROR_FAILURE);
  return docShell->GetContentViewer(aViewer);
}

GtkWidget* GetAnyLiveWidget(void)
{
  if (!EmbedPrivate::sWidgetCount || !EmbedPrivate::sWindowList)
    return nsnull;

  // Get the number of browser windows.
  PRInt32 count = EmbedPrivate::sWindowList->Count();
  // This function doesn't get called very often at all (only when
  // creating a new window) so it's OK to walk the list of open
  // windows.
  //FIXME need to choose right window
  GtkWidget *ret = nsnull;
  for (int i = 0; i < count; i++) {
    EmbedPrivate *tmpPrivate = static_cast<EmbedPrivate *>
      (EmbedPrivate::sWindowList->ElementAt(i));
    ret = GTK_WIDGET(tmpPrivate->mOwningWidget);
  }
  return ret;
}

nsresult
GetDOMWindowByNode(nsIDOMNode *aNode, nsIDOMWindow * *aDOMWindow)
{
  NS_ENSURE_ARG_POINTER(aNode);
  NS_ENSURE_ARG_POINTER(aDOMWindow);
  nsresult rv;
  nsCOMPtr<nsIDOMDocument> nodeDoc;
  rv = aNode->GetOwnerDocument(getter_AddRefs(nodeDoc));
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMDocumentView> docView = do_QueryInterface(nodeDoc, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMAbstractView> absView;
  NS_ENSURE_SUCCESS(rv, rv);
  rv = docView->GetDefaultView(getter_AddRefs(absView));
  NS_ENSURE_SUCCESS(rv, rv);
  nsCOMPtr<nsIDOMWindow> window = do_QueryInterface(absView, &rv);
  NS_ENSURE_SUCCESS(rv, rv);
  *aDOMWindow = window;
  NS_IF_ADDREF(*aDOMWindow);
  return rv;
}

nsresult
GetImageRequest(imgIRequest **aRequest, nsIDOMNode *aDOMNode)
{
  NS_ENSURE_ARG(aDOMNode);
  NS_ENSURE_ARG_POINTER(aRequest);

  // Get content
  nsCOMPtr<nsIImageLoadingContent> content(do_QueryInterface(aDOMNode));
  NS_ENSURE_TRUE(content, NS_ERROR_FAILURE);

  return content->GetRequest(nsIImageLoadingContent::CURRENT_REQUEST, aRequest);
}

nsresult
ScrollToSelectedNode(nsISupports *element)
{
  nsresult rv = NS_ERROR_FAILURE;
  nsCOMPtr<nsIDOMNSHTMLElement> nodeElement = do_QueryInterface(element);
  if (!nodeElement) {
    nsCOMPtr<nsIWebBrowser> webBrowser = do_QueryInterface(element);
    if (!webBrowser)
       return rv;
    nsCOMPtr<nsIWebBrowserFocus> focus(do_GetInterface(webBrowser));
    if (!focus)
      return rv;
    nsCOMPtr<nsIDOMElement> domElement;
    rv = focus->GetFocusedElement(getter_AddRefs(domElement));
    nodeElement = do_QueryInterface(domElement);
  }
  if (nodeElement) {
    nsCOMPtr<nsIDOMNode> node = do_QueryInterface(nodeElement, &rv);
    NS_ENSURE_TRUE(node, rv);
    nsCOMPtr<nsIDOMDocument> document;
    node->GetOwnerDocument(getter_AddRefs(document));
    NS_ENSURE_TRUE(document, rv);
    nsCOMPtr<nsIDocument> doc = do_QueryInterface(document, &rv);
    NS_ENSURE_TRUE(doc, rv);
    nsCOMPtr<nsIPresShell> presShell = doc->GetPrimaryShell();
    NS_ENSURE_TRUE(presShell, NS_ERROR_FAILURE);
    nsCOMPtr<nsIContent> content = do_QueryInterface(node, &rv);
    NS_ENSURE_TRUE(content, rv);
    presShell->ScrollContentIntoView(content, NS_PRESSHELL_SCROLL_ANYWHERE,
                                     NS_PRESSHELL_SCROLL_ANYWHERE);
  }
  return rv;
}

nsresult
CheckDomImageElement(nsIDOMNode *node, nsIDOMWindow *aWindow, nsString& aHref,
                     PRInt32 &aWidth, PRInt32 &aHeight, PRUint32 *aSize)
{
  nsresult rv;
  nsCOMPtr<nsIDOMHTMLImageElement> image =
    do_QueryInterface(node, &rv);
  if (!image && aWindow) {
    nsCOMPtr <nsIImageDocument> imgDoc;
    nsCOMPtr <nsIDOMDocument> ddoc;
    rv = aWindow->GetDocument(getter_AddRefs(ddoc));
    NS_ENSURE_SUCCESS(rv, rv);
    imgDoc = do_QueryInterface(ddoc, &rv);
    NS_ENSURE_SUCCESS(rv, rv);
    nsCOMPtr<nsIDOMElement> domElement;
    rv = ddoc->GetDocumentElement(getter_AddRefs(domElement));
    nsCOMPtr<nsIDOMNodeList> nodeList;
    rv = ddoc->GetElementsByTagName(NS_LITERAL_STRING("body"),
                                    getter_AddRefs (nodeList));
    nsCOMPtr<nsIDOMNode> bodyNode;
    if (NS_SUCCEEDED (rv) && nodeList)
      rv = nodeList->Item (0, getter_AddRefs (bodyNode));
    NS_ENSURE_TRUE(bodyNode, rv);

    nsCOMPtr<nsIDOMNode> firstChild;
    rv = bodyNode->GetFirstChild(getter_AddRefs(firstChild));
    NS_ENSURE_TRUE(firstChild, rv);
    image = do_QueryInterface(firstChild, &rv);
  }
  NS_ENSURE_TRUE(image, rv);
  rv = image->GetSrc(aHref);
  NS_ENSURE_SUCCESS(rv, rv);
  image->GetWidth(&aWidth);
  image->GetHeight(&aHeight);
  if (!aSize) return rv;
  nsCOMPtr<imgIRequest> request;
  GetImageRequest(getter_AddRefs(request), node);
  NS_ENSURE_TRUE(request, rv);
  nsCOMPtr<imgIContainer> imgCont;
  request->GetImage(getter_AddRefs(imgCont));
  NS_ENSURE_TRUE(imgCont, rv);
  nsCOMPtr<gfxIImageFrame> currentFrame;
  imgCont->GetCurrentFrame(getter_AddRefs(currentFrame));
  NS_ENSURE_TRUE(currentFrame, rv);
  currentFrame->GetImageDataLength(aSize);
  return rv;
}
