;; Used:     EFG IJKLMNOPQRSTUVWX  a  d fg i   mnop rs       
;; Resv: A C    H                                            
;; Free:  B D                    YZ bc e  h jkl    q  tuvwxyz

(define_register_constraint "a" "ADDR_REGS"
  "Address registers @code{a0}-@code{a7}.")

(define_register_constraint "d" "DATA_REGS"
  "Data registers @code{d0}-@code{d7}.")

(define_register_constraint "f" "TARGET_HARD_FLOAT ? FP_REGS : NO_REGS"
  "Floating point registers @code{f0}-@code{f7}.")

(define_constraint "I"
  "Range 1 to 8 allowed as immediate shift counts and in addq."
  (and (match_code "const_int")
       (match_test "ival > 0 && ival <= 8")))

(define_constraint "J"
  "Range of signed numbers that fit in 16 bits."
  (and (match_code "const_int")
       (match_test "ival >= -0x8000 && ival <= 0x7FFF")))

(define_constraint "K"
  "Numbers that moveq can't handle."
  (and (match_code "const_int")
       (match_test "ival < -0x80 || ival >= 0x80")))

(define_constraint "L"
  "Range -8 to -1, range of values that can be added with subq."
  (and (match_code "const_int")
       (match_test "ival < 0 && ival >= -8")))

(define_constraint "M"
  "Numbers that moveq+notb can't handle."
  (and (match_code "const_int")
       (match_test "ival < -0x100 || ival >= 0x100")))

(define_constraint "N"
  "Range 24 to 31, rotatert:SI 8 to 1 expressed as rotate."
  (and (match_code "const_int")
       (match_test "ival >= 24 && ival <= 31")))

(define_constraint "O"
  "16 (for rotate using swap)."
  (and (match_code "const_int")
       (match_test "ival == 16")))

(define_constraint "P"
  "Range 8 to 15, rotatert:HI 8 to 1 expressed as rotate."
  (and (match_code "const_int")
       (match_test "ival >= 8 && ival <= 15")))

(define_constraint "R"
  "Numbers that mov3q can handle."
  (and (match_code "const_int")
       (match_test "valid_mov3q_const (ival)")))

(define_constraint "G"
  "All of the floating constants that are *NOT* 68881
   constants.  This is so 68881 constants get reloaded and the
   fpmovecr is used."
  (and (match_code "const_double")
       (match_test "! (TARGET_68881 && standard_68881_constant_p (op))")))

(define_constraint "S"
  "Operands that satisfy 'm' when -mpcrel is in effect."
  (match_test
    "(TARGET_PCREL					\
      && GET_CODE (op) == MEM				\
      && (GET_CODE (XEXP (op, 0)) == SYMBOL_REF		\
	  || GET_CODE (XEXP (op, 0)) == LABEL_REF	\
	  || GET_CODE (XEXP (op, 0)) == CONST))"))

(define_constraint "T"
  "Operands that satisfy 's' when -mpcrel is not in effect."
  (match_test
    "(!flag_pic						\
      && (GET_CODE (op) == SYMBOL_REF			\
	  || GET_CODE (op) == LABEL_REF			\
	  || GET_CODE (op) == CONST))"))

(define_constraint "Q"
  "Address register indirect addressing mode."
  (match_test "m68k_matches_q_p (op)"))

(define_constraint "U"
  "Register offset addressing."
  (match_test "m68k_matches_u_p (op)"))

(define_constraint "W"
  "const_call_operand."
  (match_test "const_call_operand (op, VOIDmode)"))

(define_constraint "Cs"
  "symbol_ref or const."
  (match_code "symbol_ref,const"))

(define_constraint "Ci"
  "const_int."
  (and (match_code "const_int")
       (match_test "true")))

(define_constraint "C0"
  "const_int 0."
  (and (match_code "const_int")
       (match_test "ival == 0")))

(define_constraint "Cj"
  "Range of signed numbers that don't fit in 16 bits."
  (and (match_code "const_int")
       (match_test "ival < -0x8000 || ival > 0x7FFF")))

(define_constraint "Cmvq"
  "Integers valid for mvq."
  (and (match_code "const_int")
       (match_test "m68k_const_method (ival) == MOVQ")))

(define_constraint "Capsw"
  "Integers valid for a moveq followed by a swap."
  (and (match_code "const_int")
       (match_test "m68k_const_method (ival) == SWAP")))

(define_constraint "Cmvz"
  "Integers valid for mvz."
  (and (match_code "const_int")
       (match_test "m68k_const_method (ival) == MVZ")))

(define_constraint "Cmvs"
  "Integers valid for mvs."
  (and (match_code "const_int")
       (match_test "m68k_const_method (ival) == MVS")))

(define_constraint "Ap"
  "push_operand."
  (match_operand 0 "push_operand"))

(define_constraint "Ac"
  "Non-register operands allowed in clr."
  (and (match_operand 0 "movsi_const0_operand")
       (match_test "!REG_P (op)")))
