/*
 * This file is part of functracer-postproc.
 *
 * Copyright (C) 2008 by Nokia Corporation
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef FTPRO_TRACE_FILE_H
#define FTPRO_TRACE_FILE_H

#include "maps.h"
#include "list.h"

/* header info structure */
typedef struct t_header {
	char version[10];
	char arch[LINE_MAX];
	int is_resolved;
} t_header;

/* trace file structure */
typedef struct t_trace_file {
	FILE *trace_file;
	t_header header;
	t_list list;
	t_maplist maplist;
} t_trace_file;

int read_trace_file (t_trace_file *trace_data);
t_address read_backtrace_lines(t_trace_file *trace_data, long offset,
			       char *line, size_t len);

void print_header_file (t_trace_file *trace_data);

#endif /* FTPRO_TRACE_FILE_H */
