/*
 * This file is part of functracer-postproc.
 *
 * Copyright (C) 2008 by Nokia Corporation
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef FTPRO_OPTIONS_H
#define FTPRO_OPTIONS_H

#include "maps.h"

/* reader buffer size */
#define BUFFER_SIZE 1024

/* argument data */
typedef struct t_arguments {
	char trace_file[LINE_MAX];
	int compress;
	int verbose;
	int resolve;
	int freed;
	int leak;
	int blocks;
	int size;
	int blocklimit;
} t_arguments;

extern t_arguments arguments;

int process_options (int argc, char *argv[]);

#endif /* FTPRO_OPTIONS_H */
