#include <glib.h>
#include <stdlib.h>

#include "stub_gwebengine.h"
#include "gwebcommon.h"


static void stub_g_web_engine_interface_init(GWebEngineIface* interface);
static void stub_g_web_engine_class_init(StubGWebEngineClass* klass);
static void stub_g_web_engine_init(StubGWebEngine* self);
static void stub_g_web_engine_finalize(GObject* object);
static void stub_g_web_engine_destroy(GWebEngine* self);

static void stub_g_web_engine_load_url(GWebEngine* self, const gchar* url);
static GWebStatus stub_g_web_engine_load_follow_link(GWebEngine* self, const gchar* url);
static GWebStatus stub_g_web_engine_load_url_with_css(
		GWebEngine* self,
		const gchar* url,
		const gchar* cssfile);
static void stub_g_web_engine_load_url_with_js(GWebEngine* self, gboolean enable);
static void stub_g_web_engine_load_home_page(GWebEngine* self);
static void stub_g_web_engine_stop_load(GWebEngine* self);
static void stub_g_web_engine_reload(GWebEngine* self);
static void stub_g_web_engine_go_back(GWebEngine* self, guint nsteps);
static void stub_g_web_engine_go_forward(GWebEngine* self, guint nsteps);
static gboolean stub_g_web_engine_can_go_back(GWebEngine* self);
static gboolean stub_g_web_engine_can_go_forward(GWebEngine* self);
static void stub_g_web_engine_zoom_by_steps(
		GWebEngine* self,
		guint relative_zoom,
		guint* legal_zoom_value);
static void stub_g_web_engine_new_zoom_by_steps(
		GWebEngine* self,
		gboolean up,
		guint* legal_zoom_value);
static void stub_g_web_engine_set_zoom_level(GWebEngine* self, gint level);
static GWebStatus stub_g_web_engine_set_zoom_level_around_point(
		GWebEngine* self,
		guint x,
		guint y,
		gint level);
static GWebStatus stub_g_web_engine_compare_frames_zoom_level(GWebEngine* self, gboolean* equal);
static GWebStatus stub_g_web_engine_get_image_properties(
		GWebEngine* self,
		const gchar* url,
		gchar** file_type,
		guint* file_size,
		guint* width,
		guint* height);
static GWebStatus stub_g_web_engine_get_frame_properties(
		GWebEngine* self,
		gchar** file_type,
		guint* file_size,
		GWebEngineEncoding* file_encoding,
		guint* security,
		gboolean* automatic_encoding);
static GWebStatus stub_g_web_engine_load_image(GWebEngine* self, const gchar* url);
static gint stub_g_web_engine_get_back_window_history_list(
		GWebEngine* self,
		GWebHistoryList** history);
static gint stub_g_web_engine_get_forward_window_history_list(
		GWebEngine* self,
		GWebHistoryList** history);
static guint stub_g_web_engine_get_zoom_level(GWebEngine* self);
static void stub_g_web_engine_set_frame_zoom_level(GWebEngine* self, guint level);
static guint stub_g_web_engine_get_frame_zoom_level(GWebEngine* self);
static void stub_g_web_engine_set_layout_mode(GWebEngine* self, GWebEngineLayoutMode mode);
static GWebEngineLayoutMode stub_g_web_engine_get_layout_mode(GWebEngine* self);
static void stub_g_web_engine_set_load_images(GWebEngine* self, GWebEngineImagePolicy level);
static GWebEngineImagePolicy stub_g_web_engine_get_load_images(GWebEngine* self);
static void stub_g_web_engine_set_frame_stacking(GWebEngine* self, gboolean enabled);
static gboolean stub_g_web_engine_get_frame_stacking(GWebEngine* self);
static GWebStatus stub_g_web_engine_save_web_page(
		GWebEngine* self,
		GWebEngineSaveAction setting,
		const gchar* file_name_with_path);
static GWebStatus stub_g_web_engine_save_current_frame(
		GWebEngine* self,
		GWebEngineSaveAction setting,
		const gchar* file_name_with_path);
static gchar* stub_g_web_engine_get_frame_title(GWebEngine* self, gint frame_number);
static gchar* stub_g_web_engine_get_element_details(GWebEngine* self, gint type);
static gint stub_g_web_engine_get_frame_number(GWebEngine* self);
static GWebStatus stub_g_web_engine_save_web_page_image(
		GWebEngine* self,
		const gchar* url,
		const gchar* directory);
static void stub_g_web_engine_select_all_text(GWebEngine* self);
static void stub_g_web_engine_set_language_encoding(GWebEngine* self, GWebEngineEncoding encoding);
static void stub_g_web_engine_set_frame_encoding(GWebEngine* self, GWebEngineEncoding encoding);
static gboolean stub_g_web_engine_find_text(
		GWebEngine* self,
		const gchar* string,
		gboolean reverse,
		gboolean whole_word,
		gboolean case_sensitive,
		gboolean restart);
static void stub_g_web_engine_authenticate(
		GWebEngine* self,
		gboolean ok,
		const gchar* username,
		const gchar* password);
static GWebStatus stub_g_web_engine_cut(GWebEngine* self);
static GWebStatus stub_g_web_engine_copy(GWebEngine* self);
static GWebStatus stub_g_web_engine_paste(GWebEngine* self);
static gboolean stub_g_web_engine_can_cut(GWebEngine* self);
static gboolean stub_g_web_engine_can_paste(GWebEngine* self);
static gboolean stub_g_web_engine_can_copy(GWebEngine* self);
static gboolean stub_g_web_engine_can_selecttext(GWebEngine* self);
static gchar* stub_g_web_engine_get_favicon_name(GWebEngine* self, const gchar* favicon_folder);
static GObject* stub_g_web_engine_get_engine_widget(GWebEngine* self);
static GObject* stub_g_web_engine_get_engine_notifier(GWebEngine* self);
static void stub_g_web_engine_set_open_link_mode(GWebEngine* self, gboolean in_new_window);
static GWebStatus stub_g_web_engine_set_true_zoom_mode(GWebEngine* self, gboolean status);
static void stub_g_web_engine_notify_plugins(GWebEngine* self, gint event);
static void stub_g_web_engine_preload_current_skin(GWebEngine* self);
static void stub_g_web_engine_invoke_selectmatch(GWebEngine* self);
static GArray *stub_g_web_engine_get_server_certificate(GWebEngine* self, gpointer context);
static gchar* stub_g_web_engine_get_page_verifier_name(GWebEngine* self);
static gboolean stub_g_web_engine_permit_page_unload(
		GWebEngine* self,
		glong time_sec,
		glong time_usec,
		glong timeout_usec);
static gboolean stub_g_web_engine_get_thumbnail(
		GWebEngine* self,
		const gchar* thumbnail_filename,
		gint width,
		gint height);
static gint stub_g_web_engine_get_text_zoom_level(GWebEngine* self);
static void stub_g_web_engine_set_text_zoom_level(GWebEngine* self, gint zoom_level);
static void stub_g_web_engine_enable_shistory_thumbnails(
		GWebEngine* self,
		gboolean enable,
		gint width,
		gint height);
static void stub_g_web_engine_update_area(
		GWebEngine* self,
		int id,
		int top,
		int left,
		int width,
		int height,
		int zoom);
static void stub_g_web_engine_send_mouse_event(
		GWebEngine* self,
		int type,
		int x,
		int y,
		int mod,
		int button,
		int clickcount,
		int time);

static GObjectClass* stub_g_web_engine_parent_class = NULL;


GType stub_g_web_engine_get_type(void)
{
	static GType stub_g_web_engine_type = 0;

	if (!stub_g_web_engine_type) {
		static const GTypeInfo stub_g_web_engine_info =
		{
			sizeof (StubGWebEngineClass),
			/* base_init */ NULL,
			/* base_finalize */ NULL,
			/* class_init */ (GClassInitFunc) stub_g_web_engine_class_init,
			/* class_finalize */ NULL,
			/* class_data */ NULL,
			sizeof(StubGWebEngine),
			/* n_preallocs */ 0,
			/* instance_init */ (GInstanceInitFunc) stub_g_web_engine_init
		};

		static const GInterfaceInfo interface_info =
		{
			(GInterfaceInitFunc)stub_g_web_engine_interface_init,
			/* interface_finalize */ NULL,
			/* interface_data */ NULL
		};

		stub_g_web_engine_type = g_type_register_static(
				G_TYPE_OBJECT,
				"StubGWebEngine",
				&stub_g_web_engine_info, 0);

		g_type_add_interface_static(
				stub_g_web_engine_type,
				G_TYPE_WEB_ENGINE,
				&interface_info);
	}

	return stub_g_web_engine_type;
}

static void stub_g_web_engine_interface_init(GWebEngineIface* iface)
{
	iface->destroy = (void (*) (GWebEngine*))
		stub_g_web_engine_destroy;

	iface->load_url = (void (*) (GWebEngine*, const char*))
		stub_g_web_engine_load_url;

	iface->load_follow_link = (GWebStatus (*) (GWebEngine*, const char*))
		stub_g_web_engine_load_follow_link;

	iface->load_url_with_css = (GWebStatus (*) (GWebEngine*, const gchar*, const gchar*))
		stub_g_web_engine_load_url_with_css;

	iface->load_url_with_js = (void (*) (GWebEngine*, gboolean))
		stub_g_web_engine_load_url_with_js;

	iface->load_home_page = (void (*) (GWebEngine*))
		stub_g_web_engine_load_home_page;

	iface->stop_load = (void (*) (GWebEngine*))
		stub_g_web_engine_stop_load;

	iface->reload = (void (*) (GWebEngine*))
		stub_g_web_engine_reload;

	iface->go_back = (void (*) (GWebEngine*, guint))
		stub_g_web_engine_go_back;

	iface->go_forward = (void (*) (GWebEngine*, guint))
		stub_g_web_engine_go_forward;

	iface->can_go_back = (gboolean (*) (GWebEngine*))
		stub_g_web_engine_can_go_back;

	iface->can_go_forward = (gboolean (*) (GWebEngine*))
		stub_g_web_engine_can_go_forward;

	iface->zoom_by_steps = (void (*) (GWebEngine*, guint, guint*))
		stub_g_web_engine_zoom_by_steps;

	iface->new_zoom_by_steps = (void (*) (GWebEngine*, gboolean, guint*))
		stub_g_web_engine_new_zoom_by_steps;

	iface->set_zoom_level = (void (*) (GWebEngine*, gint))
		stub_g_web_engine_set_zoom_level;

	iface->set_zoom_level_around_point = (GWebStatus (*) (GWebEngine*, guint, guint, gint))
		stub_g_web_engine_set_zoom_level_around_point;

	iface->compare_frames_zoom_level = (GWebStatus (*) (GWebEngine*, gboolean*))
		stub_g_web_engine_compare_frames_zoom_level;

	iface->get_image_properties =
		(GWebStatus (*) (GWebEngine*, const char*, gchar**, guint*, guint*, guint*))
		stub_g_web_engine_get_image_properties;

	iface->get_frame_properties =
		(GWebStatus (*) (GWebEngine*, gchar**, guint*, GWebEngineEncoding*, guint*, gboolean*))
		stub_g_web_engine_get_frame_properties;

	iface->load_image = (GWebStatus (*) (GWebEngine*, const gchar*))
		stub_g_web_engine_load_image;

	iface->get_back_window_history_list = (gint (*) (GWebEngine*, GWebHistoryList**))
		stub_g_web_engine_get_back_window_history_list;

	iface->get_forward_window_history_list = (gint (*) (GWebEngine*, GWebHistoryList**))
		stub_g_web_engine_get_forward_window_history_list;

	iface->get_zoom_level = (guint (*) (GWebEngine*))
		stub_g_web_engine_get_zoom_level;

	iface->set_frame_zoom_level = (void (*) (GWebEngine*, guint))
		stub_g_web_engine_set_frame_zoom_level;

	iface->get_frame_zoom_level = (guint (*) (GWebEngine*))
		stub_g_web_engine_get_frame_zoom_level;

	iface->set_layout_mode = (void (*) (GWebEngine*, GWebEngineLayoutMode))
		stub_g_web_engine_set_layout_mode;

	iface->get_layout_mode = (GWebEngineLayoutMode (*) (GWebEngine*))
		stub_g_web_engine_get_layout_mode;

	iface->set_load_images = (void (*) (GWebEngine*, GWebEngineImagePolicy))
		stub_g_web_engine_set_load_images;

	iface->get_load_images = (GWebEngineImagePolicy (*) (GWebEngine*))
		stub_g_web_engine_get_load_images;

	iface->set_frame_stacking = (void (*) (GWebEngine*, gboolean))
		stub_g_web_engine_set_frame_stacking;

	iface->get_frame_stacking = (gboolean (*) (GWebEngine*))
		stub_g_web_engine_get_frame_stacking;

	iface->save_web_page = (GWebStatus (*) (GWebEngine*, GWebEngineSaveAction, const gchar*))
		stub_g_web_engine_save_web_page;

	iface->save_current_frame = (GWebStatus (*) (GWebEngine*, GWebEngineSaveAction, const gchar*))
		stub_g_web_engine_save_current_frame;

	iface->get_frame_title = (gchar* (*) (GWebEngine*, gint))
		stub_g_web_engine_get_frame_title;

	iface->get_element_details = (gchar* (*) (GWebEngine*, gint))
		stub_g_web_engine_get_element_details;

	iface->get_frame_number = (gint (*) (GWebEngine*))
		stub_g_web_engine_get_frame_number;

	iface->save_web_page_image = (GWebStatus (*) (GWebEngine*, const gchar*, const gchar*))
		stub_g_web_engine_save_web_page_image;

	iface->select_all_text = (void (*) (GWebEngine*))
		stub_g_web_engine_select_all_text;

	iface->set_language_encoding = (void (*) (GWebEngine*, GWebEngineEncoding))
		stub_g_web_engine_set_language_encoding;

	iface->set_frame_encoding = (void (*) (GWebEngine*, GWebEngineEncoding))
		stub_g_web_engine_set_frame_encoding;

	iface->find_text =
		(gboolean (*) (GWebEngine*, const gchar*, gboolean, gboolean, gboolean, gboolean))
		stub_g_web_engine_find_text;

	iface->authenticate = (void (*) (GWebEngine*, gboolean, const gchar*, const gchar*))
		stub_g_web_engine_authenticate;

	iface->cut = (GWebStatus (*) (GWebEngine*))
		stub_g_web_engine_cut;

	iface->copy = (GWebStatus (*) (GWebEngine*))
		stub_g_web_engine_copy;

	iface->paste = (GWebStatus (*) (GWebEngine*))
		stub_g_web_engine_paste;

	iface->can_cut = (gboolean (*) (GWebEngine*))
		stub_g_web_engine_can_cut;

	iface->can_paste = (gboolean (*) (GWebEngine*))
		stub_g_web_engine_can_paste;

	iface->can_copy = (gboolean (*) (GWebEngine*))
		stub_g_web_engine_can_copy;

	iface->can_selecttext = (gboolean (*) (GWebEngine*))
		stub_g_web_engine_can_selecttext;

	iface->get_favicon_name = (gchar* (*) (GWebEngine*, const gchar*))
		stub_g_web_engine_get_favicon_name;

	iface->get_engine_widget = (GObject* (*) (GWebEngine*))
		stub_g_web_engine_get_engine_widget;

	iface->get_engine_notifier = (GObject* (*) (GWebEngine*))
		stub_g_web_engine_get_engine_notifier;

	iface->set_open_link_mode = (void (*) (GWebEngine*, gboolean))
		stub_g_web_engine_set_open_link_mode;

	iface->set_true_zoom_mode = (GWebStatus (*) (GWebEngine*, gboolean))
		stub_g_web_engine_set_true_zoom_mode;

	iface->notify_plugins = (void (*) (GWebEngine*, gint))
		stub_g_web_engine_notify_plugins;

	iface->preload_current_skin = (void (*) (GWebEngine*))
		stub_g_web_engine_preload_current_skin;

	iface->invoke_selectmatch = (void (*) (GWebEngine*))
		stub_g_web_engine_invoke_selectmatch;

	iface->get_server_certificate = (GArray* (*) (GWebEngine*, gpointer))
		stub_g_web_engine_get_server_certificate;

	iface->get_page_verifier_name = (char* (*) (GWebEngine*))
		stub_g_web_engine_get_page_verifier_name;

	iface->permit_page_unload = (gboolean (*) (GWebEngine*, glong, glong, glong))
		stub_g_web_engine_permit_page_unload;

	iface->get_thumbnail = (gboolean (*) (GWebEngine*, const gchar*, gint, gint))
		stub_g_web_engine_get_thumbnail;

	iface->get_text_zoom_level = (gint (*) (GWebEngine*))
		stub_g_web_engine_get_text_zoom_level;

	iface->set_text_zoom_level = (void (*) (GWebEngine*, gint))
		stub_g_web_engine_set_text_zoom_level;

	iface->enable_shistory_thumbnails = (void (*) (GWebEngine*, gboolean, gint, gint))
		stub_g_web_engine_enable_shistory_thumbnails;

	iface->update_area = (void (*) (GWebEngine*, int, int, int, int, int, int))
		stub_g_web_engine_update_area;

	iface->send_mouse_event = (gboolean (*) (GWebEngine*, int, int, int, int, int, int, int))
		stub_g_web_engine_send_mouse_event;
}

static void stub_g_web_engine_class_init(StubGWebEngineClass* klass)
{
	GObjectClass* object;
	stub_g_web_engine_parent_class = g_type_class_peek_parent(klass);
	object = G_OBJECT_CLASS(klass);
	object->finalize = stub_g_web_engine_finalize;
}

static void stub_g_web_engine_init(StubGWebEngine* self)
{}

static void stub_g_web_engine_finalize(GObject* object)
{
	StubGWebEngine* self = STUB_G_WEB_ENGINE(object);
	stub_g_web_engine_destroy(G_WEB_ENGINE(self));
}

GObject* stub_g_web_engine_new()
{
	GObject* instance = g_object_new(stub_g_web_engine_get_type(), NULL);
	return G_OBJECT(instance);
}

static void stub_g_web_engine_destroy(GWebEngine* self)
{}

static void stub_g_web_engine_load_url(GWebEngine* self, const gchar* url)
{}

static GWebStatus stub_g_web_engine_load_follow_link(GWebEngine* self, const gchar* url)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_engine_load_url_with_css(
		GWebEngine* self,
		const gchar* url,
		const gchar* cssfile)
{
	return G_WEB_STATUS_OK;
}

static void stub_g_web_engine_load_url_with_js(GWebEngine* self, gboolean enable)
{}

static void stub_g_web_engine_load_home_page(GWebEngine* self)
{}

static void stub_g_web_engine_stop_load(GWebEngine* self)
{}

static void stub_g_web_engine_reload(GWebEngine* self)
{}

static void stub_g_web_engine_go_back(GWebEngine* self, guint nsteps)
{}

static void stub_g_web_engine_go_forward(GWebEngine* self, guint nsteps)
{}

static gboolean stub_g_web_engine_can_go_back(GWebEngine* self)
{
	return TRUE;
}

static gboolean stub_g_web_engine_can_go_forward(GWebEngine* self)
{
	return TRUE;
}

static void stub_g_web_engine_zoom_by_steps(
		GWebEngine* self,
		guint relative_zoom,
		guint* legal_zoom_value)
{}

static void stub_g_web_engine_new_zoom_by_steps(
		GWebEngine* self,
		gboolean up,
		guint* legal_zoom_value)
{}

static void stub_g_web_engine_set_zoom_level(GWebEngine* self, gint level)
{}

static GWebStatus stub_g_web_engine_set_zoom_level_around_point(
		GWebEngine* self,
		guint x,
		guint y,
		gint level)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_engine_compare_frames_zoom_level(GWebEngine* self, gboolean* equal)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_engine_get_image_properties(
		GWebEngine* self,
		const gchar* url,
		gchar** file_type,
		guint* file_size,
		guint* width,
		guint* height)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_engine_get_frame_properties(
		GWebEngine* self,
		gchar** file_type,
		guint* file_size,
		GWebEngineEncoding* file_encoding,
		guint* security,
		gboolean* automatic_encoding)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_engine_load_image(GWebEngine* self, const gchar* url)
{
	return G_WEB_STATUS_OK;
}

static gint stub_g_web_engine_get_back_window_history_list(
		GWebEngine* self,
		GWebHistoryList** history)
{
	return 0;
}

static gint stub_g_web_engine_get_forward_window_history_list(
		GWebEngine* self,
		GWebHistoryList** history)
{
	return 0;
}

static guint stub_g_web_engine_get_zoom_level(GWebEngine* self)
{
	return 0;
}

static void stub_g_web_engine_set_frame_zoom_level(GWebEngine* self, guint level)
{}

static guint stub_g_web_engine_get_frame_zoom_level(GWebEngine* self)
{
	return 0;
}

static void stub_g_web_engine_set_layout_mode(GWebEngine* self, GWebEngineLayoutMode mode)
{}

static GWebEngineLayoutMode stub_g_web_engine_get_layout_mode(GWebEngine* self)
{
	return G_WEBENGINE_LAYOUT_NORMAL;
}

static void stub_g_web_engine_set_load_images(GWebEngine* self, GWebEngineImagePolicy level)
{}

static GWebEngineImagePolicy stub_g_web_engine_get_load_images(GWebEngine* self)
{
	return G_WEBENGINE_POLICY_NO_IMAGES;
}

static void stub_g_web_engine_set_frame_stacking(GWebEngine* self, gboolean enabled)
{}

static gboolean stub_g_web_engine_get_frame_stacking(GWebEngine* self)
{
	return TRUE;
}

static GWebStatus stub_g_web_engine_save_web_page(
		GWebEngine* self,
		GWebEngineSaveAction setting,
		const gchar* file_name_with_path)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_engine_save_current_frame(
		GWebEngine* self,
		GWebEngineSaveAction setting,
		const gchar* file_name_with_path)
{
	return G_WEB_STATUS_OK;
}

static gchar* stub_g_web_engine_get_frame_title(GWebEngine* self, gint frame_number)
{
	return NULL;
}

static gchar* stub_g_web_engine_get_element_details(GWebEngine* self, gint type)
{
	return NULL;
}

static gint stub_g_web_engine_get_frame_number(GWebEngine* self)
{
	return 0;
}

static GWebStatus stub_g_web_engine_save_web_page_image(
		GWebEngine* self,
		const gchar* url,
		const gchar* directory)
{
	return G_WEB_STATUS_OK;
}

static void stub_g_web_engine_select_all_text(GWebEngine* self)
{}

static void stub_g_web_engine_set_language_encoding(GWebEngine* self, GWebEngineEncoding encoding)
{}

static void stub_g_web_engine_set_frame_encoding(GWebEngine* self, GWebEngineEncoding encoding)
{}

static gboolean stub_g_web_engine_find_text(
		GWebEngine* self,
		const gchar* string,
		gboolean reverse,
		gboolean whole_word,
		gboolean case_sensitive,
		gboolean restart)
{
	return TRUE;
}

static void stub_g_web_engine_authenticate(
		GWebEngine* self,
		gboolean ok,
		const gchar* username,
		const gchar* password)
{}

static GWebStatus stub_g_web_engine_cut(GWebEngine* self)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_engine_copy(GWebEngine* self)
{
	return G_WEB_STATUS_OK;
}

static GWebStatus stub_g_web_engine_paste(GWebEngine* self)
{
	return G_WEB_STATUS_OK;
}

static gboolean stub_g_web_engine_can_cut(GWebEngine* self)
{
	return TRUE;
}

static gboolean stub_g_web_engine_can_paste(GWebEngine* self)
{
	return TRUE;
}

static gboolean stub_g_web_engine_can_copy(GWebEngine* self)
{
	return TRUE;
}

static gboolean stub_g_web_engine_can_selecttext(GWebEngine* self)
{
	return TRUE;
}

static gchar* stub_g_web_engine_get_favicon_name(GWebEngine* self, const gchar* favicon_folder)
{
	return NULL;
}

static GObject* stub_g_web_engine_get_engine_widget(GWebEngine* self)
{
	return NULL;
}

static GObject* stub_g_web_engine_get_engine_notifier(GWebEngine* self)
{
	return NULL;
}

static void stub_g_web_engine_set_open_link_mode(GWebEngine* self, gboolean in_new_window)
{}

static GWebStatus stub_g_web_engine_set_true_zoom_mode(GWebEngine* self, gboolean status)
{
	return G_WEB_STATUS_OK;
}

static void stub_g_web_engine_notify_plugins(GWebEngine* self, gint event)
{}

static void stub_g_web_engine_preload_current_skin(GWebEngine* self)
{}

static void stub_g_web_engine_invoke_selectmatch(GWebEngine* self)
{}

static GArray* stub_g_web_engine_get_server_certificate(GWebEngine* self, gpointer context)
{
	return NULL;
}

static gchar* stub_g_web_engine_get_page_verifier_name(GWebEngine* self)
{
	return NULL;
}

static gboolean stub_g_web_engine_permit_page_unload(
		GWebEngine* self,
		glong time_sec,
		glong time_usec,
		glong timeout_usec)
{
	return TRUE;
}

static gboolean stub_g_web_engine_get_thumbnail(
		GWebEngine* self,
		const gchar* thumbnail_filename,
		gint width,
		gint height)
{
	return TRUE;
}

static gint stub_g_web_engine_get_text_zoom_level(GWebEngine* self)
{
	return 0;
}

static void stub_g_web_engine_set_text_zoom_level(GWebEngine* self, gint zoom_level)
{}

static void stub_g_web_engine_enable_shistory_thumbnails(
		GWebEngine* self,
		gboolean enable,
		gint width,
		gint height)
{}

static void stub_g_web_engine_update_area(
		GWebEngine* self,
		int id,
		int top,
		int left,
		int width,
		int height,
		int zoom)
{}

static void stub_g_web_engine_send_mouse_event(
		GWebEngine* self,
		int type,
		int x,
		int y,
		int mod,
		int button,
		int clickcount,
		int time)
{}
