#include <check.h>
#include "testing.h"
#include <glib-object.h>

#include "gwebpluginlist.h"
#include "stub_gwebpluginlist.h"

static GWebPluginList* self;
static gboolean destroyed_flag;


static void destroy_notify(gpointer user_data, GObject* where_object_was)
{
	destroyed_flag = TRUE;
}

void setup_gwebpluginlist(void)
{
	g_type_init();
	self = G_WEB_PLUGIN_LIST(stub_g_web_plugin_list_new());
	fail_if(self == NULL, "failed to create object");
	destroyed_flag = FALSE;
}

void teardown_gwebpluginlist(void)
{
	g_object_weak_ref(G_OBJECT(self), destroy_notify, NULL);

	g_object_unref(G_OBJECT(self));
	//run_main_loop(DEFAULT_MAIN_LOOP_RUN_TIME);

	//fail_unless(destroyed_flag, "failed to destroy object");

	self = NULL;
	destroyed_flag = FALSE;
}

START_TEST(test_g_web_plugin_list_destroy)
{
	g_web_plugin_list_destroy(self);
}
END_TEST

START_TEST(test_g_web_plugin_list_get_items)
{
	GObject* ret;

	ret = g_web_plugin_list_get_items(self);
}
END_TEST

START_TEST(test_g_web_plugin_list_get_items_count)
{
	gint ret;

	ret = g_web_plugin_list_get_items_count(self);
}
END_TEST

START_TEST(test_g_web_plugin_list_get_item_title)
{
	gchar* ret;
	gint pos;

	pos = 0;

	ret = g_web_plugin_list_get_item_title(self, pos);
}
END_TEST

START_TEST(test_g_web_plugin_list_get_item_creator)
{
	gchar* ret;
	gint pos;

	pos = 0;

	ret = g_web_plugin_list_get_item_creator(self, pos);
}
END_TEST

START_TEST(test_g_web_plugin_list_get_item_path)
{
	gchar* ret;
	gint pos;

	pos = 0;

	ret = g_web_plugin_list_get_item_path(self, pos);
}
END_TEST

START_TEST(test_g_web_plugin_list_get_item_type)
{
	gchar* ret;
	gint pos;

	pos = 0;

	ret = g_web_plugin_list_get_item_type(self, pos);
}
END_TEST

START_TEST(test_g_web_plugin_list_get_item_ctype)
{
	guint ret;
	gint pos;

	pos = 0;

	ret = g_web_plugin_list_get_item_ctype(self, pos);
}
END_TEST

START_TEST(test_g_web_plugin_list_get_item_state)
{
	guint ret;
	gint pos;

	pos = 0;

	ret = g_web_plugin_list_get_item_state(self, pos);
}
END_TEST

Suite* create_gwebpluginlist_suite(void)
{
	Suite* s = suite_create("gwebpluginlist");

	TCase* tc = tcase_create("tests");
	tcase_add_checked_fixture(tc, setup_gwebpluginlist, teardown_gwebpluginlist);
	tcase_add_test(tc, test_g_web_plugin_list_destroy);
	tcase_add_test(tc, test_g_web_plugin_list_get_items);
	tcase_add_test(tc, test_g_web_plugin_list_get_items_count);
	tcase_add_test(tc, test_g_web_plugin_list_get_item_title);
	tcase_add_test(tc, test_g_web_plugin_list_get_item_creator);
	tcase_add_test(tc, test_g_web_plugin_list_get_item_path);
	tcase_add_test(tc, test_g_web_plugin_list_get_item_type);
	tcase_add_test(tc, test_g_web_plugin_list_get_item_ctype);
	tcase_add_test(tc, test_g_web_plugin_list_get_item_state);
	suite_add_tcase(s, tc);

	return s;
}
