/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <glib-object.h>

#ifndef __GWEBPLUGINLIST_H__
#define __GWEBPLUGINLIST_H__

G_BEGIN_DECLS

/** GWebPluginList
  */

#define G_TYPE_WEB_PLUGIN_LIST             (g_web_plugin_list_get_type ())
#define G_WEB_PLUGIN_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_WEB_PLUGIN_LIST, GWebPluginList))
#define G_WEB_PLUGIN_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_WEB_PLUGIN_LIST, GWebPluginListIface))
#define G_IS_WEB_PLUGIN_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_WEB_PLUGIN_LIST))
#define G_IS_WEB_PLUGIN_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_WEB_PLUGIN_LIST))
#define G_WEB_PLUGIN_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_WEB_PLUGIN_LIST, GWebPluginListIface))

typedef struct _GWebPluginList GWebPluginList; /* dummy object */
typedef struct _GWebPluginListIface GWebPluginListIface;

/** @struct GWebPluginListIface.
  * Defines web plugin list interface.
  */
struct _GWebPluginListIface {
	GTypeInterface parent;

	void (*destroy) (GWebPluginList *self);
	GObject* (*get_items) (GWebPluginList *self);
	gint (*get_items_count) (GWebPluginList *self);
	gchar* (*get_item_title) (GWebPluginList *self, gint pos);
	gchar* (*get_item_creator) (GWebPluginList *self, gint pos);
	gchar* (*get_item_path) (GWebPluginList *self, gint pos);
	gchar* (*get_item_type) (GWebPluginList *self, gint pos);
	guint (*get_item_state) (GWebPluginList *self, gint pos);
	guint (*get_item_ctype) (GWebPluginList *self, gint pos);
};

GType g_web_plugin_list_get_type (void);

void g_web_plugin_list_destroy (GWebPluginList *self);
GObject* g_web_plugin_list_get_items (GWebPluginList *self);
gint g_web_plugin_list_get_items_count (GWebPluginList *self);
gchar* g_web_plugin_list_get_item_title (GWebPluginList *self, gint pos);
gchar* g_web_plugin_list_get_item_creator (GWebPluginList *self, gint pos);
gchar* g_web_plugin_list_get_item_path (GWebPluginList *self, gint pos);
gchar* g_web_plugin_list_get_item_type (GWebPluginList *self, gint pos);
guint g_web_plugin_list_get_item_ctype (GWebPluginList *self, gint pos);
guint g_web_plugin_list_get_item_state (GWebPluginList *self, gint pos);

G_END_DECLS

#endif /* __GWEBPLUGINLIST_H__ */
