/**
	@file settings.h

	File implementing the user interface for RSS Feed Reader Settings

	Copyright (c) 2004-2007 Nokia Corporation.
	Parts of code are from Liferea.
	Liferea (C) 2003,2004 Lars Lindner <lars.lindner@gmx.net>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License 
	version 2 or later, as published by the Free Software Foundation. 

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
	02110-1301 USA	
*/

#ifndef __RSS_SETTINGS_H__
#define __RSS_SETTINGS_H__

#include <gtk/gtk.h>
#include <libosso.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#ifdef __cplusplus 
extern "C" { 
#endif

#define RSS_SETTINGS "/apps/osso/rss-feed-reader"
#define RSS_SETTINGS_REUSE_BROWSER_WINDOW "/apps/osso/rss-feed-reader/reuse-browser-window"
#define RSS_SETTINGS_NEWEST_POSTS_FIRST "/apps/osso/rss-feed-reader/item-sort-order"
#define RSS_SETTINGS_SORT_KEY "/apps/osso/rss-feed-reader/item-sort-key"
#define RSS_SETTINGS_SORT_ORDER "/apps/osso/rss-feed-reader/item-sort-order"
#define RSS_SETTINGS_AUTOMATIC_UPDATES "/apps/osso/rss-feed-reader/automatic-update"
#define RSS_SETTINGS_AUTOMATIC_UPDATES_INTERVAL "/apps/osso/rss-feed-reader/update-interval"
#define RSS_SETTINGS_AUTOMATIC_UPDATES_TYPE "/apps/osso/rss-feed-reader/update-type"
#define RSS_SETTINGS_IMAGE_CACHE_DIR "/apps/osso/rss-feed-reader/image-cache"
#define RSS_SETTINGS_IMAGE_CACHE_SIZE "/apps/osso/rss-feed-reader/image-cache-size"
#define RSS_SETTINGS_AUTOMATIC_SCROLLING "/apps/osso/rss-feed-reader/automatic-scrolling"
#define RSS_SETTINGS_OPEN_FEEDS_TO "/apps/osso/rss-feed-reader/open-feeds-to"

/* browsing settings */
#define BROWSE_INSIDE_APPLICATION	"/apps/osso/rss-feed-reader/browse-inside-application"
#define BROWSE_KEY_SETTING		"/apps/osso/rss-feed-reader/browse-key-setting"
#define BROWSER_ID			"/apps/osso/rss-feed-reader/browser_id"
#define BROWSER_PLACE			"/apps/osso/rss-feed-reader/browser_place"
#define BROWSER_COMMAND			"/apps/osso/rss-feed-reader/browser"
#define BROWSER_MODULE			"/apps/osso/rss-feed-reader/browser-module"
#define GNOME_DEFAULT_BROWSER_COMMAND	"gnome-open '%s'"
#define DEFAULT_BROWSER_COMMAND		"mozilla '%s'"
#define DEFAULT_FONT			"/desktop/gnome/interface/font_name"
#define USER_FONT			"/apps/osso/rss-feed-reader/browser-font"

/* item list settings */
#define TIME_FORMAT			"/apps/osso/rss-feed-reader/timeformat"
#define TIME_FORMAT_MODE		"/apps/osso/rss-feed-reader/timeformatmode"

/* feed handling settings */
#define STARTUP_FEED_ACTION		"/apps/osso/rss-feed-reader/startup_feed_action"
#define UPDATE_THREAD_CONCURRENCY	"/apps/osso/rss-feed-reader/update-thread-concurrency"
#define KEEP_FEEDS_IN_MEMORY		"/apps/osso/rss-feed-reader/keep-feeds-in-memory"
#define DISABLE_SUBSCRIPTION_PIPE	"/apps/osso/rss-feed-reader/disable-subscription-pipe"

/* GUI settings and persistency values */
#define SHOW_TRAY_ICON			"/apps/osso/rss-feed-reader/trayicon"
#define SHOW_POPUP_WINDOWS		"/apps/osso/rss-feed-reader/show-popup-windows"
#define DISABLE_MENUBAR			"/apps/osso/rss-feed-reader/disable-menubar"
#define DISABLE_TOOLBAR			"/apps/osso/rss-feed-reader/disable-toolbar"
#define DISABLE_TOOLBAR_FULLSCREEN      "/apps/osso/rss-feed-reader/disable-toolbar-fullscreen"
#define ENABLE_FIND_ON_PAGE             "/apps/osso/rss-feed-reader/enable-find-on-page" 
#define LAST_WINDOW_X			"/apps/osso/rss-feed-reader/last-window-x"
#define LAST_WINDOW_Y			"/apps/osso/rss-feed-reader/last-window-y"
#define LAST_WINDOW_WIDTH		"/apps/osso/rss-feed-reader/last-window-width"
#define LAST_WINDOW_HEIGHT		"/apps/osso/rss-feed-reader/last-window-height"
#define LAST_WINDOW_MAXIMIZED		"/apps/osso/rss-feed-reader/last-window-maximized"
#define LAST_VPANE_POS			"/apps/osso/rss-feed-reader/last-vpane-pos"
#define LAST_HPANE_POS			"/apps/osso/rss-feed-reader/last-hpane-pos"
#define LAST_ITEMLIST_MODE		"/apps/osso/rss-feed-reader/last-itemlist-mode"
#define LAST_ZOOMLEVEL			"/apps/osso/rss-feed-reader/last-zoomlevel"
#define LAST_SHOWFOLDERS		"/apps/osso/rss-feed-reader/last-showfolders"
#define START_FIRST_TIME                "/apps/osso/rss-feed-reader/start-first-time"
#define ZOOM_LEVEL                "/apps/osso/rss-feed-reader/zoom-level"
#define REFRESH_STATE           "/apps/osso/rss-feed-reader/refresh-state"
    
/* networking settings */
#define USE_PROXY			"/system/http_proxy/use_http_proxy"
#define PROXY_HOST			"/system/http_proxy/host"
#define PROXY_PORT			"/system/http_proxy/port"
#define PROXY_USEAUTH			"/system/http_proxy/use_authentication"
#define PROXY_USER			"/system/http_proxy/authentication_user"
#define PROXY_PASSWD			"/system/http_proxy/authentication_password"

extern const gint all_cache_size[];
extern const gint all_autoupdate_time[];

#define MAX_UPDATE_INTERVAL 5
#define RSS_AUTO_UPDATE_DEFAULT_INT 1

gint find_cache_size(gint cacheSizeConf);
gboolean execute_rss_settings(osso_context_t *osso, gpointer window, gboolean modal, gboolean executed_from_applet);
void close_rss_settings();
void setup_alarm_event(gboolean replace);
gboolean setup_alarm_event_now(gboolean replace);
void conf_reset_default_values(GConfClient* conf);
gboolean is_first_time_run(GConfClient* conf);
void config_check_first_time(GConfClient* conf);
gint _setup_alarm_timeout(gpointer data);

#ifdef __cplusplus 
}
#endif
#endif /* __RSS_SETTINGS_H__ */
/*
#define ULOG_ERR(args...) do { \
        FILE *bla; \
        bla=fopen("/tmp/rss.txt","a+"); \
        (fprintf(bla, "[rss-lib]: "), fprintf (bla, args)); fprintf (bla, "\n");\
        fflush(bla); \
        fclose(bla); \
} while (0)
*/
