/**
	@file callbacks.h

	Various callbacks for dealing with the GUI events in RSS Feed Reader Settings

	Copyright (c) 2004-2007 Nokia Corporation.
	Parts of code are from Liferea.
	Liferea (C) 2003,2004 Lars Lindner <lars.lindner@gmx.net>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License 
	version 2 or later, as published by the Free Software Foundation. 

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
	02110-1301 USA	
*/

#ifndef __CALLBACKS_H__
#define __CALLBACKS_H__

#include <glib.h>
#include <gtk/gtk.h>

#ifdef __cplusplus 
extern "C" { 
#endif

void combobox_changed(GtkWidget *widget, gpointer user_data);

void checkbox_toggled(GtkToggleButton* togglebutton, gpointer user_data);

void on_dialog_response(GtkWidget * prefdialog, gint responseId,
        gpointer user_data);
    

/**
        Callback for handling a key event in the dialog.

        @param widget           Main dialog emitting the key event.
        @param event            Structure representing the key event.
        @param user_data        NULL
        @return TRUE, if event was handled by this handler
*/
gboolean dialog_key_press(GtkWidget* widget,
                          GdkEventKey* event,
                          gpointer user_data);


#ifdef __cplusplus 
}
#endif
#endif /* __CALLBACKS_H__ */
