/**
 * @file favicon_cache.h Liferea favicon handling
 * 
 * Copyright (C) 2004 Nathan J. Conrad <t98502@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _RSSLIB_FAVICON__H
#define _RSSLIB_FAVICON__H

G_BEGIN_DECLS

/** Loads a favicon for the given feed
  *
  * @param fp a pointer to a feed
  */
GdkPixbuf *rsslib_favicon_load(gchar *filename_id);

/** Removes a favicon from the cache
  *
  * @param fp a pointer to a feed
  */
void rsslib_favicon_remove(gchar *filename_id);

G_END_DECLS

#endif
