/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=4 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"
#include "gmozillapassman.h"
#include "gtkmozembed_common.h"

static GWebStatus
g_mozilla_password_manager_get_login_username (GMozillaPasswordManager *self, gchar **username)
{
    TRACE_LOG();
    GtkMozLogin* login = (GtkMozLogin*)self->login;
    if (!login)
      return G_WEB_ERR;
    *username = g_strdup(login->user);
    return G_WEB_STATUS_OK;
}

static GWebStatus
g_mozilla_password_manager_get_login_password (GMozillaPasswordManager *self, gchar **password)
{
    TRACE_LOG();
    GtkMozLogin* login = (GtkMozLogin*)self->login;
    if (!login)
      return G_WEB_ERR;
    *password = g_strdup(login->pass);
    return G_WEB_STATUS_OK;
}

static GObject*
g_mozilla_password_manager_login_get_personal_data (GMozillaPasswordManager *self)
{
    TRACE_LOG();
    return G_MOZILLA_PASSWORD_MANAGER(self)->login;
}

static void
g_mozilla_password_manager_instance_init (GTypeInstance *instance, gpointer  g_class)
{
    TRACE_LOG();
    G_MOZILLA_PASSWORD_MANAGER(instance)->login = NULL;
}

static void
g_mozilla_password_manager_interface_init (GWebPasswordManagerIface *iface)
{
    TRACE_LOG();
    iface->get_login_username = (GWebStatus (*) (GWebPasswordManager*, gchar**))
                                g_mozilla_password_manager_get_login_username;
    iface->get_login_password = (GWebStatus (*) (GWebPasswordManager*, gchar**))
                                g_mozilla_password_manager_get_login_password;
    iface->login_get_personal_data = (GObject* (*) (GWebPasswordManager*))
                                     g_mozilla_password_manager_login_get_personal_data;
}


GType
g_mozilla_password_manager_get_type (void)
{
    static GType type = 0;
    if (type == 0)
    {
        static const GTypeInfo info =
            {
                sizeof (GMozillaPasswordManagerClass),
                NULL,   /* base_init */
                NULL,   /* base_finalize */
                NULL,   /* class_init */
                NULL,   /* class_finalize */
                NULL,   /* class_data */
                sizeof (GMozillaPasswordManager),
                0,      /* n_preallocs */
                g_mozilla_password_manager_instance_init    /* instance_init */
            };
        static const GInterfaceInfo iface_info =
            {
                (GInterfaceInitFunc) g_mozilla_password_manager_interface_init,
                NULL,   /* interface_finalize */
                NULL    /* interface_data */
            };
        type = g_type_register_static (G_TYPE_OBJECT,
                                       "GMozillaPasswordManager",
                                       &info, 0);
        g_type_add_interface_static (type,
                                     G_TYPE_WEB_PASSWORD_MANAGER,
                                     &iface_info);
    }
    return type;
}

GObject*
g_mozilla_password_manager_login_new (const gchar* server, gint index, GList * logins_list)
{
    TRACE_LOG();
    GObject* instance = G_OBJECT(g_object_new(g_mozilla_password_manager_get_type(), NULL)); //FIXME XXX MEMLEAK
    G_MOZILLA_PASSWORD_MANAGER(instance)->login = g_list_nth_data(logins_list, index);
    G_MOZILLA_PASSWORD_MANAGER(instance)->index = index;
    return instance;
}
