/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=4 sts=2 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"
#include "gmozillahistorylist.h"

/* GMozillaHistoryList */


int
g_mozilla_history_list_clear_all ()
{
    return gtk_moz_embed_common_remove_history (NULL, 0);
}


typedef struct _GtkWebHistoryItem GtkWebHistoryItem;

/** @struct GtkWebHistoryItem.
  * Defines a web history item.
  */
struct _GtkWebHistoryItem
{
    gchar *title;    /** < URL title */
    gchar *url;      /** < URL */
    long accessed;   /** < The last time that the URL was accessed */
};


static void
g_mozilla_history_list_delete_item (GMozillaHistoryList *self, gint pos)
{
    TRACE_LOG();
    gchar * url = ((GtkMozHistoryItem*)G_MOZILLA_HISTORY_LIST(self)->items)[pos].url;
    gtk_moz_embed_common_remove_history(url, 0);
    return ;
}

static GObject*
g_mozilla_history_list_get_items (GMozillaHistoryList *self)
{
    TRACE_LOG();
    return G_MOZILLA_HISTORY_LIST(self)->items;
}

static gint
g_mozilla_history_list_get_items_count (GMozillaHistoryList *self)
{
    TRACE_LOG();
    return G_MOZILLA_HISTORY_LIST(self)->num_items;
}

static gboolean
g_mozilla_history_list_position_ok (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    return (G_MOZILLA_HISTORY_LIST(self)->items &&
            pos >= 0 &&
            pos < G_MOZILLA_HISTORY_LIST(self)->num_items);
}

static const gchar*
g_mozilla_history_list_get_item_title (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    if (g_mozilla_history_list_position_ok(self, pos)) {
	return ((GtkMozHistoryItem*)G_MOZILLA_HISTORY_LIST(self)->items)[pos].title;
    }
    return NULL;
}

static const gchar*
g_mozilla_history_list_get_item_url (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    if (g_mozilla_history_list_position_ok(self, pos)) {
	return ((GtkMozHistoryItem*)G_MOZILLA_HISTORY_LIST(self)->items)[pos].url;
    }
    return NULL;
}

static GTime
g_mozilla_history_list_get_item_time (GWebHistoryList *self, gint pos)
{
    TRACE_LOG();
    if (g_mozilla_history_list_position_ok(self, pos)) {
	return ((GtkMozHistoryItem*)G_MOZILLA_HISTORY_LIST(self)->items)[pos].accessed;
    }
    return 0;
}

static void
g_mozilla_history_list_destroy (GMozillaHistoryList *self)
{
    TRACE_LOG();
    gint index;
    if(self->isSHistory) {
      for(index = 0; index < self->num_items; index++) {
        gchar *url = (gchar *) g_mozilla_history_list_get_item_url((GWebHistoryList *)self, index);
        gchar *title = (gchar *) g_mozilla_history_list_get_item_title((GWebHistoryList *)self, index);
        EAL_IF_GFREE(url);
        EAL_IF_GFREE(title);
      }
    }
    g_free((GtkMozHistoryItem*)G_MOZILLA_HISTORY_LIST(self)->items);
}

static void
g_mozilla_history_list_interface_init (GWebHistoryListIface *iface)
{
    TRACE_LOG();
    iface->destroy         = (void (*) (GWebHistoryList*))
                             g_mozilla_history_list_destroy;
    iface->delete_item     = (void (*) (GWebHistoryList*, GObject*))
                             g_mozilla_history_list_delete_item;
    iface->get_items       = (GObject* (*) (GWebHistoryList*))
                             g_mozilla_history_list_get_items;
    iface->get_items_count = (gint (*) (GWebHistoryList*))
                             g_mozilla_history_list_get_items_count;
    iface->get_item_title  = (const gchar* (*) (GWebHistoryList*, gint))
                             g_mozilla_history_list_get_item_title;
    iface->get_item_url    = (const gchar* (*) (GWebHistoryList*, gint))
                             g_mozilla_history_list_get_item_url;
    iface->get_item_time   = (GTime (*) (GWebHistoryList*, gint))
                             g_mozilla_history_list_get_item_time;
}

static void
g_mozilla_history_list_instance_init (GTypeInstance *instance, gpointer  g_class)
{
    TRACE_LOG();
    G_MOZILLA_HISTORY_LIST(instance)->items     = NULL;
    G_MOZILLA_HISTORY_LIST(instance)->num_items = 0;
}

GType
g_mozilla_history_list_get_type (void)
{
    static GType type = 0;
    if (type == 0)
    {
        static const GTypeInfo info =
            {
                sizeof (GMozillaHistoryListClass),
                NULL,   /* base_init */
                NULL,   /* base_finalize */
                NULL,   /* class_init */
                NULL,   /* class_finalize */
                NULL,   /* class_data */
                sizeof (GMozillaHistoryList),
                0,      /* n_preallocs */
                g_mozilla_history_list_instance_init    /* instance_init */
            };
        static const GInterfaceInfo iface_info =
            {
                (GInterfaceInitFunc) g_mozilla_history_list_interface_init,
                NULL,   /* interface_finalize */
                NULL    /* interface_data */
            };
        type = g_type_register_static (G_TYPE_OBJECT,
                                       "GMozillaHistoryList",
                                       &info, 0);
        g_type_add_interface_static (type,
                                     G_TYPE_WEB_HISTORY_LIST,
                                     &iface_info);
    }
    return type;
}

GObject*
g_mozilla_history_list_new (void)
{
    TRACE_LOG();
    GObject* instance = G_OBJECT(g_object_new(g_mozilla_history_list_get_type(), NULL));
    G_MOZILLA_HISTORY_LIST(instance)->isSHistory = FALSE;
    G_MOZILLA_HISTORY_LIST(instance)->num_items = gtk_moz_embed_common_get_history_list((GtkMozHistoryItem**)&G_MOZILLA_HISTORY_LIST(instance)->items);
    return G_OBJECT(instance);
}
