/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the MICROB EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Oleg Romashin <oleg.romashin@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include <gwebhistorylist.h>
#include <gtkmozembed_common.h>

#ifndef __GMOZILLAHISTORYLIST_H__
#define __GMOZILLAHISTORYLIST_H__

G_BEGIN_DECLS

/* GMozillaHistoryList */
#define G_TYPE_MOZILLA_HISTORY_LIST             (g_mozilla_history_list_get_type ())
#define G_MOZILLA_HISTORY_LIST(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_MOZILLA_HISTORY_LIST, GMozillaHistoryList))
#define G_MOZILLA_HISTORY_LIST_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), G_TYPE_MOZILLA_HISTORY_LIST, GMozillaHistoryListClass))
#define G_IS_MOZILLA_HISTORY_LIST(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_MOZILLA_HISTORY_LIST))
#define G_IS_MOZILLA_HISTORY_LIST_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), G_TYPE_MOZILLA_HISTORY_LIST))
#define G_MOZILLA_HISTORY_LIST_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), G_TYPE_MOZILLA_HISTORY_LIST, GMozillaHistoryListClass))

typedef struct _GMozillaHistoryList GMozillaHistoryList;
typedef struct _GMozillaHistoryListClass GMozillaHistoryListClass;

/** @struct GMozillaHistoryList.
  * Defines a Mozilla History List.
  */
struct _GMozillaHistoryList
{
    GObject parent;   /** < The object parent */
    GObject *items;   /** < The object items */
    gint num_items;   /** < Number of items */
    gboolean isSHistory; /** < Session history or Global history */ 
};

/** @struct GMozillaHistoryListClass.
  * Defines a Mozilla History List Class.
  */
struct _GMozillaHistoryListClass
{
    GObjectClass parent;  /** < Object class parent */
};

GType g_mozilla_history_list_get_type (void);

/** Clears the history list
  * @return 0 on the success.
  */
int g_mozilla_history_list_clear_all ();

/** Creates a new history list
  * @return A history list.
  */
GObject* g_mozilla_history_list_new (void);

G_END_DECLS

#endif /* __GMOZILLAHISTORYLIST_H__ */
