/* $Id: test4.c 11432 2007-05-23 11:37:23Z jlaako $ */

/*

    Shared memory object for POSIX/IEEE-1003.1 compliant systems.

    Copyright (C) 2005-2007 Nokia Corporation.

    Contact: Jussi Laako <jussi.laako@nokia.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#include <stdio.h>
#include <string.h>

#include "sharedmem.h"


typedef struct _test_t
{
    unsigned int u1;
    unsigned int u2;
    unsigned int u3;
    unsigned int u4;
    unsigned long long ull1;
    unsigned long long ull2;
} test_t;


int main (int argc, char *argv[])
{
    unsigned int i;
    test_t *t;
    sharedmem_t shm;

    if (sharedmem_create(&shm, "/test4.shm", 1024 * sizeof(test_t)) != 0)
    {
        puts(sharedmem_get_error_string(&shm));
        return 1;
    }
    t = (test_t *) SHAREDMEM_PTR(&shm);
    memset(t, 0x00, 1024 * sizeof(test_t));
    
    for (i = 0; i < 1024; i++)
    {
        t[i].u1 = i;
        t[i].u2 = t[i].u1 + 1;
        t[i].u3 = t[i].u2 + 1;
        t[i].u4 = t[i].u3 + 1;
        t[i].ull1 = (unsigned long long) i << 32;
        t[i].ull2 = t[i].ull1 + 1;
    }    

    if (sharedmem_close(&shm) != 0)
    {
        puts("sharedmem_close() failed");
        return 1;
    }
    
    return 0;
}
